/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTIfStatement
extends ASTNode
implements ICPPASTIfStatement,
IASTAmbiguityParent {
    private IASTExpression condition;
    private IASTStatement thenClause;
    private IASTStatement elseClause;
    private IASTDeclaration condDecl;
    private IScope scope;

    public CPPASTIfStatement() {
    }

    public CPPASTIfStatement(IASTDeclaration condition, IASTStatement thenClause, IASTStatement elseClause) {
        this.setConditionDeclaration(condition);
        this.setThenClause(thenClause);
        this.setElseClause(elseClause);
    }

    public CPPASTIfStatement(IASTExpression condition, IASTStatement thenClause, IASTStatement elseClause) {
        this.setConditionExpression(condition);
        this.setThenClause(thenClause);
        this.setElseClause(elseClause);
    }

    public CPPASTIfStatement copy() {
        CPPASTIfStatement copy = new CPPASTIfStatement();
        copy.setConditionDeclaration(this.condDecl == null ? null : this.condDecl.copy());
        copy.setConditionExpression(this.condition == null ? null : this.condition.copy());
        copy.setThenClause(this.thenClause == null ? null : this.thenClause.copy());
        copy.setElseClause(this.elseClause == null ? null : this.elseClause.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression getConditionExpression() {
        return this.condition;
    }

    public void setConditionExpression(IASTExpression condition) {
        this.assertNotFrozen();
        this.condition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
            this.condDecl = null;
        }
    }

    public IASTStatement getThenClause() {
        return this.thenClause;
    }

    public void setThenClause(IASTStatement thenClause) {
        this.assertNotFrozen();
        this.thenClause = thenClause;
        if (thenClause != null) {
            thenClause.setParent(this);
            thenClause.setPropertyInParent(THEN);
        }
    }

    public IASTStatement getElseClause() {
        return this.elseClause;
    }

    public void setElseClause(IASTStatement elseClause) {
        this.assertNotFrozen();
        this.elseClause = elseClause;
        if (elseClause != null) {
            elseClause.setParent(this);
            elseClause.setPropertyInParent(ELSE);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.condDecl != null && !this.condDecl.accept(action)) {
            return false;
        }
        if (this.thenClause != null && !this.thenClause.accept(action)) {
            return false;
        }
        if (this.elseClause != null && !this.elseClause.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.thenClause == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.thenClause = (IASTStatement)other;
        } else if (this.elseClause == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.elseClause = (IASTStatement)other;
        } else if (this.condition == child || this.condDecl == child) {
            if (other instanceof IASTExpression) {
                this.setConditionExpression((IASTExpression)other);
            } else if (other instanceof IASTDeclaration) {
                this.setConditionDeclaration((IASTDeclaration)other);
            }
        }
    }

    public IASTDeclaration getConditionDeclaration() {
        return this.condDecl;
    }

    public void setConditionDeclaration(IASTDeclaration d) {
        this.assertNotFrozen();
        this.condDecl = d;
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(CONDITION);
            this.condition = null;
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }
}

