/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPParameter
extends PlatformObject
implements ICPPParameter,
ICPPInternalBinding {
    private IType type = null;
    private IASTName[] declarations = null;

    public CPPParameter(IASTName name) {
        this.declarations = new IASTName[]{name};
    }

    public CPPParameter(IType type) {
        this.type = type;
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return null;
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        this.declarations = this.declarations == null ? new IASTName[]{name} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.declarations, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, name));
    }

    private IASTName getPrimaryDeclaration() {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length && this.declarations[i] != null) {
                IASTNode node = this.declarations[i].getParent();
                while (!(node instanceof IASTDeclaration)) {
                    node = node.getParent();
                }
                if (node instanceof IASTFunctionDefinition) {
                    return this.declarations[i];
                }
                ++i;
            }
            return this.declarations[0];
        }
        return null;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.getSimpleID();
        }
        return CharArrayUtils.EMPTY;
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getPrimaryDeclaration());
    }

    public IASTNode getPhysicalNode() {
        if (this.declarations != null) {
            return this.declarations[0];
        }
        return null;
    }

    public IType getType() {
        if (this.type == null && this.declarations != null) {
            IType t = CPPVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
            this.type = SemanticUtil.adjustParameterType(t, false);
        }
        return this.type;
    }

    public boolean isStatic() {
        return false;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    public boolean isGloballyQualified() {
        return false;
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        IASTNode[] ns = this.getDeclarations();
        if (ns == null) {
            return false;
        }
        int i = 0;
        while (i < ns.length && ns[i] != null) {
            IASTNode parent = ns[i].getParent();
            while (!(parent instanceof IASTParameterDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = ((IASTParameterDeclaration)parent).getDeclSpecifier();
            if (declSpec.getStorageClass() == storage) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IASTInitializer getDefaultValue() {
        if (this.declarations == null) {
            return null;
        }
        int i = 0;
        while (i < this.declarations.length && this.declarations[i] != null) {
            IASTNode parent = this.declarations[i].getParent();
            while (parent.getPropertyInParent() == IASTDeclarator.NESTED_DECLARATOR) {
                parent = parent.getParent();
            }
            IASTInitializer init = ((IASTDeclarator)parent).getInitializer();
            if (init != null) {
                return init;
            }
            ++i;
        }
        return null;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public boolean isExternC() {
        return false;
    }

    public String toString() {
        String name = this.getName();
        return name.length() != 0 ? name : "<unnamed>";
    }

    public IBinding getOwner() throws DOMException {
        return CPPVisitor.findEnclosingFunction(this.declarations[0]);
    }

    public IValue getInitialValue() {
        return null;
    }

    public static class CPPParameterProblem
    extends ProblemBinding
    implements ICPPParameter {
        public CPPParameterProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExternC() {
            return false;
        }

        public IValue getInitialValue() {
            return null;
        }
    }
}

