/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IInternalPDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNode
implements IInternalPDOMNode {
    private static final int TYPE = 0;
    private static final int PARENT = 4;
    protected static final int RECORD_SIZE = 8;
    private final PDOMLinkage fLinkage;
    protected final int record;
    private int cachedParentRecord;

    protected PDOMNode(PDOMLinkage linkage, int record) {
        this.fLinkage = linkage;
        this.record = record;
    }

    protected PDOMNode(PDOMLinkage linkage, PDOMNode parent) throws CoreException {
        this(linkage.getDB(), linkage, parent == null ? 0 : parent.getRecord());
    }

    protected PDOMNode(Database db) throws CoreException {
        this(db, null, 0);
    }

    protected PDOMNode(Database db, PDOMLinkage linkage, int parentRec) throws CoreException {
        this.fLinkage = linkage;
        this.record = db.malloc(this.getRecordSize());
        db.putInt(this.record + 0, this.getNodeType());
        this.cachedParentRecord = parentRec;
        db.putInt(this.record + 4, parentRec);
    }

    protected Database getDB() {
        return this.fLinkage.getDB();
    }

    public PDOM getPDOM() {
        return this.fLinkage.getPDOM();
    }

    public PDOMLinkage getLinkage() throws CoreException {
        return this.fLinkage;
    }

    protected abstract int getRecordSize();

    public abstract int getNodeType();

    public final int getRecord() {
        return this.record;
    }

    public final int getBindingID() {
        return this.record;
    }

    public boolean isChildOf(PDOMNode other) {
        try {
            return other.fLinkage == this.fLinkage && other.record == this.getParentNodeRec();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMNode) {
            PDOMNode other = (PDOMNode)obj;
            return this.getPDOM() == other.getPDOM() && this.record == other.record;
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return System.identityHashCode(this.getPDOM()) + 41 * this.record;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
    }

    public static int getNodeType(Database db, int record) throws CoreException {
        return db.getInt(record + 0);
    }

    public int getParentNodeRec() throws CoreException {
        if (this.cachedParentRecord != 0) {
            return this.cachedParentRecord;
        }
        this.cachedParentRecord = this.getDB().getInt(this.record + 4);
        return this.cachedParentRecord;
    }

    public PDOMNode getParentNode() throws CoreException {
        int parentrec = this.getParentNodeRec();
        return parentrec != 0 ? this.getLinkage().getNode(parentrec) : null;
    }

    public void addChild(PDOMNode child) throws CoreException {
    }

    protected byte getByte(int offset) {
        try {
            return this.getDB().getByte(offset);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    protected boolean getBit(int bitVector, int offset) {
        int mask = 1 << offset;
        return (bitVector & mask) == mask;
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        this.getDB().free(this.record);
    }
}

