/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LocationAdapter<T> {
    public static final LocationAdapter<IPath> PATH = new LocationAdapter<IPath>(){

        @Override
        public String extractName(IPath location) {
            String name = location.lastSegment();
            if (name != null) {
                return name;
            }
            return location.toString();
        }

        @Override
        public IFile[] platformsFindFilesForLocation(IPath location) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.findFilesForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute()));
        }

        @Override
        public String getCanonicalPath(IPath location) {
            File file = location.toFile();
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }

        @Override
        public IPath getLocation(IFile file) {
            return file.getLocation();
        }
    };
    public static final LocationAdapter<URI> URI = new LocationAdapter<URI>(){

        @Override
        public String extractName(URI location) {
            String path = location.getPath();
            int idx = path.lastIndexOf(47);
            return path.substring(idx + 1);
        }

        @Override
        public IFile[] platformsFindFilesForLocation(URI location) {
            return ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location);
        }

        @Override
        public String getCanonicalPath(URI location) {
            if (!"file".equals(location.getScheme())) {
                return null;
            }
            String path = location.getPath();
            try {
                return new File(path).getCanonicalPath();
            }
            catch (IOException iOException) {
                return path;
            }
        }

        @Override
        public URI getLocation(IFile file) {
            return file.getLocationURI();
        }
    };

    LocationAdapter() {
    }

    public abstract String extractName(T var1);

    public abstract IFile[] platformsFindFilesForLocation(T var1);

    public abstract String getCanonicalPath(T var1);

    public abstract T getLocation(IFile var1);
}

