/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunction
extends PDOMCPPBinding
implements ICPPFunction,
IPDOMOverloader {
    private static final int NUM_PARAMS = 28;
    private static final int FIRST_PARAM = 32;
    protected static final int FUNCTION_TYPE = 36;
    private static final int SIGNATURE_HASH = 40;
    protected static final int EXCEPTION_SPEC = 44;
    private static final int ANNOTATION = 48;
    protected static final int RECORD_SIZE = 49;
    private byte annotation = (byte)-1;

    public PDOMCPPFunction(PDOMLinkage linkage, PDOMNode parent, ICPPFunction function, boolean setTypes) throws CoreException, DOMException {
        super(linkage, parent, function.getNameCharArray());
        Database db = this.getDB();
        Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(function);
        this.getDB().putInt(this.record + 40L, sigHash != null ? sigHash : 0);
        if (setTypes) {
            this.initData(function.getType(), function.getParameters());
        }
        db.putByte(this.record + 48L, PDOMCPPAnnotation.encodeAnnotation(function));
        this.storeExceptionSpec(db, function);
    }

    public void initData(ICPPFunctionType ftype, IParameter[] params) {
        try {
            PDOMCPPFunctionType pft = this.setType(ftype);
            this.setParameters(pft, params);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPFunction) {
            byte newAnnotation;
            IParameter[] newParams;
            ICPPFunctionType newType;
            ICPPFunction func = (ICPPFunction)newBinding;
            try {
                newType = func.getType();
                newParams = func.getParameters();
                newAnnotation = PDOMCPPAnnotation.encodeAnnotation(func);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
            ICPPFunctionType oldType = this.getType();
            PDOMCPPParameter oldParams = this.getFirstParameter();
            PDOMCPPFunctionType pft = this.setType(newType);
            this.setParameters(pft, newParams);
            if (oldType != null) {
                linkage.deleteType(oldType, this.record);
            }
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
            Database db = this.getDB();
            db.putByte(this.record + 48L, newAnnotation);
            this.annotation = newAnnotation;
            long oldRec = db.getRecPtr(this.record + 44L);
            this.storeExceptionSpec(db, func);
            if (oldRec != 0L) {
                PDOMCPPTypeList.clearTypes(this, oldRec);
            }
        }
    }

    private void storeExceptionSpec(Database db, ICPPFunction binding) throws CoreException {
        long typelist = 0L;
        try {
            if (!(binding instanceof ICPPMethod) || !((ICPPMethod)binding).isImplicit()) {
                typelist = PDOMCPPTypeList.putTypes(this, binding.getExceptionSpecification());
            }
        }
        catch (DOMException dOMException) {}
        db.putRecPtr(this.record + 44L, typelist);
    }

    private void setParameters(PDOMCPPFunctionType pft, IParameter[] params) throws CoreException {
        Database db = this.getDB();
        db.putInt(this.record + 28L, params.length);
        db.putRecPtr(this.record + 32L, 0L);
        IType[] paramTypes = pft.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            long ptRecord = i < paramTypes.length && paramTypes[i] != null ? ((PDOMNode)((Object)paramTypes[i])).getRecord() : 0L;
            this.setFirstParameter(new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), this, params[i], ptRecord));
            ++i;
        }
    }

    private PDOMCPPFunctionType setType(ICPPFunctionType ft) throws CoreException {
        PDOMCPPFunctionType pft = (PDOMCPPFunctionType)((PDOMLinkage)this.getLinkage()).addType(this, ft);
        this.getDB().putRecPtr(this.record + 36L, pft.getRecord());
        this.getPDOM().putCachedResult(this.record, pft, true);
        return pft;
    }

    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 40L);
    }

    public static int getSignatureHash(PDOMLinkage linkage, long record) throws CoreException {
        return linkage.getDB().getInt(record + 40L);
    }

    public PDOMCPPFunction(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 49;
    }

    public int getNodeType() {
        return 7;
    }

    private PDOMCPPParameter getFirstParameter() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 32L);
        return rec != 0L ? new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstParameter(PDOMCPPParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        long rec = param != null ? param.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 32L, rec);
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getAnnotation(), 2);
    }

    protected final byte getAnnotation() {
        if (this.annotation == -1) {
            this.annotation = this.getByte(this.record + 48L);
        }
        return this.annotation;
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.getAnnotation(), 6);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.getDB().getInt(this.record + 28L);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public final ICPPFunctionType getType() {
        PDOM pdom = this.getPDOM();
        ICPPFunctionType ftype = (ICPPFunctionType)pdom.getCachedResult(this.record);
        if (ftype == null) {
            ftype = this.readFunctionType();
            pdom.putCachedResult(this.record, ftype, false);
        }
        return ftype;
    }

    private final ICPPFunctionType readFunctionType() {
        try {
            long offset = this.getDB().getRecPtr(this.record + 36L);
            return offset == 0L ? null : new PDOMCPPFunctionType((PDOMLinkage)this.getLinkage(), offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getAnnotation(), 1);
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getAnnotation(), 4);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getAnnotation(), 5);
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    protected static int compareSignatures(IPDOMOverloader a, Object b) {
        if (b instanceof IPDOMOverloader) {
            IPDOMOverloader bb = (IPDOMOverloader)b;
            try {
                int mySM = a.getSignatureHash();
                int otherSM = bb.getSignatureHash();
                return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        } else {
            throw new PDOMNotImplementedError(b.getClass().toString());
        }
        return 0;
    }

    public IType[] getExceptionSpecification() throws DOMException {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 44L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

