/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

class CopyAction
extends Action {
    private Rendering fRendering;
    private int fType = 1;

    public CopyAction(Rendering rendering) {
        this(rendering, 1);
    }

    public CopyAction(Rendering rendering, int clipboardType) {
        this.fType = clipboardType;
        this.fRendering = rendering;
        this.setText(DebugUIMessages.CopyViewToClipboardAction_title);
        this.setToolTipText(DebugUIMessages.CopyViewToClipboardAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_COPY_VIEW_TO_CLIPBOARD"));
    }

    public void run() {
        Clipboard clip = null;
        try {
            clip = new Clipboard(this.fRendering.getDisplay());
            BigInteger start = this.fRendering.getSelection().getStart();
            BigInteger end = this.fRendering.getSelection().getEnd();
            if (end == null) {
                return;
            }
            if (start.compareTo(end) > 0) {
                BigInteger bigI = end;
                end = start;
                start = bigI;
            }
            int radix = this.fRendering.getRadix();
            int bytesPerColumn = this.fRendering.getBytesPerColumn();
            boolean isLittleEndian = this.fRendering.isTargetLittleEndian();
            int columns = this.fRendering.getColumnCount();
            BigInteger lengthToRead = end.subtract(start);
            int rows = lengthToRead.divide(BigInteger.valueOf(columns * bytesPerColumn)).intValue();
            if (rows * columns * bytesPerColumn < lengthToRead.intValue()) {
                ++rows;
            }
            StringBuffer buffer = new StringBuffer();
            int row = 0;
            while (row < rows) {
                MemoryByte[] bytes;
                BigInteger cellAddress;
                int col;
                BigInteger rowAddress = start.add(BigInteger.valueOf(row * columns * bytesPerColumn));
                if (this.fRendering.getPaneVisible(1)) {
                    buffer.append(this.fRendering.getAddressString(rowAddress));
                    buffer.append("  ");
                }
                if (this.fRendering.getPaneVisible(2)) {
                    col = 0;
                    while (col < columns) {
                        cellAddress = rowAddress.add(BigInteger.valueOf(col * bytesPerColumn));
                        if (cellAddress.compareTo(end) < 0) {
                            try {
                                bytes = this.fRendering.getBytes(cellAddress, bytesPerColumn);
                                buffer.append(this.fRendering.getRadixText(bytes, radix, isLittleEndian));
                            }
                            catch (DebugException de) {
                                this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                                if (clip != null) {
                                    clip.dispose();
                                }
                                return;
                            }
                        } else {
                            int i = this.fRendering.getRadixCharacterCount(radix, bytesPerColumn);
                            while (i > 0) {
                                buffer.append(' ');
                                --i;
                            }
                        }
                        if (col != columns - 1) {
                            buffer.append(' ');
                        }
                        ++col;
                    }
                }
                if (this.fRendering.getPaneVisible(2) && this.fRendering.getPaneVisible(3)) {
                    buffer.append("  ");
                }
                if (this.fRendering.getPaneVisible(3)) {
                    col = 0;
                    while (col < columns) {
                        cellAddress = rowAddress.add(BigInteger.valueOf(col * this.fRendering.getBytesPerColumn()));
                        if (cellAddress.compareTo(end) < 0) {
                            try {
                                bytes = this.fRendering.getBytes(cellAddress, this.fRendering.getBytesPerColumn());
                                buffer.append(this.fRendering.formatText(bytes, isLittleEndian, this.fRendering.getTextMode()));
                            }
                            catch (DebugException de) {
                                this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                                if (clip != null) {
                                    clip.dispose();
                                }
                                return;
                            }
                        }
                        ++col;
                    }
                }
                buffer.append("\n");
                ++row;
            }
            if (buffer.length() > 0) {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                clip.setContents(new Object[]{buffer.toString()}, new Transfer[]{plainTextTransfer}, this.fType);
            }
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }
}

