/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public class GdbSteppingModeTarget
extends DsfSteppingModeTarget {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbSteppingModeTarget(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean supportsInstructionStepping() {
        Query<Boolean> supportInstructionStepping = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                IGDBBackend backend = (IGDBBackend)GdbSteppingModeTarget.this.fTracker.getService(IGDBBackend.class);
                if (backend != null) {
                    rm.setData((Object)(backend.getSessionType() != SessionType.CORE ? 1 : 0));
                } else {
                    rm.setData((Object)false);
                }
                rm.done();
            }
        };
        this.fExecutor.execute((Runnable)supportInstructionStepping);
        try {
            return (Boolean)supportInstructionStepping.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        return false;
    }
}

