/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.osgi.framework.BundleContext;

public class GdbPlugin
extends Plugin {
    public static boolean DEBUG = false;
    public static final String PLUGIN_ID = "org.eclipse.cdt.dsf.gdb";
    private static GdbPlugin plugin;
    private static BundleContext fgBundleContext;

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        plugin = this;
        DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.gdb/debug"));
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownActiveLaunches();
        plugin = null;
        super.stop(context);
        fgBundleContext = null;
    }

    public static GdbPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    private void shutdownActiveLaunches() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch && ((GdbLaunch)launch).getSession().isActive()) {
                final GdbLaunch gdbLaunch = (GdbLaunch)launch;
                Query<Object> launchShutdownQuery = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        gdbLaunch.shutdownSession((RequestMonitor)rm);
                    }
                };
                try {
                    gdbLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    break;
                }
                try {
                    launchShutdownQuery.get();
                }
                catch (InterruptedException e) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "InterruptedException while shutting down PDA debugger launch " + gdbLaunch, e.getCause()));
                }
                catch (ExecutionException e) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Exception while shutting down PDA debugger launch " + gdbLaunch, e.getCause()));
                }
            }
            ++n2;
        }
    }

    public static void debug(String message) {
        if (DEBUG) {
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.out.println(String.valueOf(partial) + "\\");
            }
            System.out.print(message);
        }
    }

    public static String getDebugTime() {
        StringBuilder traceBuilder = new StringBuilder();
        long time = System.currentTimeMillis();
        long seconds = time / 1000L % 1000L;
        if (seconds < 100L) {
            traceBuilder.append('0');
        }
        if (seconds < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(seconds);
        traceBuilder.append(',');
        long millis = time % 1000L;
        if (millis < 100L) {
            traceBuilder.append('0');
        }
        if (millis < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(millis);
        return traceBuilder.toString();
    }
}

