/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIInfoThreadsInfo
extends MIInfo {
    protected List<ThreadInfo> info;

    public CLIInfoThreadsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public List<ThreadInfo> getThreadInfo() {
        return this.info;
    }

    protected void parse() {
        this.info = new ArrayList<ThreadInfo>();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseThreadInfo(str.trim(), this.info);
                }
                ++i;
            }
        }
    }

    protected void parseThreadInfo(String str, List<ThreadInfo> info) {
        if (str.length() > 0) {
            Pattern pattern = Pattern.compile("(^\\*?\\s*\\d+)(\\s*Thread\\s*)(0x[0-9a-fA-F]+|-?\\d+)(\\s*\\(LWP\\s*)(\\d*)", 8);
            Matcher matcher = pattern.matcher(str);
            boolean isCurrentThread = false;
            if (matcher.find()) {
                String id = matcher.group(1).trim();
                if (id.charAt(0) == '*') {
                    isCurrentThread = true;
                    id = id.substring(1).trim();
                }
                info.add(new ThreadInfo(id, matcher.group(5), "", isCurrentThread));
            }
        }
    }

    public class ThreadInfo {
        String fName;
        String fGdbId;
        String fPid;
        boolean fIsCurrentThread = false;

        public ThreadInfo(String tid, String pid, String name, boolean isCurrentThread) {
            this.fName = name;
            this.fGdbId = tid;
            this.fPid = pid;
            this.fIsCurrentThread = isCurrentThread;
        }

        public String getName() {
            return this.fName;
        }

        public String getId() {
            return this.fGdbId;
        }

        public String getOsId() {
            return this.fPid;
        }

        public boolean isCurrentThread() {
            return this.fIsCurrentThread;
        }
    }
}

