/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.requestmonitor.answers;

import java.util.Arrays;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncQuicksort {
    static Executor fgExecutor = ImmediateExecutor.getInstance();

    public static void main(String[] args) {
        final int[] array = new int[]{5, 7, 8, 3, 2, 1, 9, 5, 4};
        System.out.println("To sort: " + Arrays.toString(array));
        AsyncQuicksort.asyncQuicksort(array, 0, array.length - 1, new RequestMonitor(fgExecutor, null){

            protected void handleCompleted() {
                System.out.println("Sorted: " + Arrays.toString(array));
            }
        });
    }

    static void asyncQuicksort(final int[] array, final int left, final int right, final RequestMonitor rm) {
        if (right > left) {
            int pivot = left;
            AsyncQuicksort.asyncPartition(array, left, right, pivot, new DataRequestMonitor<Integer>(fgExecutor, rm){

                protected void handleCompleted() {
                    int newPivot = (Integer)this.getData();
                    AsyncQuicksort.printArray(array, left, right, newPivot);
                    CountingRequestMonitor countingRm = new CountingRequestMonitor(fgExecutor, rm);
                    AsyncQuicksort.asyncQuicksort(array, left, newPivot - 1, (RequestMonitor)countingRm);
                    AsyncQuicksort.asyncQuicksort(array, newPivot + 1, right, (RequestMonitor)countingRm);
                    countingRm.setDoneCount(2);
                }
            });
        } else {
            rm.done();
        }
    }

    static void asyncPartition(int[] array, int left, int right, int pivot, DataRequestMonitor<Integer> rm) {
        int pivotValue = array[pivot];
        array[pivot] = array[right];
        array[right] = pivotValue;
        int store = left;
        int i = left;
        while (i < right) {
            if (array[i] <= pivotValue) {
                int tmp = array[store];
                array[store] = array[i];
                array[i] = tmp;
                ++store;
            }
            ++i;
        }
        array[right] = array[store];
        array[store] = pivotValue;
        rm.setData((Object)store);
        rm.done();
    }

    static void printArray(int[] array, int left, int right, int pivot) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            if (i == left) {
                buffer.append('>');
            } else if (i == pivot) {
                buffer.append('-');
            } else {
                buffer.append(' ');
            }
            buffer.append(array[i]);
            if (i == right) {
                buffer.append('<');
            } else if (i == pivot) {
                buffer.append('-');
            } else {
                buffer.append(' ');
            }
            ++i;
        }
        System.out.println(buffer);
    }
}

