/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConfigurationV2;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.ConfigurationV2;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Target
extends BuildObject
implements ITarget {
    private static final String EMPTY_STRING = new String();
    private static final IConfigurationV2[] emptyConfigs = new IConfigurationV2[0];
    private String artifactName;
    private String binaryParserId;
    private String cleanCommand;
    private List configList;
    private Map configMap;
    private String defaultExtension;
    private Map depCalculatorsMap;
    private String errorParserIds;
    private String extension;
    private boolean isAbstract = false;
    private boolean isDirty = false;
    private boolean isTest = false;
    private String makeArguments;
    private String makeCommand;
    private IResource owner;
    private ITarget parent;
    private boolean resolved = true;
    private List targetArchList;
    private List targetOSList;
    private List toolList;
    private Map toolMap;
    private List toolReferences;
    private ProjectType createdProjectType;
    private String scannerInfoCollectorId;

    public Target(IManagedConfigElement element, String managedBuildRevision) {
        String arch;
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.setId(element.getAttribute("id"));
        this.setManagedBuildRevision(managedBuildRevision);
        ManagedBuildManager.addExtensionTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        this.binaryParserId = element.getAttribute("binaryParser");
        this.errorParserIds = element.getAttribute("errorParsers");
        this.defaultExtension = element.getAttribute("defaultExtension");
        this.isAbstract = "true".equals(element.getAttribute("isAbstract"));
        this.isTest = "true".equals(element.getAttribute("isTest"));
        this.cleanCommand = element.getAttribute("cleanCommand");
        this.makeCommand = element.getAttribute("makeCommand");
        this.makeArguments = element.getAttribute("makeArguments");
        this.scannerInfoCollectorId = element.getAttribute("scannerInfoCollector");
        String os = element.getAttribute("osList");
        if (os != null) {
            this.targetOSList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.targetOSList.add(osTokens[i].trim());
                ++i;
            }
        }
        if ((arch = element.getAttribute("archList")) != null) {
            this.targetArchList = new ArrayList();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.targetArchList.add(archTokens[j].trim());
                ++j;
            }
        }
        IManagedConfigElement[] toolRefs = element.getChildren("toolReference");
        int k = 0;
        while (k < toolRefs.length) {
            new ToolReference((BuildObject)this, toolRefs[k]);
            ++k;
        }
        IManagedConfigElement[] tools = element.getChildren("tool");
        int m = 0;
        while (m < tools.length) {
            Tool newTool = new Tool((IBuildObject)this, tools[m], managedBuildRevision);
            this.addTool(newTool);
            ++m;
        }
        IManagedConfigElement[] configs = element.getChildren("configuration");
        int n = 0;
        while (n < configs.length) {
            new ConfigurationV2(this, configs[n]);
            ++n;
        }
    }

    protected Target(IResource owner) {
        this.owner = owner;
    }

    public Target(IResource owner, ITarget parent) {
        this(owner);
        this.parent = parent;
        int id = ManagedBuildManager.getRandomNumber();
        this.setId(String.valueOf(owner.getName()) + "." + parent.getId() + "." + id);
        this.setName(parent.getName());
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        this.setArtifactName(parent.getArtifactName());
        this.binaryParserId = parent.getBinaryParserId();
        this.errorParserIds = parent.getErrorParserIds();
        this.defaultExtension = parent.getArtifactExtension();
        this.isTest = parent.isTestTarget();
        this.cleanCommand = parent.getCleanCommand();
        this.scannerInfoCollectorId = ((Target)parent).scannerInfoCollectorId;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(owner);
        buildInfo.addTarget(this);
    }

    public Target(ManagedBuildInfo buildInfo, Element element) {
        this(buildInfo.getOwner());
        String parentId;
        this.setId(element.getAttribute("id"));
        buildInfo.addTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        if (element.hasAttribute("extension")) {
            this.extension = element.getAttribute("extension");
        }
        if ((parentId = element.getAttribute("parent")) != null) {
            this.parent = ManagedBuildManager.getTarget(null, parentId);
        }
        if ("true".equals(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        this.isTest = "true".equals(element.getAttribute("isTest"));
        if (element.hasAttribute("cleanCommand")) {
            this.cleanCommand = element.getAttribute("cleanCommand");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("makeCommand")) {
            this.makeCommand = element.getAttribute("makeCommand");
        }
        if (element.hasAttribute("makeArguments")) {
            this.makeArguments = element.getAttribute("makeArguments");
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("configuration")) {
                new ConfigurationV2(this, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    public void addConfiguration(IConfigurationV2 configuration) {
        this.getConfigurationList().add(configuration);
        this.getConfigurationMap().put(configuration.getId(), configuration);
    }

    public void addTool(ITool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public void addToolReference(ToolReference toolRef) {
        this.getLocalToolReferences().add(toolRef);
    }

    private void addToolsToArray(Vector toolArray) {
        if (this.parent != null) {
            ((Target)this.parent).addToolsToArray(toolArray);
        }
        toolArray.addAll(this.getToolList());
        toolArray.addAll(this.getLocalToolReferences());
    }

    public IConfigurationV2 createConfiguration(IConfigurationV2 parent, String id) {
        this.isDirty = true;
        return new ConfigurationV2(this, parent, id);
    }

    public IConfigurationV2 createConfiguration(String id) {
        return new ConfigurationV2(this, id);
    }

    public String getArtifactExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.defaultExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return EMPTY_STRING;
        }
        return this.defaultExtension;
    }

    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    public String getBinaryParserId() {
        if (this.binaryParserId == null) {
            if (this.parent != null) {
                return this.parent.getBinaryParserId();
            }
            return EMPTY_STRING;
        }
        return this.binaryParserId;
    }

    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (Platform.getOS().equals("win32")) {
                return new String("del");
            }
            return new String("rm");
        }
        return this.cleanCommand;
    }

    public IConfigurationV2 getConfiguration(String id) {
        return (IConfigurationV2)this.getConfigurationMap().get(id);
    }

    private List getConfigurationList() {
        if (this.configList == null) {
            this.configList = new ArrayList();
        }
        return this.configList;
    }

    private Map getConfigurationMap() {
        if (this.configMap == null) {
            this.configMap = new HashMap();
        }
        return this.configMap;
    }

    public IConfigurationV2[] getConfigurations() {
        return this.getConfigurationList().toArray(new IConfigurationV2[this.getConfigurationList().size()]);
    }

    public String getDefaultExtension() {
        return this.defaultExtension == null ? EMPTY_STRING : this.defaultExtension;
    }

    private Map getDepCalcMap() {
        if (this.depCalculatorsMap == null) {
            this.depCalculatorsMap = new HashMap();
        }
        return this.depCalculatorsMap;
    }

    public String getErrorParserIds() {
        if (this.errorParserIds == null && this.parent != null) {
            return this.parent.getErrorParserIds();
        }
        return this.errorParserIds;
    }

    public String[] getErrorParserList() {
        String parserIDs = this.getErrorParserIds();
        String[] errorParsers = null;
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = CCorePlugin.getDefault().getAllErrorParsersIDs();
        }
        return errorParsers;
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        return this.toolReferences;
    }

    public String getMakeArguments() {
        if (this.makeArguments == null) {
            if (this.parent != null) {
                return this.parent.getMakeArguments();
            }
            return new String("");
        }
        return this.makeArguments;
    }

    public String getMakeCommand() {
        if (this.makeCommand == null) {
            if (this.parent != null) {
                return this.parent.getMakeCommand();
            }
            return new String("make");
        }
        return this.makeCommand;
    }

    public String getName() {
        if (this.name == null) {
            if (this.parent != null) {
                return this.parent.getName();
            }
            return new String("");
        }
        return this.name;
    }

    protected List getOptionReferences(ITool tool) {
        ArrayList<OptionReference> references = new ArrayList<OptionReference>();
        ToolReference toolRef = this.getToolReference(tool);
        if (toolRef != null) {
            references.addAll(toolRef.getOptionReferenceList());
        }
        if (this.parent != null) {
            List temp = ((Target)this.parent).getOptionReferences(tool);
            ListIterator iter = temp.listIterator();
            while (iter.hasNext()) {
                OptionReference ref = (OptionReference)iter.next();
                if (references.contains(ref)) continue;
                references.add(ref);
            }
        }
        return references;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public ITarget getParent() {
        return this.parent;
    }

    public String[] getTargetArchList() {
        if (this.targetArchList == null) {
            if (this.parent != null) {
                return this.parent.getTargetArchList();
            }
            return new String[]{"all"};
        }
        return this.targetArchList.toArray(new String[this.targetArchList.size()]);
    }

    public String[] getTargetOSList() {
        if (this.targetOSList == null) {
            if (this.parent != null) {
                return this.parent.getTargetOSList();
            }
            return new String[]{"all"};
        }
        return this.targetOSList.toArray(new String[this.targetOSList.size()]);
    }

    public ITool getTool(String id) {
        ITool result = null;
        result = (ITool)this.getToolMap().get(id);
        if (result == null && this.parent != null) {
            result = ((Target)this.parent).getTool(id);
        }
        if (result == null) {
            result = ManagedBuildManager.getExtensionTool(id);
        }
        return result;
    }

    private List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
        }
        return this.toolMap;
    }

    private ToolReference getToolReference(ITool tool) {
        ToolReference ref = null;
        if (tool == null) {
            return ref;
        }
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            ToolReference temp = (ToolReference)iter.next();
            if (!temp.references(tool)) continue;
            ref = temp;
            break;
        }
        return ref;
    }

    public ITool[] getTools() {
        Vector toolArray = new Vector();
        this.addToolsToArray(toolArray);
        return toolArray.toArray(new ITool[toolArray.size()]);
    }

    public boolean hasOverridenMakeCommand() {
        return this.makeCommand != null && !this.makeCommand.equals(this.parent.getMakeCommand()) || this.makeArguments != null && !this.makeArguments.equals(this.parent.getMakeArguments());
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            if (!((IConfigurationV2)iter.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isTestTarget() {
        return this.isTest;
    }

    public boolean needsRebuild() {
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            if (!((IConfigurationV2)iter.next()).needsRebuild()) continue;
            return true;
        }
        return false;
    }

    public void removeConfiguration(String id) {
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            IConfigurationV2 config = (IConfigurationV2)iter.next();
            if (!config.getId().equals(id)) continue;
            this.getConfigurationList().remove(config);
            this.getConfigurationMap().remove(id);
            this.isDirty = true;
            break;
        }
    }

    public void resetMakeCommand() {
        if (this.makeCommand != null) {
            this.setDirty(true);
        }
        this.makeCommand = null;
        this.makeArguments = null;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            String parentId = element.getAttribute("parent");
            if (parentId != null) {
                this.parent = ManagedBuildManager.getTarget(null, parentId);
                ((Target)this.parent).resolveReferences();
                IConfigurationV2[] parentConfigs = this.parent.getConfigurations();
                int i = 0;
                while (i < parentConfigs.length) {
                    this.addConfiguration(parentConfigs[i]);
                    ++i;
                }
            }
            for (Tool current : this.getToolList()) {
                current.resolveReferences();
            }
            for (ToolReference current : this.getLocalToolReferences()) {
                current.resolveReferences();
            }
            for (ConfigurationV2 current : this.getConfigurationList()) {
                current.resolveReferences();
            }
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.getId());
        element.setAttribute("name", this.getName());
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        element.setAttribute("isAbstract", this.isAbstract ? "true" : "false");
        element.setAttribute("artifactName", this.getArtifactName());
        if (this.extension != null) {
            element.setAttribute("extension", this.extension);
        }
        element.setAttribute("isTest", this.isTest ? "true" : "false");
        if (this.makeCommand != null) {
            element.setAttribute("makeCommand", this.makeCommand);
        }
        if (this.makeArguments != null) {
            element.setAttribute("makeArguments", this.makeArguments);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            ConfigurationV2 config = (ConfigurationV2)iter.next();
            Element configElement = doc.createElement("configuration");
            element.appendChild(configElement);
            config.serialize(doc, configElement);
        }
        this.isDirty = false;
    }

    public void setArtifactExtension(String extension) {
        if (extension != null) {
            this.extension = extension;
            this.isDirty = true;
        }
    }

    public void setArtifactName(String name) {
        if (name != null) {
            this.artifactName = name;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            IConfigurationV2 config = (IConfigurationV2)iter.next();
            config.setDirty(isDirty);
        }
    }

    public void setErrorParserIds(String ids) {
        if (ids == null) {
            return;
        }
        String currentIds = this.getErrorParserIds();
        if (currentIds == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setMakeArguments(String makeArgs) {
        if (makeArgs != null && !this.getMakeArguments().equals(makeArgs)) {
            this.makeArguments = makeArgs;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    public void setMakeCommand(String command) {
        if (command != null && !this.getMakeCommand().equals(command)) {
            this.makeCommand = command;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    public void setRebuildState(boolean rebuild) {
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            ((IConfigurationV2)iter.next()).setRebuildState(rebuild);
        }
    }

    public void updateOwner(IResource resource) {
        if (!resource.equals((Object)this.owner)) {
            this.owner = resource;
        }
    }

    public void convertToProjectType(String managedBuildRevision) {
        ProjectType projectType;
        ProjectType parentProj = null;
        if (this.parent != null && (parentProj = this.parent.getCreatedProjectType()) == null) {
            this.parent.convertToProjectType(managedBuildRevision);
            parentProj = this.parent.getCreatedProjectType();
        }
        this.createdProjectType = projectType = new ProjectType(parentProj, this.getId(), this.getName(), managedBuildRevision);
        projectType.setIsAbstract(this.isAbstract);
        projectType.setIsTest(this.isTest);
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            int i;
            IToolReference[] toolRefs;
            IConfigurationV2 configV2 = (IConfigurationV2)iter.next();
            if (configV2.getCreatedConfig() != null) continue;
            IConfiguration configSuperClass = null;
            IConfigurationV2 parentV2 = configV2.getParent();
            if (parentV2 != null) {
                configSuperClass = parentV2.getCreatedConfig();
            }
            String id = configV2.getId();
            String name = configV2.getName();
            IConfiguration config = projectType.createConfiguration(configSuperClass, id, name);
            configV2.setCreatedConfig(config);
            config.setArtifactName(this.getArtifactName());
            config.setArtifactExtension(this.getArtifactExtension());
            config.setCleanCommand(this.getCleanCommand());
            config.setErrorParserIds(this.getErrorParserIds());
            String subId = String.valueOf(id) + ".toolchain";
            String subName = String.valueOf(name) + ".toolchain";
            IToolChain toolChain = config.createToolChain(null, subId, subName, true);
            toolChain.setIsAbstract(this.isAbstract);
            toolChain.setOSList(this.getTargetOSList());
            toolChain.setArchList(this.getTargetArchList());
            if (this.scannerInfoCollectorId != null && this.scannerInfoCollectorId.equals("org.eclipse.cdt.managedbuilder.internal.scannerconfig.DefaultGCCScannerInfoCollector")) {
                toolChain.setScannerConfigDiscoveryProfileId(ManagedBuildCPathEntryContainer.MM_PP_DISCOVERY_PROFILE_ID);
            }
            subId = String.valueOf(id) + ".builder";
            subName = String.valueOf(name) + ".builder";
            IBuilder builder = toolChain.createBuilder(null, subId, subName, true);
            builder.setIsAbstract(this.isAbstract);
            builder.setCommand(this.getMakeCommand());
            builder.setArguments(this.getMakeArguments());
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            if (element instanceof DefaultManagedConfigElement) {
                ((Builder)builder).setBuildFileGeneratorElement(((DefaultManagedConfigElement)element).getConfigurationElement());
            }
            subId = String.valueOf(id) + ".targetplatform";
            subName = String.valueOf(name) + ".targetplatform";
            ITargetPlatform targetPlatform = toolChain.createTargetPlatform(null, subId, subName, true);
            targetPlatform.setIsAbstract(this.isAbstract);
            targetPlatform.setOSList(this.getTargetOSList());
            targetPlatform.setArchList(this.getTargetArchList());
            targetPlatform.setBinaryParserList(new String[]{this.getBinaryParserId()});
            IToolReference[] configToolRefs = configV2.getToolReferences();
            Vector targetToolRefs = new Vector();
            this.addTargetToolReferences(targetToolRefs);
            if (targetToolRefs.size() > 0) {
                toolRefs = new IToolReference[targetToolRefs.size() + configToolRefs.length];
                i = 0;
                while (i < configToolRefs.length) {
                    toolRefs[i] = configToolRefs[i];
                    ++i;
                }
                Iterator localToolRefIter = targetToolRefs.iterator();
                while (localToolRefIter.hasNext()) {
                    toolRefs[i++] = (IToolReference)localToolRefIter.next();
                }
            } else {
                toolRefs = configToolRefs;
            }
            i = 0;
            while (i < toolRefs.length) {
                IToolReference toolRef = toolRefs[i];
                subId = String.valueOf(id) + "." + toolRef.getId();
                ITool newTool = toolChain.createTool(toolRef.getTool(), subId, toolRef.getName(), true);
                newTool.setToolCommand(toolRef.getRawToolCommand());
                newTool.setOutputPrefix(toolRef.getRawOutputPrefix());
                newTool.setOutputFlag(toolRef.getRawOutputFlag());
                newTool.setOutputsAttribute(toolRef.getRawOutputExtensions());
                ListIterator optRefIter = toolRef.getOptionReferenceList().listIterator();
                while (optRefIter.hasNext()) {
                    OptionReference optRef = (OptionReference)optRefIter.next();
                    subId = String.valueOf(id) + "." + optRef.getId();
                    IOption newOption = newTool.createOption(optRef.getOption(), subId, optRef.getName(), true);
                    newOption.setValue(optRef.getValue());
                    newOption.setValueType(optRef.getValueType());
                    ((Option)newOption).setWasOptRef(true);
                }
                ++i;
            }
            ITool[] configTools = configV2.getTools();
            int i2 = 0;
            while (i2 < configTools.length) {
                ITool tool = configTools[i2];
                if (!(tool instanceof ToolReference)) {
                    boolean found = false;
                    ITool[] tools = toolChain.getTools();
                    int j = 0;
                    while (j < tools.length) {
                        ITool currentTool = tools[j];
                        ITool supercurrentTool = currentTool.getSuperClass();
                        if (supercurrentTool != null && supercurrentTool.getId() == tool.getId()) {
                            found = true;
                            ((Tool)tool).setToolParent(null);
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        ((ToolChain)toolChain).addTool((Tool)tool);
                    }
                }
                ++i2;
            }
            ((ToolChain)toolChain).normalizeOutputExtensions();
        }
    }

    public void addTargetToolReferences(Vector toolRefs) {
        toolRefs.addAll(this.getLocalToolReferences());
        if (this.parent != null) {
            Target targetParent = (Target)this.parent;
            targetParent.addTargetToolReferences(toolRefs);
        }
    }

    public ProjectType getCreatedProjectType() {
        return this.createdProjectType;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }
}

