/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObjectProperties;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.IBuildPropertyChangeListener;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProject
extends BuildObject
implements IManagedProject,
IBuildPropertiesRestriction,
IBuildPropertyChangeListener {
    private IProjectType projectType;
    private String projectTypeId;
    private IResource owner;
    private Map<String, Configuration> configMap = Collections.synchronizedMap(new LinkedHashMap());
    private boolean isDirty = false;
    private boolean isValid = true;
    private boolean resolved = true;
    private BuildObjectProperties buildProperties;

    protected ManagedProject(IResource owner) {
        this.owner = owner;
    }

    public ManagedProject(IResource owner, IProjectType projectType) {
        this(owner);
        this.projectType = projectType;
        int id = ManagedBuildManager.getRandomNumber();
        this.setId(String.valueOf(owner.getName()) + "." + projectType.getId() + "." + id);
        this.setName(projectType.getName());
        this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(owner);
        buildInfo.setManagedProject(this);
        this.setDirty(true);
    }

    public ManagedProject(ICProjectDescription des) {
        this((IResource)des.getProject());
        int id = ManagedBuildManager.getRandomNumber();
        this.setId(String.valueOf(this.owner.getName()) + "." + des.getId() + "." + id);
        this.setName(des.getName());
    }

    public ManagedProject(ManagedBuildInfo buildInfo, ICStorageElement element, boolean loadConfigs, String managedBuildRevision) {
        this(buildInfo.getOwner());
        this.setManagedBuildRevision(managedBuildRevision);
        if (this.loadFromProject(element)) {
            boolean isSupportAvailable;
            boolean bl = isSupportAvailable = this.projectType != null ? this.projectType.checkForMigrationSupport() : true;
            if (!isSupportAvailable) {
                this.setValid(false);
            }
            if (loadConfigs) {
                StorableCdtVariables vars = null;
                ICStorageElement[] configElements = element.getChildren();
                int i = 0;
                while (i < configElements.length) {
                    ICStorageElement configElement = configElements[i];
                    if (configElement.getName().equals("configuration")) {
                        new Configuration(this, configElement, managedBuildRevision, false);
                    } else if (configElement.getName().equals("macros")) {
                        vars = new StorableCdtVariables(configElement, false);
                    }
                    ++i;
                }
                if (vars != null) {
                    for (Configuration cfg : this.getConfigurationCollection()) {
                        ((ToolChain)cfg.getToolChain()).addProjectVariables(vars);
                    }
                }
            }
        } else {
            this.setValid(false);
        }
        buildInfo.setManagedProject(this);
    }

    protected boolean loadFromProject(ICStorageElement element) {
        String artType;
        String props;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        this.projectTypeId = element.getAttribute("projectType");
        if (this.projectTypeId != null && this.projectTypeId.length() > 0) {
            this.projectType = ManagedBuildManager.getExtensionProjectType(this.projectTypeId);
            if (this.projectType == null) {
                return false;
            }
        }
        if ((props = element.getAttribute("buildProperties")) != null && props.length() != 0) {
            this.buildProperties = new BuildObjectProperties(props, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if ((artType = element.getAttribute("buildArtefactType")) != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(this, this);
            }
            try {
                this.buildProperties.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artType, true);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        return true;
    }

    public void serializeProjectInfo(ICStorageElement element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.projectType != null) {
            element.setAttribute("projectType", this.projectType.getId());
        }
        this.isDirty = false;
    }

    public void serialize(ICStorageElement element, boolean saveChildren) {
        this.serializeProjectInfo(element);
        if (saveChildren) {
            for (Configuration cfg : this.getConfigurationCollection()) {
                ICStorageElement configElement = element.createChild("configuration");
                cfg.serialize(configElement);
            }
        }
        this.isDirty = false;
    }

    @Override
    public IResource getOwner() {
        return this.owner;
    }

    @Override
    public void updateOwner(IResource resource) {
        if (!resource.equals((Object)this.owner)) {
            this.owner = resource;
        }
    }

    @Override
    public IProjectType getProjectType() {
        return this.projectType;
    }

    @Override
    public IConfiguration createConfiguration(IConfiguration parent, String id) {
        Configuration config = new Configuration(this, (Configuration)parent, id, false, false, false);
        ManagedBuildManager.performValueHandlerEvent(config, 1);
        return config;
    }

    @Override
    public IConfiguration createConfigurationClone(IConfiguration parent, String id) {
        Configuration config = new Configuration(this, (Configuration)parent, id, true, false, false);
        ManagedBuildManager.performValueHandlerEvent(config, 1);
        return config;
    }

    @Override
    public IConfiguration getConfiguration(String id) {
        return this.configMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConfiguration[] getConfigurations() {
        Map<String, Configuration> map = this.configMap;
        synchronized (map) {
            return this.configMap.values().toArray(new IConfiguration[this.configMap.size()]);
        }
    }

    @Override
    public void removeConfiguration(String id) {
        String removeId = id;
        if (!this.configMap.containsKey(id)) {
            return;
        }
        this.configMap.remove(removeId);
        this.setDirty(true);
    }

    public void addConfiguration(Configuration configuration) {
        if (!configuration.isTemporary()) {
            this.configMap.put(configuration.getId(), configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Configuration> getConfigurationCollection() {
        Map<String, Configuration> map = this.configMap;
        synchronized (map) {
            return new ArrayList<Configuration>(this.configMap.values());
        }
    }

    @Override
    public String getDefaultArtifactName() {
        String name = new String();
        String[] tokens = this.getOwner().getName().split("\\s");
        int index = 0;
        while (index < tokens.length) {
            name = String.valueOf(name) + tokens[index];
            ++index;
        }
        return name;
    }

    public boolean resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.projectTypeId != null && this.projectTypeId.length() > 0) {
                this.projectType = ManagedBuildManager.getExtensionProjectType(this.projectTypeId);
                if (this.projectType == null) {
                    return false;
                }
            }
            for (Configuration cfg : this.getConfigurationCollection()) {
                cfg.resolveReferences();
            }
        }
        return true;
    }

    @Override
    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        for (IConfiguration iConfiguration : this.getConfigurationCollection()) {
            if (!iConfiguration.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            for (IConfiguration iConfiguration : this.getConfigurationCollection()) {
                iConfiguration.setDirty(false);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getProjectType() != null) {
            return this.getProjectType().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(PluginVersionIdentifier version) {
    }

    @Override
    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        for (Configuration cfg : this.getConfigurationCollection()) {
            cfg.updateManagedBuildRevision(revision);
        }
    }

    public void setProjectType(IProjectType projectType) {
        if (this.projectType != projectType) {
            this.projectType = projectType;
            this.projectTypeId = this.projectType == null ? null : this.projectType.getId();
        }
    }

    public void applyConfiguration(Configuration cfg) {
        cfg.applyToManagedProject(this);
    }

    @Override
    public IBuildObjectProperties getBuildProperties() {
        if (this.buildProperties == null) {
            BuildObjectProperties parentProps = this.findBuildProperties();
            this.buildProperties = parentProps != null ? new BuildObjectProperties(parentProps, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this) : new BuildObjectProperties(this, this);
        }
        return this.buildProperties;
    }

    private BuildObjectProperties findBuildProperties() {
        if (this.buildProperties == null) {
            if (this.projectType != null) {
                return ((ProjectType)this.projectType).findBuildProperties();
            }
            return null;
        }
        return this.buildProperties;
    }

    @Override
    public void propertiesChanged() {
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            ((Configuration)cfgs[i]).propertiesChanged();
            ++i;
        }
    }

    public boolean supportsType(IBuildPropertyType type) {
        return this.supportsType(type.getId());
    }

    public boolean supportsValue(IBuildPropertyType type, IBuildPropertyValue value) {
        return this.supportsValue(type.getId(), value.getId());
    }

    @Override
    public boolean supportsType(String typeId) {
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            if (((Configuration)cfgs[i]).supportsType(typeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean supportsValue(String typeId, String valueId) {
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            if (((Configuration)cfgs[i]).supportsValue(typeId, valueId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String[] getRequiredTypeIds() {
        ArrayList<String> result = new ArrayList<String>();
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            result.addAll(Arrays.asList(((Configuration)cfgs[i]).getRequiredTypeIds()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getSupportedTypeIds() {
        ArrayList<String> result = new ArrayList<String>();
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            result.addAll(Arrays.asList(((Configuration)cfgs[i]).getSupportedTypeIds()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getSupportedValueIds(String typeId) {
        ArrayList<String> result = new ArrayList<String>();
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            result.addAll(Arrays.asList(((Configuration)cfgs[i]).getSupportedValueIds(typeId)));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean requiresType(String typeId) {
        IConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            if (((Configuration)cfgs[i]).requiresType(typeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

