/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.mylyn.internal.ui.CDTUIBridgePlugin;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

public class CDTUiUtil {
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final String SEPARATOR_CODEASSIST = "\u0000";
    public static final String ASSIST_MYLYN_TYPE = "org.eclipse.cdt.mylyn.cdtTypeProposalCategory";
    public static final String ASSIST_MYLYN_NOTYPE = "org.eclipse.cdt.mylyn.cdtNoTypeProposalCategory";
    public static final String ASSIST_CDT_TYPE = "org.eclipse.cdt.ui.cdtTypeProposalCategory";
    public static final String ASSIST_CDT_NOTYPE = "org.eclipse.cdt.ui.cdtNoTypeProposalCategory";
    public static final String ASSIST_CDT_TEMPLATE = "org.eclipse.cdt.ui.templateProposalCategory";
    public static final String ASSIST_MYLYN_TEMPLATE = "org.eclipse.cdt.mylyn.templateProposalCategory";

    public static void installContentAssist(IPreferenceStore cdtPrefs, boolean mylynContentAssist) {
        String oldValue = cdtPrefs.getString("content_assist_disabled_computers");
        StringTokenizer tokenizer = new StringTokenizer(oldValue, SEPARATOR_CODEASSIST);
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            disabledIds.add((String)tokenizer.nextElement());
        }
        if (!mylynContentAssist) {
            disabledIds.remove(ASSIST_CDT_TYPE);
            disabledIds.remove(ASSIST_CDT_NOTYPE);
            disabledIds.remove(ASSIST_CDT_TEMPLATE);
            disabledIds.add(ASSIST_MYLYN_NOTYPE);
            disabledIds.add(ASSIST_MYLYN_TYPE);
            disabledIds.add(ASSIST_MYLYN_TEMPLATE);
        } else {
            disabledIds.add(ASSIST_CDT_TYPE);
            disabledIds.add(ASSIST_CDT_NOTYPE);
            disabledIds.add(ASSIST_CDT_TEMPLATE);
            disabledIds.remove(ASSIST_MYLYN_NOTYPE);
            disabledIds.remove(ASSIST_MYLYN_TYPE);
            disabledIds.remove(ASSIST_MYLYN_TEMPLATE);
        }
        String newValue = "";
        for (String id : disabledIds) {
            newValue = String.valueOf(newValue) + id + SEPARATOR_CODEASSIST;
        }
        cdtPrefs.setValue("content_assist_disabled_computers", newValue);
    }

    public static ImageDescriptor decorate(ImageDescriptor base, int decorations) {
        CElementImageDescriptor imageDescriptor = new CElementImageDescriptor(base, decorations, SMALL_SIZE);
        return imageDescriptor;
    }

    public static ICElement getCDTElement(ConcreteMarker marker) {
        ITranslationUnit cu;
        block8: {
            if (marker == null) {
                return null;
            }
            IResource res = marker.getResource();
            cu = null;
            if (!(res instanceof IFile)) break block8;
            IFile file = (IFile)res;
            if (CoreModel.isValidTranslationUnitName(null, (String)file.getName())) {
                cu = CoreModelUtil.findTranslationUnit((IFile)file);
                break block8;
            }
            return null;
        }
        try {
            if (cu != null) {
                ICElement ce = cu.getElementAtOffset(marker.getMarker().getAttribute("charStart", 0));
                return ce;
            }
            return null;
        }
        catch (CModelException ex) {
            if (!ex.doesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), (String)CDTUIBridgePlugin.getResourceString("MylynCDT.error"), (String)CDTUIBridgePlugin.getResourceString("MylynCDT.findCElementFailure"));
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getFormattedString("MylynCDT.findElementFailure", new String[]{marker.toString()}), t));
            return null;
        }
    }

    public static String getFullyQualifiedName(ICElement ce) {
        if (ce.getParent() == null || ce.getParent() instanceof ICProject) {
            return ce.getElementName();
        }
        return String.valueOf(CDTUiUtil.getFullyQualifiedName(ce.getParent())) + "." + ce.getElementName();
    }
}

