/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.TreeMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class DefinitionFinder {
    public static IASTName getDefinition(IASTSimpleDeclaration simpleDeclaration, IFile file) throws CoreException {
        IASTDeclarator declarator = simpleDeclaration.getDeclarators()[0];
        IBinding resolveBinding = declarator.getName().resolveBinding();
        return DefinitionFinder.getDefinition(declarator.getName(), resolveBinding, file);
    }

    public static IASTName getDefinition(IASTName methodName, IBinding bind, IFile file) throws CoreException {
        IASTTranslationUnit transUnit;
        IIndexName[] pdomref;
        TreeMap parsedFiles;
        block8: {
            parsedFiles = new TreeMap();
            ITranslationUnit tu = (ITranslationUnit)CCorePlugin.getDefault().getCoreModel().create(file);
            IIndex index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
            pdomref = null;
            try {
                try {
                    index.acquireReadLock();
                    pdomref = index.findDefinitions(bind);
                }
                catch (InterruptedException e) {
                    Status status = new Status(2, "org.eclipse.cdt.ui", 0, e.getMessage(), (Throwable)e);
                    CUIPlugin.log((IStatus)status);
                    index.releaseReadLock();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                index.releaseReadLock();
                throw throwable;
            }
            index.releaseReadLock();
        }
        if (pdomref == null || pdomref.length < 1) {
            return null;
        }
        if (!parsedFiles.containsKey(pdomref[0].getFileLocation().getFileName())) {
            String filename = pdomref[0].getFileLocation().getFileName();
            transUnit = TranslationUnitHelper.loadTranslationUnit(filename, false);
        } else {
            transUnit = (IASTTranslationUnit)parsedFiles.get(pdomref[0].getFileLocation().getFileName());
        }
        return DefinitionFinder.findDefinitionInTranslationUnit(transUnit, pdomref[0]);
    }

    private static IASTName findDefinitionInTranslationUnit(IASTTranslationUnit transUnit, final IIndexName indexName) {
        final Container defName = new Container();
        transUnit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                if (name.isDefinition() && name.getNodeLocations().length > 0) {
                    IASTNodeLocation nodeLocation = name.getNodeLocations()[0];
                    if (indexName.getNodeOffset() == nodeLocation.getNodeOffset() && indexName.getNodeLength() == nodeLocation.getNodeLength() && new Path(indexName.getFileLocation().getFileName()).equals((Object)new Path(nodeLocation.asFileLocation().getFileName()))) {
                        defName.setObject(name);
                        return 2;
                    }
                }
                return 3;
            }
        });
        return (IASTName)defName.getObject();
    }
}

