/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.MembersGrouping;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IncludesGrouping;
import org.eclipse.cdt.ui.NamespacesGrouping;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BaseCElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;
    protected boolean fIncludesGrouping = false;
    protected boolean fNamespacesGrouping = false;
    protected boolean fMemberGrouping = false;

    public BaseCElementContentProvider() {
        this(false, false);
    }

    public BaseCElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideWorkingCopy;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public boolean areIncludesGroup() {
        return this.fIncludesGrouping;
    }

    public void setIncludesGrouping(boolean b) {
        this.fIncludesGrouping = b;
    }

    public boolean areNamespacesGroup() {
        return this.fNamespacesGrouping;
    }

    public void setNamespacesGrouping(boolean b) {
        this.fNamespacesGrouping = b;
    }

    public boolean isMemberGroupingEnabled() {
        return this.fMemberGrouping;
    }

    public void setMemberGrouping(boolean enable) {
        this.fMemberGrouping = enable;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof ICModel) {
                return this.getCProjects((ICModel)element);
            }
            if (element instanceof ICProject) {
                return this.getSourceRoots((ICProject)element);
            }
            if (element instanceof ICContainer) {
                return this.getCResources((ICContainer)element);
            }
            if (element instanceof ITranslationUnit) {
                if (this.fProvideMembers) {
                    IWorkingCopy copy;
                    ITranslationUnit tu = (ITranslationUnit)element;
                    if (this.fProvideWorkingCopy && !(element instanceof IWorkingCopy) && (copy = tu.findSharedWorkingCopy(CUIPlugin.getDefault().getBufferFactory())) != null) {
                        tu = copy;
                    }
                    return this.getTranslationUnitChildren(tu);
                }
            } else {
                if (element instanceof IBinary) {
                    return ((IBinary)element).getChildren();
                }
                if (element instanceof IArchive) {
                    return ((IArchive)element).getChildren();
                }
                if (element instanceof IBinaryModule) {
                    return ((IBinaryModule)element).getChildren();
                }
                if (element instanceof INamespace) {
                    return this.getNamespaceChildren((IParent)((INamespace)element));
                }
                if (element instanceof ISourceReference && element instanceof IParent) {
                    return ((IParent)element).getChildren();
                }
                if (element instanceof IProject) {
                    return this.getResources((IProject)element);
                }
                if (element instanceof IFolder) {
                    return this.getResources((IFolder)element);
                }
                if (element instanceof CElementGrouping) {
                    return ((CElementGrouping)((Object)element)).getChildren(element);
                }
            }
        }
        catch (CModelException cModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        ICContainer container;
        IResource resource;
        if (this.fProvideMembers) {
            if (element instanceof IBinary || element instanceof ITranslationUnit || element instanceof IArchive) {
                return true;
            }
        } else if (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive || element instanceof IFile) {
            return false;
        }
        if (element instanceof ICProject) {
            ICProject cp = (ICProject)element;
            return cp.getProject().isOpen();
        }
        if (element instanceof ICContainer && (resource = (container = (ICContainer)element).getResource()) instanceof IContainer) {
            try {
                return ((IContainer)resource).members().length > 0;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (element instanceof IParent && ((IParent)element).hasChildren()) {
            return true;
        }
        if (element instanceof CElementGrouping) {
            return true;
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    public Object internalGetParent(Object element) {
        IMember member;
        String ns;
        INamespace namespace;
        NamespacesGrouping grouping;
        IResource res;
        if (element instanceof IResource) {
            ICElement cParent;
            IContainer parent = ((IResource)element).getParent();
            if (parent != null && parent.isAccessible() && (cParent = CoreModel.getDefault().create((IResource)parent)) != null && cParent.exists()) {
                return cParent;
            }
            return parent;
        }
        Object parent = null;
        if (element instanceof ICElement) {
            parent = ((ICElement)element).getParent();
            if (parent instanceof IWorkingCopy) {
                parent = ((IWorkingCopy)parent).getOriginalElement();
            }
        } else if (element instanceof IWorkbenchAdapter) {
            parent = ((IWorkbenchAdapter)element).getParent(element);
        }
        if (parent instanceof ISourceRoot) {
            if (this.isProjectSourceRoot((ISourceRoot)parent)) {
                parent = ((ISourceRoot)parent).getCProject();
            }
        } else if ((parent instanceof IBinaryContainer || parent instanceof IArchiveContainer) && element instanceof ICElement && (res = ((ICElement)element).getResource()) != null) {
            parent = this.internalGetParent(res);
        }
        if (parent instanceof INamespace && this.fNamespacesGrouping && (grouping = new NamespacesGrouping((namespace = (INamespace)parent).getTranslationUnit(), namespace, this.fMemberGrouping)).getNamespaces().length > 2) {
            parent = grouping;
        }
        if (parent instanceof IMember && this.fMemberGrouping && (ns = BaseCElementContentProvider.getElementNamespace((ICElement)(member = (IMember)parent))) != null) {
            INamespace namespace2;
            NamespacesGrouping grouping2;
            Object parentParent = member.getParent();
            if (parentParent instanceof INamespace && this.fNamespacesGrouping && (grouping2 = new NamespacesGrouping((namespace2 = (INamespace)parent).getTranslationUnit(), namespace2)).getNamespaces().length > 2) {
                parentParent = grouping2;
            }
            return new MembersGrouping(parentParent, ns);
        }
        if (element instanceof IInclude && this.fIncludesGrouping) {
            parent = new IncludesGrouping(((IInclude)element).getTranslationUnit());
        }
        return parent;
    }

    protected Object[] getCProjects(ICModel cModel) throws CModelException {
        Object[] objects = cModel.getCProjects();
        try {
            Object[] nonC = cModel.getNonCResources();
            if (nonC.length > 0) {
                objects = BaseCElementContentProvider.concatenate(objects, nonC);
            }
        }
        catch (CModelException cModelException) {}
        return objects;
    }

    protected Object[] getSourceRoots(ICProject cproject) throws CModelException {
        if (!cproject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<ICElement> list = new ArrayList<ICElement>();
        ICElement[] children = cproject.getChildren();
        int i = 0;
        while (i < children.length) {
            ICElement child = children[i];
            if (child instanceof ISourceRoot && child.getResource().getType() == 4) {
                ICElement[] c2 = ((ISourceRoot)child).getChildren();
                int k = 0;
                while (k < c2.length) {
                    list.add(c2[k]);
                    ++k;
                }
            } else {
                list.add(child);
            }
            ++i;
        }
        Object[] objects = list.toArray();
        Object[] nonC = cproject.getNonCResources();
        if (nonC != null && nonC.length > 0) {
            nonC = this.filterNonCResources(nonC, cproject);
            objects = BaseCElementContentProvider.concatenate(objects, nonC);
        }
        return objects;
    }

    protected Object[] getTranslationUnitChildren(ITranslationUnit unit) throws CModelException {
        int i;
        ArrayList<Object> list;
        Object[] children = unit.getChildren();
        if (this.fIncludesGrouping) {
            boolean hasInclude = false;
            list = new ArrayList<Object>(children.length);
            i = 0;
            while (i < children.length) {
                if (!(children[i] instanceof IInclude)) {
                    list.add(children[i]);
                } else {
                    hasInclude = true;
                }
                ++i;
            }
            if (hasInclude) {
                list.add(0, (Object)new IncludesGrouping(unit));
            }
            children = list.toArray();
        }
        HashMap<String, NamespacesGrouping> nsmap = new HashMap<String, NamespacesGrouping>();
        if (this.fNamespacesGrouping) {
            list = new ArrayList(children.length);
            i = 0;
            while (i < children.length) {
                if (children[i] instanceof INamespace) {
                    INamespace n1 = (INamespace)children[i];
                    NamespacesGrouping namespacesGrouping = (NamespacesGrouping)((Object)nsmap.get(n1.getElementName()));
                    if (namespacesGrouping == null) {
                        namespacesGrouping = new NamespacesGrouping(unit, n1, this.fMemberGrouping);
                        if (namespacesGrouping.getNamespaces().length > 1) {
                            nsmap.put(n1.getElementName(), namespacesGrouping);
                            list.add((Object)namespacesGrouping);
                        } else {
                            list.add(children[i]);
                        }
                    }
                } else {
                    list.add(children[i]);
                }
                ++i;
            }
            children = list.toArray();
        }
        if (this.fMemberGrouping) {
            list = new ArrayList(children.length);
            HashMap<String, MembersGrouping> map = new HashMap<String, MembersGrouping>();
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2] instanceof IMember) {
                    ICElement member = (ICElement)children[i2];
                    String namespace = BaseCElementContentProvider.getElementNamespace(member);
                    MembersGrouping memberGrouping = (MembersGrouping)((Object)map.get(namespace));
                    if (memberGrouping == null) {
                        memberGrouping = new MembersGrouping(unit, namespace);
                        map.put(namespace, memberGrouping);
                        list.add((Object)memberGrouping);
                    }
                } else if (this.fNamespacesGrouping && children[i2] instanceof INamespace) {
                    if (!nsmap.containsKey(((INamespace)children[i2]).getElementName())) {
                        list.add(children[i2]);
                    }
                } else {
                    list.add(children[i2]);
                }
                ++i2;
            }
            children = list.toArray();
        }
        return children;
    }

    protected Object[] getNamespaceChildren(IParent element) throws CModelException {
        Object[] children = element.getChildren();
        if (this.fMemberGrouping) {
            ArrayList<Object> list = new ArrayList<Object>(children.length);
            HashMap<String, MembersGrouping> map = new HashMap<String, MembersGrouping>();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IMember) {
                    ICElement member = (ICElement)children[i];
                    String namespace = BaseCElementContentProvider.getElementNamespace(member);
                    MembersGrouping memberGrouping = (MembersGrouping)((Object)map.get(namespace));
                    if (memberGrouping == null) {
                        memberGrouping = new MembersGrouping(element, namespace);
                        map.put(namespace, memberGrouping);
                        list.add((Object)memberGrouping);
                    }
                } else {
                    list.add(children[i]);
                }
                ++i;
            }
            children = list.toArray();
        }
        return children;
    }

    private static String getElementNamespace(ICElement member) {
        String name = member.getElementName();
        int idx = name.lastIndexOf("::");
        if (idx < 0) {
            return null;
        }
        return name.substring(0, idx);
    }

    protected Object[] getCResources(ICContainer container) throws CModelException {
        Object[] objects = null;
        Object[] children = container.getChildren();
        try {
            objects = container.getNonCResources();
            if (objects.length > 0) {
                objects = this.filterNonCResources(objects, container.getCProject());
            }
        }
        catch (CModelException cModelException) {}
        if (objects == null || objects.length == 0) {
            return children;
        }
        return BaseCElementContentProvider.concatenate(children, objects);
    }

    protected Object[] getResources(IProject project) {
        try {
            return project.members();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected Object[] getResources(IFolder folder) throws CModelException {
        ICProject cproject = CoreModel.getDefault().create(folder.getProject());
        Object[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException coreException) {}
        if (members == null || members.length == 0) {
            return NO_CHILDREN;
        }
        return this.filterNonCResources(members, cproject);
    }

    private Object[] filterNonCResources(Object[] objects, ICProject cproject) throws CModelException {
        ICElement[] binaries = null;
        ICElement[] archives = null;
        try {
            binaries = this.getBinaries(cproject);
            archives = this.getArchives(cproject);
        }
        catch (CModelException cModelException) {
            archives = binaries = new ICElement[0];
        }
        ISourceRoot[] roots = null;
        try {
            roots = cproject.getSourceRoots();
        }
        catch (CModelException cModelException) {
            roots = new ISourceRoot[]{};
        }
        ArrayList<Object> nonCResources = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            block15: {
                Object o;
                block14: {
                    block13: {
                        o = objects[i];
                        if (!(o instanceof IFolder)) break block13;
                        IFolder folder = (IFolder)o;
                        boolean found = false;
                        int j = 0;
                        while (j < roots.length) {
                            if (roots[j].getPath().equals((Object)folder.getFullPath())) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) break block14;
                        break block15;
                    }
                    if (o instanceof IFile) {
                        boolean found = false;
                        int j = 0;
                        while (j < binaries.length) {
                            IResource res = binaries[j].getResource();
                            if (o.equals(res)) {
                                o = binaries[j];
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            j = 0;
                            while (j < archives.length) {
                                IResource res = archives[j].getResource();
                                if (o.equals(res)) {
                                    o = archives[j];
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                }
                nonCResources.add(o);
            }
            ++i;
        }
        return nonCResources.toArray();
    }

    protected boolean isProjectSourceRoot(ISourceRoot root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).exists();
        }
        return true;
    }

    protected IBinary[] getBinaries(ICProject cproject) throws CModelException {
        IBinaryContainer container = cproject.getBinaryContainer();
        return this.getBinaries(container);
    }

    protected IBinary[] getBinaries(IBinaryContainer container) throws CModelException {
        ICElement[] celements = container.getChildren();
        ArrayList<IBinary> list = new ArrayList<IBinary>(celements.length);
        int i = 0;
        while (i < celements.length) {
            if (celements[i] instanceof IBinary) {
                IBinary bin = (IBinary)celements[i];
                list.add(bin);
            }
            ++i;
        }
        IBinary[] bins = new IBinary[list.size()];
        list.toArray(bins);
        return bins;
    }

    protected IArchive[] getArchives(ICProject cproject) throws CModelException {
        IArchiveContainer container = cproject.getArchiveContainer();
        return this.getArchives(container);
    }

    protected IArchive[] getArchives(IArchiveContainer container) throws CModelException {
        ICElement[] celements = container.getChildren();
        ArrayList<IArchive> list = new ArrayList<IArchive>(celements.length);
        int i = 0;
        while (i < celements.length) {
            if (celements[i] instanceof IArchive) {
                IArchive ar = (IArchive)celements[i];
                list.add(ar);
            }
            ++i;
        }
        IArchive[] ars = new IArchive[list.size()];
        list.toArray(ars);
        return ars;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

