/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.internal.ui.text.CHeaderRule;
import org.eclipse.cdt.internal.ui.text.CWhitespaceRule;
import org.eclipse.cdt.internal.ui.text.PreprocessorRule;
import org.eclipse.cdt.internal.ui.text.util.CWordDetector;
import org.eclipse.cdt.ui.text.AbstractCScanner;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPreprocessorScanner
extends AbstractCScanner {
    private static String[] fgTokenProperties = new String[]{"c_keyword", "pp_directive", "pp_default", "c_type", "c_string", "pp_header"};
    private ICLanguageKeywords fKeywords;

    public CPreprocessorScanner(ITokenStoreFactory factory, ICLanguageKeywords keywords) {
        super(factory.createTokenStore(fgTokenProperties));
        this.fKeywords = keywords;
        this.setRules(this.createRules());
    }

    protected List<IRule> createRules() {
        IToken defaultToken = this.getToken("pp_default");
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add(new CWhitespaceRule(defaultToken));
        IToken token = this.getToken("pp_directive");
        PreprocessorRule preprocessorRule = new PreprocessorRule(new CWordDetector(), defaultToken);
        String[] ppKeywords = this.fKeywords.getPreprocessorKeywords();
        int i = 0;
        while (i < ppKeywords.length) {
            preprocessorRule.addWord(ppKeywords[i], token);
            ++i;
        }
        preprocessorRule.addWord("##", token);
        rules.add((IRule)preprocessorRule);
        WordRule wordRule = new WordRule((IWordDetector)new CWordDetector(), defaultToken);
        token = this.getToken("c_keyword");
        String[] keywords = this.fKeywords.getKeywords();
        int i2 = 0;
        while (i2 < keywords.length) {
            wordRule.addWord(keywords[i2], token);
            ++i2;
        }
        token = this.getToken("c_type");
        String[] types = this.fKeywords.getBuiltinTypes();
        int i3 = 0;
        while (i3 < types.length) {
            wordRule.addWord(types[i3], token);
            ++i3;
        }
        rules.add((IRule)wordRule);
        token = this.getToken("pp_header");
        CHeaderRule headerRule = new CHeaderRule(token);
        rules.add(headerRule);
        token = this.getToken("c_string");
        PatternRule stringRule = new PatternRule("\"", "\"", token, '\\', true, true, true);
        rules.add((IRule)stringRule);
        token = this.getToken("c_string");
        PatternRule charRule = new PatternRule("'", "'", token, '\\', true, true, true);
        rules.add((IRule)charRule);
        this.setDefaultReturnToken(defaultToken);
        return rules;
    }
}

