/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.IContributedContentsView;

public class ManageFunctionBreakpointActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ToggleBreakpointAdapter fBreakpointAdapter = new ToggleBreakpointAdapter();
    private IWorkbenchPart fTargetPart;
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        try {
            this.getBreakpointAdapter().toggleMethodBreakpoints(this.getTargetPart(), this.getSelection());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("ManageFunctionBreakpointActionDelegate.Error_1"), (String)ActionMessages.getString("ManageFunctionBreakpointActionDelegate.Operation_failed_1"), (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        action.setEnabled(this.getBreakpointAdapter().canToggleMethodBreakpoints(this.getTargetPart(), this.getSelection()));
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private ISelection getSelection() {
        return this.fSelection;
    }

    private IToggleBreakpointsTarget getBreakpointAdapter() {
        ToggleBreakpointAdapter targetAdapter = null;
        if (this.fTargetPart != null) {
            IWorkbenchPart contributingPart;
            IContributedContentsView contentsView;
            IResource resource = (IResource)this.fTargetPart.getAdapter(IResource.class);
            if (resource == null && this.fTargetPart instanceof IEditorPart) {
                resource = (IResource)((IEditorPart)this.fTargetPart).getEditorInput().getAdapter(IResource.class);
            }
            if (resource == null && (contentsView = (IContributedContentsView)this.fTargetPart.getAdapter(IContributedContentsView.class)) != null && (contributingPart = contentsView.getContributingPart()) != null && (resource = (IResource)contributingPart.getAdapter(IResource.class)) == null && contributingPart instanceof IEditorPart) {
                resource = (IResource)((IEditorPart)contributingPart).getEditorInput().getAdapter(IResource.class);
            }
            if (resource != null) {
                targetAdapter = (IToggleBreakpointsTarget)resource.getAdapter(IToggleBreakpointsTarget.class);
            }
            if (targetAdapter == null) {
                targetAdapter = (IToggleBreakpointsTarget)this.fTargetPart.getAdapter(IToggleBreakpointsTarget.class);
            }
        }
        if (targetAdapter == null) {
            targetAdapter = this.fBreakpointAdapter;
        }
        return targetAdapter;
    }

    private void setSelection(ISelection selection) {
        this.fSelection = selection;
    }
}

