/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.Separator;
import org.eclipse.cdt.debug.internal.ui.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RegisterGroupDialog
extends TitleAreaDialog {
    private StringDialogField fNameField;
    private CheckedListDialogField fListField;
    private String fName;
    private IRegisterDescriptor[] fDescriptors;

    public RegisterGroupDialog(Shell parentShell, IRegisterDescriptor[] allRegisters) {
        this(parentShell, ActionMessages.getString("RegisterGroupDialog.0"), allRegisters, new IRegisterDescriptor[0]);
    }

    public RegisterGroupDialog(Shell parentShell, String groupName, IRegisterDescriptor[] allRegisters, IRegisterDescriptor[] groupRegisters) {
        super(parentShell);
        this.fName = groupName;
        this.fDescriptors = groupRegisters;
        String[] buttonLabels = new String[]{ActionMessages.getString("RegisterGroupDialog.1"), ActionMessages.getString("RegisterGroupDialog.2")};
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(ActionMessages.getString("RegisterGroupDialog.3"));
        this.fNameField.setTextWithoutUpdate(groupName);
        this.fNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                RegisterGroupDialog.this.update();
            }
        });
        this.fListField = new CheckedListDialogField(new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
            }

            public void selectionChanged(DialogField field) {
            }
        }, buttonLabels, (ILabelProvider)new RegisterLabelProvider());
        this.fListField.setLabelText(ActionMessages.getString("RegisterGroupDialog.4"));
        this.fListField.setCheckAllButtonIndex(0);
        this.fListField.setUncheckAllButtonIndex(1);
        this.fListField.setElements(Arrays.asList(allRegisters));
        this.fListField.setCheckedElements(Arrays.asList(groupRegisters));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(ActionMessages.getString("RegisterGroupDialog.5"));
        this.setTitle(ActionMessages.getString("RegisterGroupDialog.6"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ICDebugHelpContextIds.REGISTER_GROUP);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = Math.max(this.fNameField.getNumberOfControls(), this.fListField.getNumberOfControls());
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        PixelConverter converter = new PixelConverter((Control)composite);
        new Separator().doFillIntoGrid(composite, layout.numColumns, converter.convertHeightInCharsToPixels(1));
        this.fNameField.doFillIntoGrid(composite, layout.numColumns);
        this.fNameField.getTextControl(null).selectAll();
        new Separator().doFillIntoGrid(composite, layout.numColumns, converter.convertHeightInCharsToPixels(1));
        this.fListField.doFillIntoGrid(composite, layout.numColumns + 1);
        LayoutUtil.setHorizontalSpan((Control)this.fListField.getLabelControl(null), layout.numColumns);
        LayoutUtil.setHeigthHint(this.fListField.getListControl(null), this.convertWidthInCharsToPixels(30));
        LayoutUtil.setHorizontalGrabbing(this.fListField.getListControl(null));
        this.setMessage(null);
        return composite;
    }

    protected void update() {
        this.setErrorMessage(null);
        String name = this.fNameField.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(ActionMessages.getString("RegisterGroupDialog.7"));
        }
        this.getButton(0).setEnabled(name.length() > 0);
    }

    protected void okPressed() {
        super.okPressed();
        this.fName = this.fNameField.getText().trim();
        List elements = this.fListField.getCheckedElements();
        this.fDescriptors = elements.toArray(new IRegisterDescriptor[elements.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IRegisterDescriptor[] getDescriptors() {
        return this.fDescriptors;
    }

    public class RegisterLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof IRegisterDescriptor) {
                return CDebugImages.get("org.eclipse.cdt.debug.ui.register_obj.gif");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IRegisterDescriptor) {
                IRegisterDescriptor rd = (IRegisterDescriptor)element;
                return MessageFormat.format("{0} - {1}", rd.getName(), rd.getGroupName());
            }
            return super.getText(element);
        }
    }
}

