/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.AddContainerAction;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.DownAction;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.EditContainerAction;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.RemoveAction;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceContainerAction;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceContainerViewer;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.UpAction;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SourcePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private SourceContainerViewer fPathViewer;
    private List fActions = new ArrayList(6);
    private IWorkbench fWorkbench;
    private AddContainerAction fAddAction;
    private EditContainerAction fEditAction;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        Label viewerLabel = new Label(comp, 16384);
        viewerLabel.setText(PreferenceMessages.getString("SourcePreferencePage.0"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        viewerLabel.setLayoutData((Object)gd);
        viewerLabel.setFont(font);
        this.fPathViewer = new SourceContainerViewer(comp);
        gd = new GridData(1808);
        this.fPathViewer.getControl().setLayoutData((Object)gd);
        this.fPathViewer.getControl().setFont(font);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createVerticalSpacer(comp, 2);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.fAddAction = new AddContainerAction();
        Button button = this.createPushButton(pathButtonComp, this.fAddAction.getText(), fontMetrics);
        this.fAddAction.setButton(button);
        this.addAction(this.fAddAction);
        this.fEditAction = new EditContainerAction();
        button = this.createPushButton(pathButtonComp, this.fEditAction.getText(), fontMetrics);
        this.fEditAction.setButton(button);
        this.addAction(this.fEditAction);
        SourceContainerAction action = new RemoveAction();
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.addAction(action);
        action = new UpAction();
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.addAction(action);
        action = new DownAction();
        button = this.createPushButton(pathButtonComp, action.getText(), fontMetrics);
        action.setButton(button);
        this.addAction(action);
        this.retargetActions(this.fPathViewer);
        Dialog.applyDialogFont((Control)comp);
        this.getWorkbench().getHelpSystem().setHelp((Control)comp, ICDebugHelpContextIds.SOURCE_PREFERENCE_PAGE);
        this.initialize();
        return comp;
    }

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    private Button createPushButton(Composite parent, String label, FontMetrics fontMetrics) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        GridData gd = this.getButtonGridData(button, fontMetrics);
        button.setLayoutData((Object)gd);
        return button;
    }

    private GridData getButtonGridData(Button button, FontMetrics fontMetrics) {
        GridData gd = new GridData(770);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    private IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    private void addAction(SourceContainerAction action) {
        this.fActions.add(action);
    }

    private void retargetActions(SourceContainerViewer viewer) {
        for (SourceContainerAction action : this.fActions) {
            action.setViewer(viewer);
        }
    }

    private void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    private void initialize() {
        CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
        this.fPathViewer.setEntries(director.getSourceContainers());
        this.fAddAction.setSourceLookupDirector((ISourceLookupDirector)director);
        this.fEditAction.setSourceLookupDirector((ISourceLookupDirector)director);
    }

    protected void performDefaults() {
        this.fPathViewer.setEntries(new ISourceContainer[0]);
        super.performDefaults();
    }

    public boolean performOk() {
        CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().setSourceContainers(this.fPathViewer.getEntries());
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }
}

