/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CSourceNotFoundEditor
extends CommonSourceNotFoundEditor {
    public final String foundMappingsContainerName = "Found Mappings";
    private static final String UID_KEY = ".uid";
    private static final String UID_CLASS_NAME = CSourceNotFoundEditor.class.getName();
    public static final String UID_DISASSEMBLY_BUTTON = String.valueOf(UID_CLASS_NAME) + "disassemblyButton";
    public static final String UID_LOCATE_FILE_BUTTON = String.valueOf(UID_CLASS_NAME) + "locateFileButton";
    public static final String UID_EDIT_LOOKUP_BUTTON = String.valueOf(UID_CLASS_NAME) + "editLookupButton";
    private String missingFile;
    private ILaunch launch;
    private IDebugElement context;
    private ITranslationUnit tunit;
    private Button disassemblyButton;
    private Button locateFileButton;
    private Button editLookupButton;
    private boolean isDebugElement;
    private boolean isTranslationUnit;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ICDebugHelpContextIds.SOURCE_NOT_FOUND);
    }

    public void setInput(IEditorInput input) {
        if (input instanceof CSourceNotFoundEditorInput) {
            this.isDebugElement = false;
            this.isTranslationUnit = false;
            Object artifact = ((CSourceNotFoundEditorInput)input).getArtifact();
            if (artifact instanceof CSourceNotFoundElement) {
                CSourceNotFoundElement element = (CSourceNotFoundElement)artifact;
                this.missingFile = element.getFile();
                this.launch = element.getLaunch();
                this.context = element.getElement();
                this.isDebugElement = true;
            } else if (artifact instanceof ITranslationUnit) {
                this.isTranslationUnit = true;
                this.tunit = (ITranslationUnit)artifact;
                IPath tuPath = this.tunit.getLocation();
                if (tuPath != null) {
                    this.missingFile = tuPath.toOSString();
                }
            } else {
                this.missingFile = "";
            }
        }
        super.setInput(input);
        this.syncButtons();
    }

    private void syncButtons() {
        if (this.locateFileButton != null) {
            this.locateFileButton.setVisible(this.missingFile.length() > 0);
        }
        if (this.editLookupButton != null) {
            this.editLookupButton.setVisible(this.missingFile.length() > 0);
        }
    }

    protected String getText() {
        if (this.missingFile.length() > 0) {
            return MessageFormat.format(SourceLookupUIMessages.getString("CSourceNotFoundEditor.0"), this.missingFile);
        }
        if (this.context == null) {
            return super.getText();
        }
        return MessageFormat.format(SourceLookupUIMessages.getString("CSourceNotFoundEditor.3"), this.context.toString());
    }

    protected void createButtons(Composite parent) {
        GridData data;
        if (this.isDebugElement) {
            this.disassemblyButton = new Button(parent, 8);
            data = new GridData();
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = false;
            this.disassemblyButton.setLayoutData((Object)data);
            this.disassemblyButton.setText(SourceLookupUIMessages.getString("CSourceNotFoundEditor.4"));
            this.disassemblyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CSourceNotFoundEditor.this.viewDisassembly();
                }
            });
            this.disassemblyButton.setData(UID_KEY, (Object)UID_DISASSEMBLY_BUTTON);
        }
        this.locateFileButton = new Button(parent, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        this.locateFileButton.setLayoutData((Object)data);
        this.locateFileButton.setText(SourceLookupUIMessages.getString("CSourceNotFoundEditor.1"));
        this.locateFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CSourceNotFoundEditor.this.locateFile();
            }
        });
        this.locateFileButton.setData(UID_KEY, (Object)UID_LOCATE_FILE_BUTTON);
        if (this.isDebugElement) {
            this.editLookupButton = new Button(parent, 8);
            data = new GridData();
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = false;
            this.editLookupButton.setLayoutData((Object)data);
            this.editLookupButton.setText(SourceLookupUIMessages.getString("CSourceNotFoundEditor.5"));
            this.editLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CSourceNotFoundEditor.this.editSourceLookupPath();
                }
            });
            this.editLookupButton.setData(UID_KEY, (Object)UID_EDIT_LOOKUP_BUTTON);
        }
        this.syncButtons();
    }

    protected void viewDisassembly() {
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null) {
            try {
                page.showView(ICDebugUIConstants.ID_DISASSEMBLY_VIEW);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void addSourceMappingToDirector(IPath missingPath, IPath newSourcePath, AbstractSourceLookupDirector director) throws CoreException {
        ArrayList<MappingSourceContainer> containerList = new ArrayList<MappingSourceContainer>((Collection)Arrays.asList(director.getSourceContainers()));
        boolean hasFoundMappings = false;
        MappingSourceContainer foundMappings = null;
        Iterator iter = containerList.iterator();
        while (iter.hasNext() && !hasFoundMappings) {
            ISourceContainer container = (ISourceContainer)iter.next();
            if (!(container instanceof MappingSourceContainer) || !(hasFoundMappings = container.getName().equals("Found Mappings"))) continue;
            foundMappings = (MappingSourceContainer)container;
        }
        if (!hasFoundMappings) {
            foundMappings = new MappingSourceContainer("Found Mappings");
            foundMappings.init((ISourceLookupDirector)director);
            containerList.add(foundMappings);
        }
        foundMappings.addMapEntry(new MapEntrySourceContainer(missingPath, newSourcePath));
        director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
    }

    private void addSourceMappingToCommon(IPath missingPath, IPath newSourcePath) throws CoreException {
        CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
        this.addSourceMappingToDirector(missingPath, newSourcePath, (AbstractSourceLookupDirector)director);
        CDebugCorePlugin.getDefault().savePluginPreferences();
    }

    private void addSourceMappingToLaunch(IPath missingPath, IPath newSourcePath) throws CoreException {
        ILaunchManager launchManager;
        IPersistableSourceLocator locator;
        String memento = null;
        String type = null;
        ILaunchConfigurationWorkingCopy configuration = this.launch.getLaunchConfiguration().getWorkingCopy();
        memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (type == null) {
            type = configuration.getType().getSourceLocatorId();
        }
        if ((locator = (launchManager = DebugPlugin.getDefault().getLaunchManager()).newSourceLocator(type)) instanceof AbstractSourceLookupDirector) {
            AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                director.initializeDefaults((ILaunchConfiguration)configuration);
            } else {
                director.initializeFromMemento(memento, (ILaunchConfiguration)configuration);
            }
            this.addSourceMappingToDirector(missingPath, newSourcePath, director);
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            configuration.doSave();
        }
    }

    protected void locateFile() {
        Path newPath;
        FileDialog dialog = new FileDialog(this.getEditorSite().getShell(), 0);
        Path missingPath = new Path(this.missingFile);
        dialog.setFilterNames(new String[]{SourceLookupUIMessages.getString("CSourceNotFoundEditor.2")});
        dialog.setFilterExtensions(new String[]{"*." + missingPath.getFileExtension()});
        String res = dialog.open();
        if (res != null && (newPath = new Path(res)).lastSegment().equalsIgnoreCase(missingPath.lastSegment())) {
            if (missingPath.segmentCount() > 1) {
                int missingPathSegCount = missingPath.segmentCount() - 2;
                int newPathSegCount = newPath.segmentCount() - 2;
                while (missingPathSegCount >= 0 && newPathSegCount >= 0) {
                    if (!newPath.segment(newPathSegCount).equalsIgnoreCase(missingPath.segment(missingPathSegCount))) break;
                    --newPathSegCount;
                    --missingPathSegCount;
                }
                IPath compPath = missingPath.removeLastSegments(missingPath.segmentCount() - missingPathSegCount - 1);
                IPath newSourcePath = newPath.removeLastSegments(newPath.segmentCount() - newPathSegCount - 1);
                try {
                    if (this.isDebugElement) {
                        this.addSourceMappingToLaunch(compPath, newSourcePath);
                    } else {
                        this.addSourceMappingToCommon(compPath, newSourcePath);
                    }
                }
                catch (CoreException coreException) {}
            }
            IWorkbenchPage page = this.getEditorSite().getPage();
            if (this.isDebugElement) {
                ISourceDisplay adapter = (ISourceDisplay)this.context.getAdapter(ISourceDisplay.class);
                if (adapter != null) {
                    adapter.displaySource((Object)this.context, page, true);
                }
            } else if (this.isTranslationUnit) {
                this.reopenTranslationUnit(this.tunit);
            }
            this.closeEditor();
        }
    }

    private boolean reopenTranslationUnit(ITranslationUnit tu) {
        IPath tuPath;
        if (tu != null && (tuPath = tu.getLocation()) != null) {
            String filePath = tuPath.toOSString();
            try {
                LocalFileStorage newLocation;
                Object[] foundElements = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().findSourceElements((Object)filePath);
                if (foundElements.length == 1 && foundElements[0] instanceof LocalFileStorage && (newLocation = (LocalFileStorage)foundElements[0]).getFullPath().toFile().exists()) {
                    ITranslationUnit remappedTU = tu;
                    if (tu instanceof ExternalTranslationUnit) {
                        remappedTU = new ExternalTranslationUnit(tu.getParent(), URIUtil.toURI((IPath)newLocation.getFullPath()), tu.getContentTypeId());
                    }
                    EditorUtility.openInEditor((Object)remappedTU);
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    protected Object getArtifact() {
        Object o = super.getArtifact();
        if (o instanceof CSourceNotFoundElement) {
            return ((CSourceNotFoundElement)o).getElement();
        }
        return o;
    }
}

