/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.model.ICDIAddressBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIEventBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExceptionpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIFunctionBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILineBreakpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.LineLocation;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.AddressBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.AddressLocation;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.EventBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Exceptionpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.FunctionBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.FunctionLocation;
import org.eclipse.cdt.debug.mi.core.cdi.model.LineBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CLICatch;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakAfter;
import org.eclipse.cdt.debug.mi.core.command.MIBreakCondition;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetBreakpointPending;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.CLICatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakWatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends Manager {
    public static ICDIBreakpoint[] EMPTY_BREAKPOINTS = new ICDIBreakpoint[0];
    Map breakMap;
    Map deferredMap;
    boolean allowInterrupt = true;
    Breakpoint[] exceptionBps = new Breakpoint[2];
    final int EXCEPTION_THROW_IDX = 0;
    final int EXCEPTION_CATCH_IDX = 1;
    static final String[] EXCEPTION_FUNCS = new String[]{"__cxa_throw", "__cxa_begin_catch"};

    public BreakpointManager(Session session) {
        super(session, false);
        this.breakMap = Collections.synchronizedMap(new HashMap());
        this.deferredMap = Collections.synchronizedMap(new HashMap());
    }

    synchronized List getBreakpointsList(Target target) {
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            bList = Collections.synchronizedList(new ArrayList());
            this.breakMap.put(target, bList);
        }
        return bList;
    }

    MIBreakpoint[] getAllMIBreakpoints(MISession miSession) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakList breakpointList = factory.createMIBreakList();
        try {
            miSession.postCommand(breakpointList);
            MIBreakListInfo info = breakpointList.getMIBreakListInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            return info.getMIBreakpoints();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    boolean hasBreakpointChanged(MIBreakpoint miBreak, MIBreakpoint miBreakpoint) {
        return miBreak.isEnabled() != miBreakpoint.isEnabled() || !miBreak.getCondition().equals(miBreakpoint.getCondition()) || miBreak.getIgnoreCount() != miBreakpoint.getIgnoreCount();
    }

    public Watchpoint getWatchpoint(MISession miSession, int number) {
        return (Watchpoint)this.getBreakpoint(miSession, number);
    }

    public Breakpoint getBreakpoint(MISession miSession, int number) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        if (target != null) {
            return this.getBreakpoint(target, number);
        }
        return null;
    }

    public Breakpoint getBreakpoint(Target target, int number) {
        List bList = (List)this.breakMap.get(target);
        if (bList != null) {
            Breakpoint[] bkpts = bList.toArray(new Breakpoint[0]);
            int i = 0;
            while (i < bkpts.length) {
                MIBreakpoint[] miBreakpoints = bkpts[i].getMIBreakpoints();
                int j = 0;
                while (j < miBreakpoints.length) {
                    if (miBreakpoints[j].getNumber() == number) {
                        return bkpts[i];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    boolean suspendInferior(Target target) throws CDIException {
        boolean shouldRestart = false;
        if (this.allowInterrupt && target.isRunning()) {
            ((EventManager)this.getSession().getEventManager()).allowProcessingEvents(false);
            target.suspend();
            shouldRestart = true;
        }
        return shouldRestart;
    }

    void resumeInferior(Target target, boolean shouldRestart) throws CDIException {
        ((EventManager)this.getSession().getEventManager()).allowProcessingEvents(true);
        if (shouldRestart) {
            target.resume();
        }
    }

    public void deleteBreakpoint(MISession miSession, int no) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        if (target != null) {
            this.deleteBreakpoint(target, no);
        }
    }

    void deleteBreakpoint(Target target, int no) {
        List bList = (List)this.breakMap.get(target);
        if (bList != null) {
            Breakpoint[] points = bList.toArray(new Breakpoint[0]);
            int i = 0;
            while (i < points.length) {
                MIBreakpoint[] miBreakpoints = points[i].getMIBreakpoints();
                int j = 0;
                while (j < miBreakpoints.length) {
                    if (miBreakpoints[j].getNumber() == no) {
                        bList.remove(points[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void enableBreakpoint(Breakpoint breakpoint) throws CDIException {
        Target target = (Target)breakpoint.getTarget();
        List dList = (List)this.deferredMap.get(target);
        if (dList != null && dList.contains(breakpoint)) {
            breakpoint.setEnabled0(true);
            return;
        }
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        if (!bList.contains(breakpoint)) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        MIBreakpoint[] miBreakpoints = breakpoint.getMIBreakpoints();
        if (miBreakpoints == null || miBreakpoints.length == 0) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        int[] numbers = new int[miBreakpoints.length];
        int i = 0;
        while (i < miBreakpoints.length) {
            numbers[i] = miBreakpoints[i].getNumber();
            ++i;
        }
        boolean restart = false;
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakEnable breakEnable = factory.createMIBreakEnable(numbers);
        try {
            try {
                restart = this.suspendInferior(target);
                miSession.postCommand(breakEnable);
                MIInfo info = breakEnable.getMIInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                int i2 = 0;
                while (i2 < miBreakpoints.length) {
                    miBreakpoints[i2].setEnabled(true);
                    ++i2;
                }
                breakpoint.setEnabled0(true);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        finally {
            try {
                this.resumeInferior(target, restart);
            }
            finally {
                miSession.fireEvent(new MIBreakpointChangedEvent(miSession, numbers[0]));
            }
        }
    }

    public void disableBreakpoint(Breakpoint breakpoint) throws CDIException {
        Target target = (Target)breakpoint.getTarget();
        List dList = (List)this.deferredMap.get(target);
        if (dList != null && dList.contains(breakpoint)) {
            breakpoint.setEnabled0(false);
            return;
        }
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        if (!bList.contains(breakpoint)) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        MIBreakpoint[] miBreakpoints = breakpoint.getMIBreakpoints();
        if (miBreakpoints == null || miBreakpoints.length == 0) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        int[] numbers = new int[miBreakpoints.length];
        int i = 0;
        while (i < miBreakpoints.length) {
            numbers[i] = miBreakpoints[i].getNumber();
            ++i;
        }
        boolean restart = false;
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakDisable breakDisable = factory.createMIBreakDisable(numbers);
        try {
            try {
                restart = this.suspendInferior(target);
                miSession.postCommand(breakDisable);
                MIInfo info = breakDisable.getMIInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                int i2 = 0;
                while (i2 < miBreakpoints.length) {
                    miBreakpoints[i2].setEnabled(false);
                    ++i2;
                }
                breakpoint.setEnabled0(false);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        finally {
            try {
                this.resumeInferior(target, restart);
            }
            finally {
                miSession.fireEvent(new MIBreakpointChangedEvent(miSession, numbers[0]));
            }
        }
    }

    public void setCondition(Breakpoint breakpoint, ICDICondition newCondition) throws CDIException {
        Target target = (Target)breakpoint.getTarget();
        List dList = (List)this.deferredMap.get(target);
        if (dList != null && dList.contains(breakpoint)) {
            breakpoint.setCondition0(newCondition);
            return;
        }
        List bList = (List)this.breakMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        if (!bList.contains(breakpoint)) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        MIBreakpoint[] miBreakpoints = breakpoint.getMIBreakpoints();
        this.deleteMIBreakpoints(target, miBreakpoints);
        ICDICondition oldCondition = breakpoint.getCondition();
        boolean success = false;
        try {
            breakpoint.setCondition0(newCondition);
            if (breakpoint instanceof LocationBreakpoint) {
                this.setLocationBreakpoint((LocationBreakpoint)breakpoint);
            } else if (breakpoint instanceof Watchpoint) {
                this.setWatchpoint((Watchpoint)breakpoint, false);
            } else {
                throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
            }
            success = true;
        }
        finally {
            if (!success) {
                breakpoint.setCondition0(oldCondition);
                if (breakpoint instanceof LocationBreakpoint) {
                    this.setLocationBreakpoint((LocationBreakpoint)breakpoint);
                } else if (breakpoint instanceof Watchpoint) {
                    this.setWatchpoint((Watchpoint)breakpoint, false);
                }
            }
        }
        miBreakpoints = breakpoint.getMIBreakpoints();
        if (miBreakpoints != null && miBreakpoints.length > 0) {
            MISession miSession = target.getMISession();
            miSession.fireEvent(new MIBreakpointChangedEvent(miSession, miBreakpoints[0].getNumber()));
        }
    }

    public void update(Target target) throws CDIException {
        this.update(target, null);
    }

    public void update(Target target, MIEvent event) throws CDIException {
        MISession miSession = target.getMISession();
        MIBreakpoint[] allMIBreakpoints = this.getAllMIBreakpoints(miSession);
        List bList = this.getBreakpointsList(target);
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(allMIBreakpoints.length);
        int i = 0;
        while (i < allMIBreakpoints.length) {
            MIBreakpoint miBreakpoint = allMIBreakpoints[i];
            int no = miBreakpoint.getNumber();
            Breakpoint bp = this.getBreakpoint(target, no);
            if (bp != null) {
                MIBreakpoint[] miBps = bp.getMIBreakpoints();
                int j = 0;
                while (j < miBps.length) {
                    if (miBps[j].getNumber() == no && this.hasBreakpointChanged(miBps[j], miBreakpoint)) {
                        miBps[j] = miBreakpoint;
                        bp.setEnabled0(miBreakpoint.isEnabled());
                        ICDICondition oldCond = bp.getCondition();
                        String[] tids = oldCond.getThreadIds();
                        Condition newCondition = new Condition(miBreakpoint.getIgnoreCount(), miBreakpoint.getCondition(), tids);
                        bp.setCondition0(newCondition);
                        eventList.add(new MIBreakpointChangedEvent(miSession, no));
                    }
                    ++j;
                }
            } else {
                int type = 0;
                if (miBreakpoint.isHardware()) {
                    type = 2;
                } else if (miBreakpoint.isTemporary()) {
                    type = 1;
                }
                String[] tids = null;
                String tid = miBreakpoint.getThreadId();
                if (tid != null && tid.length() > 0) {
                    tids = new String[]{tid};
                }
                Condition condition = new Condition(miBreakpoint.getIgnoreCount(), miBreakpoint.getCondition(), tids);
                if (miBreakpoint.isWatchpoint()) {
                    int watchType = 0;
                    if (miBreakpoint.isAccessWatchpoint() || miBreakpoint.isReadWatchpoint()) {
                        watchType |= 2;
                    }
                    if (miBreakpoint.isAccessWatchpoint() || miBreakpoint.isWriteWatchpoint()) {
                        watchType |= 1;
                    }
                    Watchpoint wpoint = new Watchpoint(target, miBreakpoint.getWhat(), type, watchType, condition, miBreakpoint.isEnabled());
                    wpoint.setMIBreakpoints(new MIBreakpoint[]{miBreakpoint});
                    bList.add(wpoint);
                } else {
                    Location location;
                    int hint = 0;
                    if (event instanceof MIBreakpointChangedEvent) {
                        hint = ((MIBreakpointChangedEvent)event).getHint();
                    }
                    String function = miBreakpoint.getFunction();
                    String file = miBreakpoint.getFile();
                    int line = miBreakpoint.getLine();
                    String addr = miBreakpoint.getAddress();
                    boolean enabled = miBreakpoint.isEnabled();
                    Breakpoint newBreakpoint = null;
                    if (hint == 1 || hint == 0 && file != null && file.length() > 0 && line > 0) {
                        location = this.createLineLocation(miBreakpoint.getFile(), miBreakpoint.getLine());
                        newBreakpoint = new LineBreakpoint(target, type, (ICDILineLocation)location, (ICDICondition)condition, enabled);
                    } else if ((hint == 2 || hint == 0) && function != null && function.length() > 0) {
                        location = this.createFunctionLocation(file, function);
                        newBreakpoint = new FunctionBreakpoint(target, type, (ICDILocation)location, condition, enabled);
                    } else if (hint == 4 || EventBreakpoint.getEventArgumentFromMI(miBreakpoint) != null) {
                        String ctype = EventBreakpoint.getEventTypeFromMI(miBreakpoint);
                        if (ctype != null) {
                            newBreakpoint = new EventBreakpoint(target, ctype, EventBreakpoint.getEventArgumentFromMI(miBreakpoint), condition, enabled);
                        } else {
                            MIPlugin.log("Unsupported event breakpoint: " + miBreakpoint.getWhat());
                        }
                    } else if (addr != null && addr.length() > 0) {
                        BigInteger big = MIFormat.getBigInteger(addr);
                        AddressLocation location2 = this.createAddressLocation(big);
                        newBreakpoint = new AddressBreakpoint(target, type, (ICDILocation)location2, condition, enabled);
                    }
                    if (newBreakpoint != null) {
                        newBreakpoint.setMIBreakpoints(new MIBreakpoint[]{miBreakpoint});
                        bList.add(newBreakpoint);
                    }
                }
                eventList.add(new MIBreakpointCreatedEvent(miSession, no));
            }
            ++i;
        }
        Breakpoint[] oldBreakpoints = bList.toArray(new Breakpoint[0]);
        int i2 = 0;
        while (i2 < oldBreakpoints.length) {
            boolean found = false;
            MIBreakpoint[] miBreakpoints = oldBreakpoints[i2].getMIBreakpoints();
            int j = 0;
            while (j < miBreakpoints.length) {
                int no = miBreakpoints[j].getNumber();
                int k = 0;
                while (k < allMIBreakpoints.length) {
                    if (no == allMIBreakpoints[k].getNumber()) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    eventList.add(new MIBreakpointDeletedEvent(miSession, no));
                }
                ++j;
            }
            ++i2;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }

    public void allowProgramInterruption(boolean e) {
        this.allowInterrupt = e;
    }

    public void deleteFromDeferredList(Breakpoint bkpt) {
        List dList = (List)this.deferredMap.get(bkpt.getTarget());
        if (dList != null) {
            dList.remove(bkpt);
        }
    }

    public void addToBreakpointList(Breakpoint bkpt) {
        List bList = (List)this.breakMap.get(bkpt.getTarget());
        if (bList != null) {
            bList.add(bkpt);
        }
    }

    public void deleteAllBreakpoints(Target target) throws CDIException {
        List bList = (List)this.breakMap.get(target);
        if (bList != null) {
            ICDIBreakpoint[] bps = new ICDIBreakpoint[bList.size()];
            bList.toArray(bps);
            this.deleteBreakpoints(target, bps);
        }
    }

    public void deleteBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        this.deleteBreakpoints((Target)breakpoint.getTarget(), new ICDIBreakpoint[]{breakpoint});
    }

    public void deleteBreakpoints(Target target, ICDIBreakpoint[] breakpoints) throws CDIException {
        List bList = (List)this.breakMap.get(target);
        List dList = (List)this.deferredMap.get(target);
        if (bList == null) {
            throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
        }
        int i = 0;
        while (i < breakpoints.length) {
            if (!(breakpoints[i] instanceof Breakpoint && (bList.contains(breakpoints[i]) || dList != null && dList.contains(breakpoints[i])))) {
                throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Not_a_CDT_breakpoint"));
            }
            ++i;
        }
        MISession miSession = target.getMISession();
        ArrayList<MIBreakpointDeletedEvent> eventList = new ArrayList<MIBreakpointDeletedEvent>(breakpoints.length);
        int i2 = 0;
        while (i2 < breakpoints.length) {
            MIBreakpoint[] miBreakpoints;
            if (!(dList != null && dList.remove(breakpoints[i2]) || (miBreakpoints = ((Breakpoint)breakpoints[i2]).getMIBreakpoints()).length <= 0)) {
                this.deleteMIBreakpoints(target, miBreakpoints);
                eventList.add(new MIBreakpointDeletedEvent(miSession, miBreakpoints[0].getNumber()));
            }
            ++i2;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }

    void deleteMIBreakpoints(Target target, MIBreakpoint[] miBreakpoints) throws CDIException {
        MISession miSession = target.getMISession();
        int[] numbers = new int[miBreakpoints.length];
        int i = 0;
        while (i < miBreakpoints.length) {
            numbers[i] = miBreakpoints[i].getNumber();
            ++i;
        }
        boolean restart = false;
        try {
            restart = this.suspendInferior(target);
            this.deleteMIBreakpoints(miSession, numbers);
        }
        finally {
            this.resumeInferior(target, restart);
        }
    }

    void deleteMIBreakpoints(MISession miSession, int[] numbers) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakDelete breakDelete = factory.createMIBreakDelete(numbers);
        try {
            miSession.postCommand(breakDelete);
            MIInfo info = breakDelete.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIBreakpoint[] getBreakpoints(Target target) throws CDIException {
        List list = (List)this.breakMap.get(target);
        if (list != null) {
            ICDIBreakpoint[] bps = new ICDIBreakpoint[list.size()];
            list.toArray(bps);
            return bps;
        }
        return EMPTY_BREAKPOINTS;
    }

    public ICDIBreakpoint[] getDeferredBreakpoints(Target target) throws CDIException {
        List dlist = (List)this.deferredMap.get(target);
        if (dlist != null) {
            ICDIBreakpoint[] bps = new ICDIBreakpoint[dlist.size()];
            dlist.toArray(bps);
            return bps;
        }
        return EMPTY_BREAKPOINTS;
    }

    public ICDILineBreakpoint setLineBreakpoint(Target target, int type, ICDILineLocation location, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        LineBreakpoint bkpt = new LineBreakpoint(target, type, location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public ICDIFunctionBreakpoint setFunctionBreakpoint(Target target, int type, ICDIFunctionLocation location, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        FunctionBreakpoint bkpt = new FunctionBreakpoint(target, type, (ICDILocation)location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    public ICDIAddressBreakpoint setAddressBreakpoint(Target target, int type, ICDIAddressLocation location, ICDICondition condition, boolean deferred, boolean enabled) throws CDIException {
        AddressBreakpoint bkpt = new AddressBreakpoint(target, type, (ICDILocation)location, condition, enabled);
        this.setNewLocationBreakpoint(bkpt, deferred);
        return bkpt;
    }

    protected void setNewLocationBreakpoint(LocationBreakpoint bkpt, boolean deferred) throws CDIException {
        Target target = (Target)bkpt.getTarget();
        MISession miSession = target.getMISession();
        try {
            this.setLocationBreakpoint(bkpt);
            List blist = this.getBreakpointsList(target);
            blist.add(bkpt);
            MIBreakpoint[] miBreakpoints = bkpt.getMIBreakpoints();
            if (miBreakpoints != null && miBreakpoints.length > 0) {
                miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
            }
        }
        catch (CDIException e) {
            if (!deferred) {
                throw e;
            }
            Session session = (Session)target.getSession();
            SharedLibraryManager sharedMgr = session.getSharedLibraryManager();
            if (sharedMgr.isDeferredBreakpoint(target)) {
                this.addDeferredBreakpoint(bkpt);
            }
            throw e;
        }
    }

    private void addDeferredBreakpoint(Breakpoint breakpoint) {
        Target target = (Target)breakpoint.getTarget();
        List<Breakpoint> dList = (List<Breakpoint>)this.deferredMap.get(target);
        if (dList == null) {
            dList = Collections.synchronizedList(new ArrayList());
            this.deferredMap.put(target, dList);
        }
        dList.add(breakpoint);
    }

    public void setLocationBreakpoint(LocationBreakpoint bkpt) throws CDIException {
        Target target = (Target)bkpt.getTarget();
        MISession miSession = target.getMISession();
        MIBreakInsert[] breakInserts = this.createMIBreakInsert(bkpt, miSession.isBreakpointsWithFullName());
        ArrayList pointList = new ArrayList();
        boolean restart = false;
        try {
            try {
                restart = this.suspendInferior(target);
                CommandFactory factory = miSession.getCommandFactory();
                boolean enable = bkpt.isEnabled();
                int i = 0;
                while (i < breakInserts.length) {
                    miSession.postCommand(breakInserts[i]);
                    MIBreakInsertInfo info = breakInserts[i].getMIBreakInsertInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    MIBreakpoint[] points = info.getMIBreakpoints();
                    if (points == null || points.length == 0) {
                        throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Parsing_Error"));
                    }
                    if (bkpt.getFile() != null && bkpt.getFile().length() > 0) {
                        int j = 0;
                        while (j < points.length) {
                            points[j].setFile(bkpt.getFile());
                            ++j;
                        }
                    }
                    if (!enable) {
                        int[] numbers = new int[points.length];
                        int j = 0;
                        while (j < points.length) {
                            numbers[j] = points[j].getNumber();
                            ++j;
                        }
                        MIBreakDisable breakDisable = factory.createMIBreakDisable(numbers);
                        try {
                            miSession.postCommand(breakDisable);
                            MIInfo disableInfo = breakDisable.getMIInfo();
                            if (disableInfo == null) {
                                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                            }
                        }
                        catch (MIException e) {
                            throw new MI2CDIException(e);
                        }
                    }
                    pointList.addAll(Arrays.asList(points));
                    ++i;
                }
            }
            catch (MIException e) {
                try {
                    MIBreakpoint[] allPoints = pointList.toArray(new MIBreakpoint[pointList.size()]);
                    if (allPoints != null && allPoints.length > 0) {
                        this.deleteMIBreakpoints(target, allPoints);
                    }
                }
                catch (CDIException cDIException) {}
                throw new MI2CDIException(e);
            }
        }
        finally {
            this.resumeInferior(target, restart);
        }
        MIBreakpoint[] allPoints = pointList.toArray(new MIBreakpoint[pointList.size()]);
        bkpt.setMIBreakpoints(allPoints);
    }

    public void setWatchpoint(Watchpoint bkpt) throws CDIException {
        this.setWatchpoint(bkpt, true);
    }

    private void setWatchpoint(Watchpoint watchpoint, boolean isNew) throws CDIException {
        Target target = (Target)watchpoint.getTarget();
        boolean access = watchpoint.isReadType() && watchpoint.isWriteType();
        boolean read = !watchpoint.isWriteType() && watchpoint.isReadType();
        String expression = watchpoint.getDerivedExpression();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIBreakWatch breakWatch = factory.createMIBreakWatch(access, read, expression);
        MIBreakpoint[] points = null;
        boolean restart = false;
        try {
            try {
                MIInfo info;
                restart = this.suspendInferior(target);
                miSession.postCommand(breakWatch);
                MIBreakWatchInfo winfo = breakWatch.getMIBreakWatchInfo();
                if (winfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                points = winfo.getMIBreakpoints();
                if (points == null || points.length == 0) {
                    throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Parsing_Error"));
                }
                int no = points[0].getNumber();
                String exprCond = null;
                int ignoreCount = 0;
                ICDICondition condition = watchpoint.getCondition();
                if (condition != null) {
                    exprCond = condition.getExpression();
                    ignoreCount = condition.getIgnoreCount();
                }
                if (exprCond != null && exprCond.length() > 0) {
                    MIBreakCondition breakCondition = factory.createMIBreakCondition(no, exprCond);
                    miSession.postCommand(breakCondition);
                    info = breakCondition.getMIInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                }
                if (ignoreCount > 0) {
                    MIBreakAfter breakAfter = factory.createMIBreakAfter(no, ignoreCount);
                    miSession.postCommand(breakAfter);
                    info = breakAfter.getMIInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        finally {
            this.resumeInferior(target, restart);
        }
        watchpoint.setMIBreakpoints(points);
        if (isNew) {
            List bList = this.getBreakpointsList(target);
            bList.add(watchpoint);
            MIBreakpoint[] miBreakpoints = watchpoint.getMIBreakpoints();
            if (miBreakpoints != null && miBreakpoints.length > 0) {
                miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ICDIExceptionpoint setExceptionpoint(Target target, String clazz, boolean stopOnThrow, boolean stopOnCatch, boolean enabled) throws CDIException {
        FunctionBreakpoint bp;
        FunctionLocation location;
        int id;
        Breakpoint[] breakpointArray;
        if (!stopOnThrow && !stopOnCatch) {
            throw new CDIException("Must suspend on throw or catch");
        }
        MIBreakpoint[] miBreakpoints = null;
        if (stopOnThrow) {
            breakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[0] == null) {
                location = new FunctionLocation(null, EXCEPTION_FUNCS[id]);
                bp = new FunctionBreakpoint(target, 0, (ICDILocation)location, null, enabled);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                miBreakpoints = bp.getMIBreakpoints();
            }
            // MONITOREXIT : breakpointArray
        }
        if (stopOnCatch) {
            breakpointArray = this.exceptionBps;
            // MONITORENTER : this.exceptionBps
            id = 0;
            if (this.exceptionBps[id] == null) {
                location = new FunctionLocation(null, EXCEPTION_FUNCS[id]);
                bp = new FunctionBreakpoint(target, 0, (ICDILocation)location, null, enabled);
                this.setLocationBreakpoint(bp);
                this.exceptionBps[id] = bp;
                if (miBreakpoints != null) {
                    MIBreakpoint[] mibp = bp.getMIBreakpoints();
                    MIBreakpoint[] temp = new MIBreakpoint[miBreakpoints.length + mibp.length];
                    System.arraycopy(miBreakpoints, 0, temp, 0, miBreakpoints.length);
                    System.arraycopy(mibp, 0, temp, miBreakpoints.length, mibp.length);
                } else {
                    miBreakpoints = bp.getMIBreakpoints();
                }
            }
            // MONITOREXIT : breakpointArray
        }
        Exceptionpoint excp = new Exceptionpoint(target, clazz, stopOnThrow, stopOnCatch, null, enabled);
        if (miBreakpoints == null) return excp;
        if (miBreakpoints.length <= 0) return excp;
        excp.setMIBreakpoints(miBreakpoints);
        List blist = this.getBreakpointsList(target);
        blist.add(excp);
        MISession miSession = target.getMISession();
        miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
        return excp;
    }

    public void setBreakpointPending(Target target, boolean set) throws CDIException {
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIGDBSetBreakpointPending bpp = factory.createMIGDBSetBreakpointPending(set);
        try {
            miSession.postCommand(bpp);
            MIInfo info = bpp.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public Condition createCondition(int ignoreCount, String expression, String[] tids) {
        return new Condition(ignoreCount, expression, tids);
    }

    public LineLocation createLineLocation(String file, int line) {
        return new LineLocation(file, line);
    }

    public FunctionLocation createFunctionLocation(String file, String function) {
        return new FunctionLocation(file, function);
    }

    public AddressLocation createAddressLocation(BigInteger address) {
        return new AddressLocation(address);
    }

    MIBreakInsert[] createMIBreakInsert(LocationBreakpoint bkpt) throws CDIException {
        return this.createMIBreakInsert(bkpt, false);
    }

    MIBreakInsert[] createMIBreakInsert(LocationBreakpoint bkpt, boolean fullPath) throws CDIException {
        MIBreakInsert[] miBreakInserts;
        boolean hardware = bkpt.isHardware();
        boolean temporary = bkpt.isTemporary();
        String exprCond = null;
        int ignoreCount = 0;
        String[] threadIds = null;
        StringBuffer line = new StringBuffer();
        if (bkpt.getCondition() != null) {
            ICDICondition condition = bkpt.getCondition();
            exprCond = condition.getExpression();
            ignoreCount = condition.getIgnoreCount();
            threadIds = condition.getThreadIds();
        }
        if (bkpt.getLocator() != null) {
            ICDILocator locator = bkpt.getLocator();
            String file = locator.getFile();
            if (file != null && !fullPath) {
                file = new File(file).getName();
            }
            String function = locator.getFunction();
            int no = locator.getLineNumber();
            if (bkpt instanceof LineBreakpoint) {
                if (file != null && file.length() > 0) {
                    line.append(file).append(':');
                }
                line.append(no);
            } else if (bkpt instanceof FunctionBreakpoint) {
                if (function != null && function.length() > 0) {
                    int colon = function.indexOf("::");
                    if (colon != -1) {
                        line.append(function);
                    } else {
                        int paren;
                        if (file != null && file.length() > 0) {
                            line.append(file).append(':');
                        }
                        if ((paren = function.indexOf(40)) != -1) {
                            if (no <= 0) {
                                String func = function.substring(0, paren);
                                line.append(func);
                            } else {
                                line.append(no);
                            }
                        } else {
                            line.append(function);
                        }
                    }
                } else {
                    if (file != null && file.length() > 0) {
                        line.append(file).append(':');
                    }
                    if (no > 0) {
                        line.append(no);
                    }
                }
            } else if (bkpt instanceof AddressBreakpoint) {
                line.append('*').append(locator.getAddress());
            } else {
                if (file != null && file.length() > 0) {
                    line.append(file).append(':');
                }
                line.append(no);
            }
        }
        MISession miSession = ((Target)bkpt.getTarget()).getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        if (threadIds == null || threadIds.length == 0) {
            MIBreakInsert bi = factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString(), 0);
            miBreakInserts = new MIBreakInsert[]{bi};
        } else {
            ArrayList<MIBreakInsert> list = new ArrayList<MIBreakInsert>(threadIds.length);
            int i = 0;
            while (i < threadIds.length) {
                String threadId = threadIds[i];
                int tid = 0;
                if (threadId != null && threadId.length() > 0) {
                    try {
                        tid = Integer.parseInt(threadId);
                        list.add(factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString(), tid));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
            miBreakInserts = list.toArray(new MIBreakInsert[list.size()]);
        }
        return miBreakInserts;
    }

    public ICDIEventBreakpoint setEventBreakpoint(Target target, String type, String arg, ICDICondition condition, boolean enabled) throws CDIException {
        EventBreakpoint eventBkpt = new EventBreakpoint(target, type, arg, condition, enabled);
        this.setEventBreakpoint(eventBkpt);
        return eventBkpt;
    }

    public void setEventBreakpoint(EventBreakpoint eventBkpt) throws CDIException {
        Target target = (Target)eventBkpt.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        CLICatch breakCatch = factory.createCLICatch(eventBkpt.getGdbEvent(), eventBkpt.getGdbArg());
        eventBkpt.setMIBreakpoints(new MIBreakpoint[0]);
        boolean restart = false;
        try {
            int no;
            restart = this.suspendInferior(target);
            miSession.postCommand(breakCatch);
            try {
                CLICatchInfo cinfo = (CLICatchInfo)breakCatch.getMIInfo();
                if (cinfo == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                MIBreakpoint[] points = cinfo.getMIBreakpoints();
                if (points == null || points.length == 0) {
                    throw new CDIException(CdiResources.getString("cdi.BreakpointManager.Parsing_Error"));
                }
                no = points[0].getNumber();
                eventBkpt.setMIBreakpoints(points);
            }
            catch (MIException e) {
                if (!eventBkpt.isDeferred()) {
                    throw e;
                }
                this.addDeferredBreakpoint(eventBkpt);
                this.resumeInferior(target, restart);
                return;
            }
            try {
                MIInfo info;
                String exprCond = null;
                int ignoreCount = 0;
                ICDICondition condition = eventBkpt.getCondition();
                if (condition != null) {
                    exprCond = condition.getExpression();
                    ignoreCount = condition.getIgnoreCount();
                }
                if (exprCond != null && exprCond.length() > 0) {
                    MIBreakCondition breakCondition = factory.createMIBreakCondition(no, exprCond);
                    miSession.postCommand(breakCondition);
                    info = breakCondition.getMIInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                }
                if (ignoreCount > 0) {
                    MIBreakAfter breakAfter = factory.createMIBreakAfter(no, ignoreCount);
                    miSession.postCommand(breakAfter);
                    info = breakAfter.getMIInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        finally {
            this.resumeInferior(target, restart);
        }
        List bList = this.getBreakpointsList(target);
        bList.add(eventBkpt);
        MIBreakpoint[] miBreakpoints = eventBkpt.getMIBreakpoints();
        if (miBreakpoints != null && miBreakpoints.length > 0) {
            miSession.fireEvent(new MIBreakpointCreatedEvent(miSession, miBreakpoints[0].getNumber()));
        }
    }
}

