/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.Arrays;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIEventBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class EventBreakpoint
extends Breakpoint
implements ICDIEventBreakpoint {
    public static final String CATCH = "org.eclipse.cdt.debug.gdb.catch";
    public static final String THROW = "org.eclipse.cdt.debug.gdb.throw";
    public static final String SIGNAL_CATCH = "org.eclipse.cdt.debug.gdb.signal";
    public static final String STOP_ON_FORK = "org.eclipse.cdt.debug.gdb.catch_fork";
    public static final String STOP_ON_VFORK = "org.eclipse.cdt.debug.gdb.catch_vfork";
    public static final String STOP_ON_EXEC = "org.eclipse.cdt.debug.gdb.catch_exec";
    private String eventType;
    private String arg;

    public EventBreakpoint(Target target, String event, String arg, ICDICondition cond, boolean enabled) {
        super(target, 0, cond, enabled);
        this.eventType = event;
        this.arg = arg == null ? "" : arg;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExtraArgument() {
        return this.arg;
    }

    public String getGdbEvent() {
        if (this.getEventType().equals(CATCH)) {
            return "catch";
        }
        if (this.getEventType().equals(THROW)) {
            return "throw";
        }
        if (this.getEventType().equals(SIGNAL_CATCH)) {
            return "signal";
        }
        if (this.getEventType().equals(STOP_ON_EXEC)) {
            return "exec";
        }
        if (this.getEventType().equals(STOP_ON_FORK)) {
            return "fork";
        }
        if (this.getEventType().equals(STOP_ON_VFORK)) {
            return "vfork";
        }
        return "unknown";
    }

    public String getGdbArg() {
        return this.getExtraArgument();
    }

    public int hashCode() {
        return this.eventType.hashCode();
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof EventBreakpoint)) {
            return false;
        }
        Object[] breakpoints = this.getMIBreakpoints();
        if (breakpoints == null || breakpoints.length == 0) {
            return super.equals(arg0);
        }
        return Arrays.equals(breakpoints, ((EventBreakpoint)arg0).getMIBreakpoints());
    }

    public static String getEventTypeFromMI(MIBreakpoint miBreakpoint) {
        if (miBreakpoint.getWhat().equals("exception catch")) {
            return CATCH;
        }
        if (miBreakpoint.getWhat().equals("exception throw")) {
            return THROW;
        }
        if (miBreakpoint.getType().equals("catch signal")) {
            return SIGNAL_CATCH;
        }
        if (miBreakpoint.getType().equals("catch fork")) {
            return STOP_ON_FORK;
        }
        if (miBreakpoint.getType().equals("catch vfork")) {
            return STOP_ON_VFORK;
        }
        if (miBreakpoint.getType().equals("catch exec")) {
            return STOP_ON_EXEC;
        }
        return null;
    }

    public static String getEventArgumentFromMI(MIBreakpoint miBreakpoint) {
        return "";
    }
}

