/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.rewrite;

import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTLiteralNode;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEditGroup;

public final class ASTRewrite {
    private final IASTNode fRoot;
    private final ASTModificationStore fModificationStore;
    private final ASTModification fParentMod;

    public static ASTRewrite create(IASTTranslationUnit node) {
        return new ASTRewrite(node, new ASTModificationStore(), null);
    }

    public ASTRewrite(IASTNode root, ASTModificationStore modStore, ASTModification parentMod) {
        this.fRoot = root;
        this.fModificationStore = modStore;
        this.fParentMod = parentMod;
    }

    public final IASTNode createLiteralNode(String code) {
        return new ASTLiteralNode(code);
    }

    public final void remove(IASTNode node, TextEditGroup editGroup) {
        this.checkBelongsToAST(node);
        this.checkSupportedNode(node);
        ASTModification mod = new ASTModification(ASTModification.ModificationKind.REPLACE, node, null, editGroup);
        this.fModificationStore.storeModification(this.fParentMod, mod);
    }

    public final ASTRewrite replace(IASTNode node, IASTNode replacement, TextEditGroup editGroup) {
        if (replacement == null) {
            throw new IllegalArgumentException();
        }
        this.checkBelongsToAST(node);
        this.checkSupportedNode(node);
        this.checkSupportedNode(replacement);
        ASTModification mod = new ASTModification(ASTModification.ModificationKind.REPLACE, node, replacement, editGroup);
        this.fModificationStore.storeModification(this.fParentMod, mod);
        return new ASTRewrite(replacement, this.fModificationStore, mod);
    }

    public final ASTRewrite insertBefore(IASTNode parent, IASTNode insertionPoint, IASTNode newNode, TextEditGroup editGroup) {
        ASTModification mod;
        if (parent != this.fRoot) {
            this.checkBelongsToAST(parent);
        }
        if (newNode == null) {
            throw new IllegalArgumentException();
        }
        this.checkSupportedNode(parent);
        this.checkSupportedNode(insertionPoint);
        this.checkSupportedNode(newNode);
        if (insertionPoint == null) {
            mod = new ASTModification(ASTModification.ModificationKind.APPEND_CHILD, parent, newNode, editGroup);
        } else {
            if (insertionPoint.getParent() != parent) {
                throw new IllegalArgumentException();
            }
            mod = new ASTModification(ASTModification.ModificationKind.INSERT_BEFORE, insertionPoint, newNode, editGroup);
        }
        this.fModificationStore.storeModification(this.fParentMod, mod);
        return new ASTRewrite(newNode, this.fModificationStore, mod);
    }

    public Change rewriteAST() {
        if (!(this.fRoot instanceof IASTTranslationUnit)) {
            throw new IllegalArgumentException("This API can only be used for the root rewrite object.");
        }
        return ASTRewriteAnalyzer.rewriteAST((IASTTranslationUnit)this.fRoot, this.fModificationStore);
    }

    private void checkBelongsToAST(IASTNode node) {
        while (node != null) {
            if ((node = node.getParent()) != this.fRoot) continue;
            return;
        }
        throw new IllegalArgumentException();
    }

    private void checkSupportedNode(IASTNode node) {
        if (node instanceof IASTComment) {
            throw new IllegalArgumentException("Rewriting comments is not yet supported");
        }
        if (node instanceof IASTPreprocessorStatement) {
            throw new IllegalArgumentException("Rewriting preprocessor statements is not yet supported");
        }
        if (node instanceof IASTProblem) {
            throw new IllegalArgumentException("Rewriting problem nodes is supported");
        }
    }
}

