/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeSpecification<T extends IASTNode> {
    private final Class<T> fClass;
    private final Relation fRelation;
    private final int fFileOffset;
    private final int fFileEndOffset;
    private int fSeqNumber;
    private int fSeqEndNumber;
    private int fBestOffset;
    private int fBestEndOffset;
    private T fBestNode;

    public ASTNodeSpecification(Relation relation, Class<T> clazz, int fileOffset, int fileLength) {
        this.fRelation = relation;
        this.fClass = clazz;
        this.fFileOffset = fileOffset;
        this.fFileEndOffset = fileOffset + fileLength;
    }

    public void setRangeInSequence(int offsetInSeq, int lengthInSeq) {
        this.fSeqNumber = offsetInSeq;
        this.fSeqEndNumber = offsetInSeq + lengthInSeq;
    }

    public Relation getRelationToSelection() {
        return this.fRelation;
    }

    public int getSequenceStart() {
        return this.fSeqNumber;
    }

    public int getSequenceEnd() {
        return this.fSeqEndNumber;
    }

    public T getBestNode() {
        return this.fBestNode;
    }

    public boolean requiresClass(Class<? extends IASTNode> clazz) {
        return clazz.isAssignableFrom(this.fClass);
    }

    public void visit(ASTNode astNode) {
        IASTFileLocation loc;
        if (this.isAcceptableNode(astNode) && this.isMatchingRange(astNode.getOffset(), astNode.getLength(), this.fSeqNumber, this.fSeqEndNumber) && (loc = astNode.getFileLocation()) != null) {
            this.storeIfBest(loc, astNode);
        }
    }

    public void visit(ASTNode astNode, IASTImageLocation imageLocation) {
        if (this.isAcceptableNode(astNode) && imageLocation != null && this.isMatchingRange(imageLocation.getNodeOffset(), imageLocation.getNodeLength(), this.fFileOffset, this.fFileEndOffset)) {
            this.storeIfBest(imageLocation, astNode);
        }
    }

    private boolean isMatchingRange(int offset, int length, int selOffset, int selEndOffset) {
        int endOffset = offset + length;
        switch (this.fRelation) {
            case EXACT_MATCH: {
                return selOffset == offset && selEndOffset == endOffset;
            }
            case FIRST_CONTAINED: {
                return selOffset <= offset && endOffset <= selEndOffset;
            }
            case ENCLOSING: {
                return offset <= selOffset && selEndOffset <= endOffset;
            }
        }
        assert (false);
        return false;
    }

    public boolean isAcceptableNode(IASTNode astNode) {
        return astNode != null && this.fClass.isAssignableFrom(astNode.getClass());
    }

    public boolean canContainMatches(ASTNode node) {
        int offset = node.getOffset();
        int endOffset = offset + node.getLength();
        switch (this.fRelation) {
            case EXACT_MATCH: 
            case ENCLOSING: {
                return offset <= this.fSeqNumber && this.fSeqEndNumber <= endOffset;
            }
            case FIRST_CONTAINED: {
                return offset <= this.fSeqEndNumber && this.fSeqNumber <= endOffset;
            }
        }
        assert (false);
        return false;
    }

    private void storeIfBest(IASTFileLocation loc, T astNode) {
        int length;
        int offset;
        if (loc != null && this.isBetterMatch(offset = loc.getNodeOffset(), length = loc.getNodeLength(), (IASTNode)astNode)) {
            this.fBestNode = astNode;
            this.fBestOffset = offset;
            this.fBestEndOffset = offset + length;
        }
    }

    private boolean isBetterMatch(int offset, int length, IASTNode cand) {
        if (this.fBestNode == null) {
            return true;
        }
        int endOffset = offset + length;
        switch (this.fRelation) {
            case EXACT_MATCH: {
                return this.isParent((IASTNode)this.fBestNode, cand);
            }
            case FIRST_CONTAINED: {
                if (offset < this.fBestOffset) {
                    return true;
                }
                if (offset == this.fBestOffset) {
                    if (endOffset < this.fBestEndOffset) {
                        return true;
                    }
                    return endOffset == this.fBestEndOffset && this.isParent((IASTNode)this.fBestNode, cand);
                }
                return false;
            }
            case ENCLOSING: {
                int bestLength = this.fBestEndOffset - this.fBestOffset;
                if (length < bestLength) {
                    return true;
                }
                return length == bestLength && this.isParent((IASTNode)this.fBestNode, cand);
            }
        }
        assert (false);
        return false;
    }

    private boolean isParent(IASTNode cand1, IASTNode cand2) {
        while (cand2 != null) {
            if (cand2 == cand1) {
                return true;
            }
            cand2 = cand2.getParent();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relation {
        FIRST_CONTAINED,
        EXACT_MATCH,
        ENCLOSING;

    }
}

