/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPASTQualifiedName
extends CPPASTNode
implements ICPPASTQualifiedName,
IASTCompletionContext {
    private IASTName[] names = null;
    private int namesPos = -1;
    private boolean isFullyQualified;
    private String signature;

    @Override
    public IBinding resolveBinding() {
        this.removeNullNames();
        IASTName lastName = this.getLastName();
        return lastName == null ? null : lastName.resolveBinding();
    }

    @Override
    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        return null;
    }

    public String toString() {
        return this.signature == null ? "" : this.signature;
    }

    @Override
    public void addName(IASTName name) {
        if (name != null) {
            this.names = (IASTName[])ArrayUtil.append(IASTName.class, this.names, ++this.namesPos, name);
            name.setParent(this);
            name.setPropertyInParent(SEGMENT_NAME);
        }
    }

    private void removeNullNames() {
        this.names = (IASTName[])ArrayUtil.removeNullsAfter(IASTName.class, this.names, this.namesPos);
    }

    @Override
    public IASTName[] getNames() {
        if (this.names == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        this.removeNullNames();
        return this.names;
    }

    @Override
    public IASTName getLastName() {
        if (this.names == null || this.names.length == 0) {
            return null;
        }
        return this.names[this.names.length - 1];
    }

    @Override
    public char[] toCharArray() {
        if (this.names == null) {
            return new char[0];
        }
        this.removeNullNames();
        int len = 0;
        int i = 0;
        while (i < this.names.length) {
            char[] n = this.names[i].toCharArray();
            if (n == null) {
                return null;
            }
            len += n.length;
            if (i != this.names.length - 1) {
                len += 2;
            }
            ++i;
        }
        char[] nameArray = new char[len];
        int pos = 0;
        int i2 = 0;
        while (i2 < this.names.length) {
            char[] n = this.names[i2].toCharArray();
            System.arraycopy(n, 0, nameArray, pos, n.length);
            pos += n.length;
            if (i2 != this.names.length - 1) {
                nameArray[pos++] = 58;
                nameArray[pos++] = 58;
            }
            ++i2;
        }
        return nameArray;
    }

    @Override
    public boolean isFullyQualified() {
        return this.isFullyQualified;
    }

    @Override
    public void setFullyQualified(boolean isFullyQualified) {
        this.isFullyQualified = isFullyQualified;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTName[] ns = this.getNames();
        int i = 0;
        while (i < ns.length) {
            if (i == this.names.length - 1 ? this.names[i].toCharArray().length > 0 && !this.names[i].accept(action) : !this.names[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    @Override
    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role != 1;
        }
        return false;
    }

    @Override
    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 1;
        }
        return false;
    }

    @Override
    public int getRoleForName(IASTName n) {
        IASTName[] namez = this.getNames();
        int i = 0;
        while (i < this.names.length) {
            if (namez[i] == n) {
                if (i < this.names.length - 1) {
                    return 1;
                }
                IASTNode p = this.getParent();
                if (i == this.names.length - 1 && p instanceof IASTNameOwner) {
                    return ((IASTNameOwner)((Object)p)).getRoleForName(this);
                }
                return 3;
            }
            ++i;
        }
        return 3;
    }

    @Override
    public IBinding getBinding() {
        this.removeNullNames();
        return this.names[this.names.length - 1].getBinding();
    }

    @Override
    public void setBinding(IBinding binding) {
        this.removeNullNames();
        this.names[this.names.length - 1].setBinding(binding);
    }

    @Override
    public boolean isConversionOrOperator() {
        IASTName tempName;
        int len;
        IASTName[] nonNullNames = this.getNames();
        if (nonNullNames[(len = nonNullNames.length) - 1] instanceof ICPPASTConversionName || nonNullNames[len - 1] instanceof ICPPASTOperatorName) {
            return true;
        }
        return nonNullNames[len - 1] instanceof ICPPASTTemplateId && ((tempName = ((ICPPASTTemplateId)nonNullNames[len - 1]).getTemplateName()) instanceof ICPPASTConversionName || tempName instanceof ICPPASTOperatorName);
    }

    @Override
    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 2;
        }
        return false;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding binding;
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        if (this.names.length - 2 >= 0 && (binding = this.names[this.names.length - 2].resolveBinding()) instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)binding;
            boolean isDeclaration = this.getParent().getParent() instanceof IASTSimpleDeclaration;
            List<IBinding> filtered = this.filterClassScopeBindings(classType, bindings, isDeclaration);
            if (isDeclaration && this.nameMatches(classType.getNameCharArray(), n.toCharArray(), isPrefix)) {
                try {
                    ICPPConstructor[] constructors = classType.getConstructors();
                    int i = 0;
                    while (i < constructors.length) {
                        if (!constructors[i].isImplicit()) {
                            filtered.add(constructors[i]);
                        }
                        ++i;
                    }
                }
                catch (DOMException dOMException) {}
            }
            return filtered.toArray(new IBinding[filtered.size()]);
        }
        return bindings;
    }

    private List<IBinding> filterClassScopeBindings(ICPPClassType classType, IBinding[] bindings, boolean isDeclaration) {
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        try {
            int i = 0;
            while (i < bindings.length) {
                ICPPClassType type;
                ICPPMethod method;
                IField field;
                if (!(bindings[i] instanceof IField ? !(field = (IField)bindings[i]).isStatic() : (bindings[i] instanceof ICPPMethod ? (method = (ICPPMethod)bindings[i]).isImplicit() || (method.isDestructor() || method instanceof ICPPConstructor ? !isDeclaration : !method.isStatic() && !isDeclaration) : (bindings[i] instanceof ICPPClassType ? (type = (ICPPClassType)bindings[i]).isSameType(classType) : !(bindings[i] instanceof IEnumerator) && !(bindings[i] instanceof IEnumeration) || isDeclaration)))) {
                    filtered.add(bindings[i]);
                }
                ++i;
            }
        }
        catch (DOMException dOMException) {}
        return filtered;
    }

    private boolean nameMatches(char[] potential, char[] name, boolean isPrefix) {
        if (isPrefix) {
            return CharArrayUtils.equals(potential, 0, name.length, name, true);
        }
        return CharArrayUtils.equals(potential, name);
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }
}

