/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class CPPScope
implements ICPPScope,
IASTInternalScope {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private IASTNode physicalNode;
    private boolean isfull = false;
    protected CharArrayObjectMap bindings = null;

    public CPPScope(IASTNode physicalNode) {
        this.physicalNode = physicalNode;
    }

    public IScope getParent() throws DOMException {
        return CPPVisitor.getContainingScope(this.physicalNode);
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) throws DOMException {
        char[] c;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if (name instanceof ICPPASTQualifiedName) {
            if (!(this.physicalNode instanceof ICPPASTCompositeTypeSpecifier) && !(this.physicalNode instanceof ICPPASTNamespaceDefinition)) {
                return;
            }
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
            IASTName[] ns = qname.getNames();
            if (!this.canDenoteScopeMember(qname)) {
                return;
            }
            c = ns[ns.length - 1].toCharArray();
        } else {
            c = name.toCharArray();
        }
        Object o = this.bindings.get(c);
        if (o != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(name);
            } else {
                ObjectSet<Object> temp = new ObjectSet<Object>(2);
                temp.put(o);
                temp.put(name);
                this.bindings.put(c, temp);
            }
        } else {
            this.bindings.put(c, name);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canDenoteScopeMember(ICPPASTQualifiedName name) {
        IScope scope = this;
        IASTName[] na = name.getNames();
        try {
            int i = na.length - 2;
            while (true) {
                if (i < 0) {
                    if (name.isFullyQualified() && scope != null) {
                        return ASTInternal.getPhysicalNodeOfScope(scope) instanceof IASTTranslationUnit;
                    }
                    return true;
                }
                if (scope == null) {
                    return false;
                }
                IASTName n = na[i];
                IName scopeName = scope.getScopeName();
                if (scopeName == null || !CharArrayUtils.equals(scopeName.toCharArray(), n.toCharArray())) {
                    return false;
                }
                scope = scope.getParent();
                ++i;
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public IBinding getBinding(IASTName name, boolean forceResolve, IIndexFileSet fileSet) throws DOMException {
        IASTTranslationUnit tu;
        IIndex index;
        IBinding binding = this.getBindingInAST(name, forceResolve);
        if (binding == null && forceResolve && (index = (tu = name.getTranslationUnit()).getIndex()) != null) {
            ICPPNamespace nsbindingAdapted;
            ICPPASTNamespaceDefinition nsdef;
            IASTName nsname;
            IBinding nsbinding;
            if (this.physicalNode instanceof IASTTranslationUnit) {
                try {
                    Object[] bindings = index.findBindings(name.toCharArray(), IndexFilter.CPP_DECLARED_OR_IMPLICIT, NPM);
                    if (fileSet != null) {
                        bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                    }
                    if ((binding = CPPSemantics.resolveAmbiguities(name, bindings)) instanceof ICPPUsingDeclaration) {
                        binding = CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition && (nsbinding = (nsname = (nsdef = (ICPPASTNamespaceDefinition)this.physicalNode).getName()).resolveBinding()) instanceof ICPPNamespace && (nsbindingAdapted = (ICPPNamespace)((Object)index.adaptBinding(nsbinding))) != null) {
                Object[] bindings = nsbindingAdapted.getNamespaceScope().find(name.toString());
                if (fileSet != null) {
                    bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                }
                if ((binding = CPPSemantics.resolveAmbiguities(name, bindings)) instanceof ICPPUsingDeclaration) {
                    binding = CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                }
            }
        }
        return binding;
    }

    public IBinding getBindingInAST(IASTName name, boolean forceResolve) throws DOMException {
        Object obj;
        char[] c = name.toCharArray();
        if (c.length == 0) {
            return null;
        }
        Object object = obj = this.bindings != null ? this.bindings.get(c) : null;
        if (obj != null) {
            if (obj instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)obj;
                if (forceResolve) {
                    return CPPSemantics.resolveAmbiguities(name, os.keyArray());
                }
                Object[] bs = null;
                int i = 0;
                while (i < os.size()) {
                    Object o = os.keyAt(i);
                    if (o instanceof IASTName) {
                        IASTName n = (IASTName)o;
                        if (n instanceof ICPPASTQualifiedName) {
                            IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                            n = ns[ns.length - 1];
                        }
                        bs = (IBinding[])ArrayUtil.append(IBinding.class, bs, n.getBinding());
                    } else {
                        bs = (IBinding[])ArrayUtil.append(IBinding.class, bs, o);
                    }
                    ++i;
                }
                return CPPSemantics.resolveAmbiguities(name, bs);
            }
            if (obj instanceof IASTName) {
                IBinding binding = null;
                if (forceResolve && obj != name && obj != name.getParent()) {
                    binding = CPPSemantics.resolveAmbiguities(name, new Object[]{obj});
                } else {
                    IASTName n = (IASTName)obj;
                    if (n instanceof ICPPASTQualifiedName) {
                        IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                        n = ns[ns.length - 1];
                    }
                    binding = n.getBinding();
                }
                if (binding instanceof ICPPUsingDeclaration) {
                    return CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                }
                return binding;
            }
            return (IBinding)obj;
        }
        return null;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        IIndex index;
        Object[] result = this.getBindingsInAST(name, resolve, prefixLookup);
        IASTTranslationUnit tu = name.getTranslationUnit();
        if (tu != null && (index = tu.getIndex()) != null) {
            if (this.physicalNode instanceof IASTTranslationUnit) {
                try {
                    Object[] bindings;
                    IndexFilter filter = IndexFilter.CPP_DECLARED_OR_IMPLICIT;
                    Object[] objectArray = bindings = prefixLookup ? index.findBindingsForPrefix(name.toCharArray(), true, filter, null) : index.findBindings(name.toCharArray(), filter, null);
                    if (fileSet != null) {
                        bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                    }
                    result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, bindings);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition) {
                ICPPASTNamespaceDefinition ns = (ICPPASTNamespaceDefinition)this.physicalNode;
                try {
                    IIndexBinding binding = index.findBinding(ns.getName());
                    if (binding instanceof ICPPNamespace) {
                        ICPPNamespaceScope indexNs = ((ICPPNamespace)((Object)binding)).getNamespaceScope();
                        Object[] bindings = indexNs.getBindings(name, resolve, prefixLookup);
                        if (fileSet != null) {
                            bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                        }
                        result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, bindings);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    public IBinding[] getBindingsInAST(IASTName name, boolean forceResolve, boolean prefixLookup) throws DOMException {
        int n;
        char[] c = name.toCharArray();
        Object[] result = null;
        Object[] obj = null;
        if (prefixLookup) {
            Object[] keys;
            Object[] objectArray = keys = this.bindings != null ? this.bindings.keyArray() : new Object[]{};
            int n2 = keys.length;
            n = 0;
            while (n < n2) {
                Object key2 = objectArray[n];
                char[] key = (char[])key2;
                if (CharArrayUtils.equals(key, 0, c.length, c, true)) {
                    obj = ArrayUtil.append(obj, this.bindings.get(key));
                }
                ++n;
            }
        } else {
            Object[] objectArray;
            if (this.bindings != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.bindings.get(c);
            } else {
                objectArray = null;
            }
            obj = objectArray;
        }
        Object[] objectArray = obj = ArrayUtil.trim(Object.class, obj);
        n = obj.length;
        int n3 = 0;
        while (n3 < n) {
            Object element = objectArray[n3];
            if (element instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)element;
                int j = 0;
                while (j < os.size()) {
                    Object o = os.keyAt(j);
                    if (o instanceof IASTName) {
                        IASTName n4 = (IASTName)o;
                        if (n4 instanceof ICPPASTQualifiedName) {
                            IASTName[] ns = ((ICPPASTQualifiedName)n4).getNames();
                            n4 = ns[ns.length - 1];
                        }
                        IBinding binding = forceResolve ? n4.resolveBinding() : n4.getBinding();
                        result = (IBinding[])ArrayUtil.append(IBinding.class, result, binding);
                    } else {
                        result = (IBinding[])ArrayUtil.append(IBinding.class, result, o);
                    }
                    ++j;
                }
            } else if (element instanceof IASTName) {
                IBinding binding = null;
                if (forceResolve && element != name && element != name.getParent()) {
                    binding = ((IASTName)element).resolveBinding();
                } else {
                    IASTName n5 = (IASTName)element;
                    if (n5 instanceof ICPPASTQualifiedName) {
                        IASTName[] ns = ((ICPPASTQualifiedName)n5).getNames();
                        n5 = ns[ns.length - 1];
                    }
                    binding = n5.getBinding();
                }
                if (binding instanceof ICPPUsingDeclaration) {
                    result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, ((ICPPUsingDeclaration)binding).getDelegates());
                }
                result = (IBinding[])ArrayUtil.append(IBinding.class, result, binding);
            } else {
                result = (IBinding[])ArrayUtil.append(IBinding.class, result, element);
            }
            ++n3;
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    public void setFullyCached(boolean full) {
        this.isfull = full;
    }

    public boolean isFullyCached() {
        return this.isfull;
    }

    public void removeBinding(IBinding binding) {
        char[] key = binding.getNameCharArray();
        this.removeBinding(key, binding);
    }

    protected void removeBinding(char[] key, IBinding binding) {
        if (this.bindings == null || !this.bindings.containsKey(key)) {
            return;
        }
        Object obj = this.bindings.get(key);
        if (obj instanceof ObjectSet) {
            ObjectSet set = (ObjectSet)obj;
            int i = set.size() - 1;
            while (i >= 0) {
                Object o = set.keyAt(i);
                if (o instanceof IBinding && o == binding || o instanceof IASTName && ((IASTName)o).getBinding() == binding) {
                    set.remove(o);
                }
                --i;
            }
            if (set.isEmpty()) {
                this.bindings.remove(key, 0, key.length);
            }
        } else if (obj instanceof IBinding && obj == binding || obj instanceof IASTName && ((IASTName)obj).getBinding() == binding) {
            this.bindings.remove(key, 0, key.length);
        }
        this.isfull = false;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public void flushCache() {
        CharArrayObjectMap map = this.bindings;
        if (map != null) {
            CharArrayObjectMap allBuiltins = null;
            int i = 0;
            while (i < map.size()) {
                ObjectSet set;
                Object o = map.getAt(i);
                if (o instanceof IASTName) {
                    ((IASTName)o).setBinding(null);
                } else if (o instanceof IBinding) {
                    if (allBuiltins == null) {
                        allBuiltins = new CharArrayObjectMap(1);
                    }
                    allBuiltins.put(map.keyAt(i), o);
                } else if (o instanceof ObjectSet && (set = (ObjectSet)map.getAt(i)) != null) {
                    ObjectSet builtins = null;
                    int j = set.size() - 1;
                    while (j >= 0) {
                        Object p = set.keyAt(j);
                        if (p instanceof IASTName) {
                            ((IASTName)p).setBinding(null);
                        } else if (p instanceof IBinding) {
                            if (builtins == null) {
                                builtins = new ObjectSet(1);
                            }
                            builtins.put(p);
                        }
                        --j;
                    }
                    if (builtins != null) {
                        if (allBuiltins == null) {
                            allBuiltins = new CharArrayObjectMap(1);
                        }
                        allBuiltins.put(map.keyAt(i), builtins);
                    }
                }
                ++i;
            }
            this.bindings = allBuiltins;
        }
        this.isfull = false;
    }

    public void addBinding(IBinding binding) {
        char[] c;
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(c = binding.getNameCharArray())) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(binding);
            } else {
                ObjectSet<Object> set = new ObjectSet<Object>(2);
                set.put(o);
                set.put(binding);
                this.bindings.put(c, set);
            }
        } else {
            this.bindings.put(c, binding);
        }
    }

    public final IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    public IName getScopeName() throws DOMException {
        return null;
    }

    public String toString() {
        IName name = null;
        try {
            name = this.getScopeName();
        }
        catch (DOMException dOMException) {}
        return name != null ? name.toString() : "<unnamed scope>";
    }

    public static class CPPScopeProblem
    extends ProblemBinding
    implements ICPPScope {
        public CPPScopeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }
    }
}

