/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBaseClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

class ClassTypeMixin {
    private ICPPInternalClassTypeMixinHost host;

    public ClassTypeMixin(ICPPInternalClassTypeMixinHost host) {
        this.host = host;
    }

    public IBinding[] getFriends() {
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new IBinding[]{new ProblemBinding(node, 7, this.host.getNameCharArray())};
            }
        }
        ObjectSet<IBinding> resultSet = new ObjectSet<IBinding>(2);
        IASTDeclaration[] members = this.host.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < members.length) {
            ICPPASTDeclSpecifier declSpec;
            IASTDeclaration decl = members[i];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec.isFriend()) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && dtors.length == 0) {
                        resultSet.put(((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding());
                    } else {
                        int j = 0;
                        while (j < dtors.length) {
                            if (dtors[j] != null) {
                                resultSet.put(dtors[j].getName().resolveBinding());
                                ++j;
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition && (declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier()).isFriend()) {
                IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                resultSet.put(dtor.getName().resolveBinding());
            }
            ++i;
        }
        return resultSet.keyArray(IBinding.class);
    }

    public ICPPBase[] getBases() {
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPBase[]{new CPPBaseClause.CPPBaseProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        if ((bases = this.host.getCompositeTypeSpecifier().getBaseSpecifiers()).length == 0) {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
        ICPPBase[] bindings = new ICPPBase[bases.length];
        int i = 0;
        while (i < bases.length) {
            bindings[i] = new CPPBaseClause(bases[i]);
            ++i;
        }
        return bindings;
    }

    public ICPPMethod[] getMethods() throws DOMException {
        ObjectSet<ICPPMethod> set = new ObjectSet<ICPPMethod>(4);
        set.addAll(this.getDeclaredMethods());
        ICPPClassScope scope = (ICPPClassScope)this.host.getCompositeScope();
        set.addAll(scope.getImplicitMethods());
        ICPPBase[] bases = this.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding b = bases[i].getBaseClass();
            if (b instanceof ICPPClassType) {
                set.addAll(((ICPPClassType)b).getMethods());
            }
            ++i;
        }
        return set.keyArray(ICPPMethod.class);
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPField[]{new CPPField.CPPFieldProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] decls = this.host.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < decls.length) {
            if (decls[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decls[i]).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    binding = dtors[j].getName().resolveBinding();
                    if (binding instanceof ICPPField) {
                        result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, binding);
                    }
                    ++j;
                }
            } else if (decls[i] instanceof ICPPASTUsingDeclaration) {
                IASTName n = ((ICPPASTUsingDeclaration)decls[i]).getName();
                binding = n.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int j = 0;
                    while (j < bs.length) {
                        if (bs[j] instanceof ICPPField) {
                            result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, bs[j]);
                        }
                        ++j;
                    }
                } else if (binding instanceof ICPPField) {
                    result = (ICPPField[])ArrayUtil.append(ICPPField.class, result, binding);
                }
            }
            ++i;
        }
        return (ICPPField[])ArrayUtil.trim(ICPPField.class, result);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        Object[] methods = this.getDeclaredMethods();
        ICPPBase[] bases = this.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding b = bases[i].getBaseClass();
            if (b instanceof ICPPClassType) {
                methods = (ICPPMethod[])ArrayUtil.addAll(ICPPMethod.class, methods, ((ICPPClassType)b).getAllDeclaredMethods());
            }
            ++i;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, methods);
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] decls = this.host.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < decls.length) {
            IASTDeclaration decl = decls[i];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    binding = dtors[j].getName().resolveBinding();
                    if (binding instanceof ICPPMethod) {
                        result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                    }
                    ++j;
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                binding = (dtor = CPPVisitor.getMostNestedDeclarator(dtor)).getName().resolveBinding();
                if (binding instanceof ICPPMethod) {
                    result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int j = 0;
                    while (j < bs.length) {
                        if (bs[j] instanceof ICPPMethod) {
                            result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, bs[j]);
                        }
                        ++j;
                    }
                } else if (binding instanceof ICPPMethod) {
                    result = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, result, binding);
                }
            }
            ++i;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, result);
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        ICPPClassScope scope;
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPConstructor[]{new CPPConstructor.CPPConstructorProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        if (ASTInternal.isFullyCached(scope = (ICPPClassScope)this.host.getCompositeScope())) {
            return ((CPPClassScope)scope).getConstructors(true);
        }
        IASTDeclaration[] members = this.host.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < members.length) {
            IASTDeclaration decl = members[i];
            if (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    if (dtors[j] != null) {
                        ASTInternal.addName(scope, dtors[j].getName());
                        ++j;
                        continue;
                    }
                    break;
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                ASTInternal.addName(scope, dtor.getName());
            }
            ++i;
        }
        return ((CPPClassScope)scope).getConstructors(true);
    }

    public ICPPClassType[] getNestedClasses() {
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new ICPPClassType[]{new CPPClassType.CPPClassTypeProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        Object[] result = null;
        IASTDeclaration[] decls = this.host.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < decls.length) {
            IASTDeclaration decl = decls[i];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IBinding binding = null;
                IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && ((IASTSimpleDeclaration)decl).getDeclarators().length == 0) {
                    binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                }
                if (binding instanceof ICPPClassType) {
                    result = (ICPPClassType[])ArrayUtil.append(ICPPClassType.class, result, binding);
                }
            }
            ++i;
        }
        return (ICPPClassType[])ArrayUtil.trim(ICPPClassType.class, result);
    }

    public IField[] getFields() throws DOMException {
        if (this.host.getDefinition() == null) {
            this.host.checkForDefinition();
            if (this.host.getDefinition() == null) {
                IASTNode[] declarations = this.host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new IField[]{new CPPField.CPPFieldProblem(node, 7, this.host.getNameCharArray())};
            }
        }
        Object[] fields = this.getDeclaredFields();
        ICPPBase[] bases = this.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding b = bases[i].getBaseClass();
            if (b instanceof ICPPClassType) {
                fields = (IField[])ArrayUtil.addAll(IField.class, fields, ((ICPPClassType)b).getFields());
            }
            ++i;
        }
        return (IField[])ArrayUtil.trim(IField.class, fields);
    }

    public IField findField(String name) throws DOMException {
        IBinding[] bindings = CPPSemantics.findBindings(this.host.getCompositeScope(), name, true);
        IField field = null;
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof IField) {
                if (field == null) {
                    field = (IField)bindings[i];
                } else {
                    IASTNode[] declarations = this.host.getDeclarations();
                    IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                    return new CPPField.CPPFieldProblem(node, 4, name.toCharArray());
                }
            }
            ++i;
        }
        return field;
    }
}

