/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import org.eclipse.cdt.core.envvar.IEnvironmentContributor;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.DefaultVariableContextInfo;
import org.eclipse.cdt.internal.core.cdtvariables.EnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.ICoreVariableContextInfo;
import org.eclipse.cdt.internal.core.envvar.DefaultEnvironmentContextInfo;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class BuildSystemEnvironmentSupplier
implements ICoreEnvironmentVariableSupplier {
    public IEnvironmentVariable getVariable(String name, Object context) {
        if (context == null) {
            return null;
        }
        if ((name = this.getValidName(name)) == null) {
            return null;
        }
        if (context instanceof ICConfigurationDescription) {
            ICConfigurationDescription cfg = (ICConfigurationDescription)context;
            IEnvironmentContributor supplier = cfg.getBuildSetting().getBuildEnvironmentContributor();
            if (supplier == null) {
                return null;
            }
            return supplier.getVariable(name, new ExtensionEnvVarProvider(context));
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables(Object context) {
        if (context == null) {
            return new IEnvironmentVariable[0];
        }
        IEnvironmentVariable[] variables = null;
        if (context instanceof ICConfigurationDescription) {
            ICConfigurationDescription cfg = (ICConfigurationDescription)context;
            IEnvironmentContributor supplier = cfg.getBuildSetting().getBuildEnvironmentContributor();
            if (supplier == null) {
                return new IEnvironmentVariable[0];
            }
            variables = supplier.getVariables(new ExtensionEnvVarProvider(context));
        }
        return this.filterVariables(variables);
    }

    protected ICoreEnvironmentVariableSupplier[] filterValidSuppliers(ICoreEnvironmentVariableSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] == this) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return null;
        }
        int startNum = i + 1;
        ICoreEnvironmentVariableSupplier[] validSuppliers = new ICoreEnvironmentVariableSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    protected String getValidName(String name) {
        if ((name = EnvVarOperationProcessor.normalizeName(name)) == null) {
            return null;
        }
        return name;
    }

    protected IEnvironmentVariable[] filterVariables(IEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables(variables, null);
    }

    protected ICdtVariableSupplier[] filterValidMacroSuppliers(ICdtVariableSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] instanceof EnvironmentVariableSupplier) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return suppliers;
        }
        int startNum = i + 1;
        ICdtVariableSupplier[] validSuppliers = new ICdtVariableSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    public boolean appendEnvironment(Object context) {
        return true;
    }

    private class ExtensionEnvVarProvider
    extends EnvironmentVariableManager {
        private IEnvironmentContextInfo fStartInfo;
        private Object fStartLevel;
        private boolean fStartInitialized;
        private int fStartType;
        private Object fStartData;
        private IVariableContextInfo fStartMacroContextInfo;
        private boolean fStartMacroInfoInitialized;

        public ExtensionEnvVarProvider(Object level) {
            this.fStartLevel = level;
            this.fStartType = this.getMacroContextTypeFromContext(level);
            this.fStartData = level;
        }

        public IEnvironmentVariable getVariable(String variableName, ICConfigurationDescription cfg, boolean resolveMacros) {
            if ((variableName = BuildSystemEnvironmentSupplier.this.getValidName(variableName)) == null) {
                return null;
            }
            return super.getVariable(variableName, cfg, resolveMacros);
        }

        public IEnvironmentVariable[] getVariables(ICConfigurationDescription cfg, boolean resolveMacros) {
            return BuildSystemEnvironmentSupplier.this.filterVariables(super.getVariables(cfg, resolveMacros));
        }

        public IEnvironmentContextInfo getContextInfo(Object level) {
            IEnvironmentContextInfo startInfo = this.getStartInfo();
            if (level == this.fStartLevel) {
                return startInfo;
            }
            IEnvironmentContextInfo info = super.getContextInfo(level);
            if (info == null) {
                return null;
            }
            if (this.checkParentContextRelation(startInfo, info)) {
                return info;
            }
            return null;
        }

        protected IEnvironmentContextInfo getStartInfo() {
            if (this.fStartInfo == null && !this.fStartInitialized) {
                IEnvironmentContextInfo info = super.getContextInfo(this.fStartLevel);
                if (info != null) {
                    ICoreEnvironmentVariableSupplier[] suppliers = info.getSuppliers();
                    this.fStartInfo = (suppliers = BuildSystemEnvironmentSupplier.this.filterValidSuppliers(suppliers)) != null ? new DefaultEnvironmentContextInfo(this.fStartLevel, suppliers) : info.getNext();
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartInfo;
        }

        public IVariableSubstitutor getVariableSubstitutor(IVariableContextInfo info, String inexistentMacroValue, String listDelimiter) {
            return super.getVariableSubstitutor(this.getSubstitutorMacroContextInfo(info), inexistentMacroValue, listDelimiter);
        }

        protected IVariableContextInfo getSubstitutorMacroContextInfo(IVariableContextInfo info) {
            ICoreVariableContextInfo coreInfo;
            IVariableContextInfo startInfo = this.getStartMacroContextInfo();
            if (info == null) {
                return null;
            }
            if (info instanceof ICoreVariableContextInfo && (coreInfo = (ICoreVariableContextInfo)info).getContextType() == this.fStartType && coreInfo.getContextData() == this.fStartData) {
                return startInfo;
            }
            if (SupplierBasedCdtVariableManager.checkParentContextRelation(startInfo, info)) {
                return info;
            }
            return null;
        }

        protected IVariableContextInfo getStartMacroContextInfo() {
            if (this.fStartMacroContextInfo == null && !this.fStartMacroInfoInitialized) {
                final ICoreVariableContextInfo info = this.getMacroContextInfoForContext(this.fStartLevel);
                if (info != null) {
                    this.fStartMacroContextInfo = new DefaultVariableContextInfo(this.fStartType, this.fStartData){

                        protected ICdtVariableSupplier[] getSuppliers(int type, Object data) {
                            ICdtVariableSupplier[] suppliers = info.getSuppliers();
                            return BuildSystemEnvironmentSupplier.this.filterValidMacroSuppliers(suppliers);
                        }

                        public IVariableContextInfo getNext() {
                            return info.getNext();
                        }
                    };
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartMacroContextInfo;
        }
    }
}

