/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexer;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexerInputAdapter;
import org.eclipse.cdt.internal.core.indexer.StdoutLogService;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandaloneIndexerTask
extends AbstractIndexerTask {
    protected StandaloneIndexer fIndexer;

    protected StandaloneIndexerTask(StandaloneIndexer indexer, Collection added, Collection changed, Collection removed, boolean isFast) {
        super(StandaloneIndexerTask.concat(added, changed), removed.toArray(), new StandaloneIndexerInputAdapter(indexer), isFast);
        this.fIndexer = indexer;
        this.setShowActivity(this.fIndexer.getShowActivity());
        this.setShowProblems(this.fIndexer.getShowProblems());
        this.setSkipReferences(this.fIndexer.getSkipReferences());
        if (this.getIndexAllFiles()) {
            this.setIndexFilesWithoutBuildConfiguration(true);
            this.setIndexHeadersWithoutContext(true);
        } else {
            this.setIndexFilesWithoutBuildConfiguration(false);
            this.setIndexHeadersWithoutContext(false);
        }
    }

    private static Object[] concat(Collection<?> added, Collection<?> changed) {
        Object[] result = new Object[added.size() + changed.size()];
        int i = 0;
        Iterator<?> iterator = added.iterator();
        while (iterator.hasNext()) {
            result[i++] = iterator.next();
        }
        iterator = changed.iterator();
        while (iterator.hasNext()) {
            result[i++] = iterator.next();
        }
        return result;
    }

    public final StandaloneIndexer getIndexer() {
        return this.fIndexer;
    }

    @Override
    public final IndexerProgress getProgressInformation() {
        return super.getProgressInformation();
    }

    public final void setParseUpFront() {
        this.setParseUpFront(this.fIndexer.getFilesToParseUpFront());
    }

    protected final boolean getIndexAllFiles() {
        return this.getIndexer().getIndexAllFiles();
    }

    @Override
    protected final AbstractLanguage[] getLanguages(String filename) {
        ILanguage l = this.fIndexer.getLanguageMapper().getLanguage(filename);
        if (l instanceof AbstractLanguage) {
            return new AbstractLanguage[]{(AbstractLanguage)l};
        }
        return new AbstractLanguage[0];
    }

    @Override
    protected final IWritableIndex createIndex() {
        return this.fIndexer.getIndex();
    }

    public final void run(IProgressMonitor monitor) throws InterruptedException {
        long start = System.currentTimeMillis();
        this.runTask(monitor);
        this.traceEnd(start);
    }

    protected void traceEnd(long start) {
        if (this.fIndexer.getTraceStatistics()) {
            IndexerProgress info = this.getProgressInformation();
            String name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            System.out.println(String.valueOf(name) + " " + " (" + info.fCompletedSources + " sources, " + info.fCompletedHeaders + " headers)");
            boolean allFiles = this.getIndexAllFiles();
            boolean skipRefs = this.fIndexer.getSkipReferences() == 1;
            boolean skipTypeRefs = skipRefs || this.fIndexer.getSkipReferences() == 2;
            System.out.println(String.valueOf(name) + " Options: " + "parseAllFiles=" + allFiles + ",skipReferences=" + skipRefs + ", skipTypeReferences=" + skipTypeRefs + ".");
            System.out.println(String.valueOf(name) + " Timings: " + (System.currentTimeMillis() - start) + " total, " + this.fStatistics.fParsingTime + " parser, " + this.fStatistics.fResolutionTime + " resolution, " + this.fStatistics.fAddToIndexTime + " index update.");
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(2);
            System.out.println(String.valueOf(name) + " Result: " + this.fStatistics.fDeclarationCount + " declarations, " + this.fStatistics.fReferenceCount + " references, " + this.fStatistics.fErrorCount + " errors, " + this.fStatistics.fProblemBindingCount + "(" + nf.format(problemPct) + ") problems.");
            IWritableIndex index = this.fIndexer.getIndex();
            if (index != null) {
                long hits;
                long misses = index.getCacheMisses();
                long tries = misses + (hits = index.getCacheHits());
                double missPct = tries == 0L ? 0.0 : (double)misses / (double)tries;
                System.out.println(String.valueOf(name) + " Cache: " + hits + " hits, " + misses + "(" + nf.format(missPct) + ") misses.");
            }
        }
    }

    @Override
    protected IStatus createStatus(String msg) {
        return new Status(4, "org.eclipse.cdt.core", 4, msg, null);
    }

    @Override
    protected String getMessage(AbstractIndexerTask.MessageKind kind, Object ... arguments) {
        switch (kind) {
            case parsingFileTask: {
                return MessageFormat.format("parsing {0} ({1})", arguments);
            }
            case errorWhileParsing: {
                return MessageFormat.format("Error while parsing {0}.", arguments);
            }
            case tooManyIndexProblems: {
                return "Too many errors while indexing, stopping indexer.";
            }
        }
        return null;
    }

    @Override
    protected IParserLogService getLogService() {
        return new StdoutLogService();
    }

    @Override
    protected void logError(IStatus s) {
        this.getLogService().traceLog(s.getMessage());
    }
}

