/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPInstance;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassInstance
extends PDOMCPPInstance
implements ICPPClassType,
ICPPClassSpecializationScope,
IPDOMMemberOwner,
IIndexType,
IIndexScope {
    private static final int MEMBERLIST = 48;
    protected static final int RECORD_SIZE = 52;

    public PDOMCPPClassInstance(PDOM pdom, PDOMNode parent, ICPPClassType classType, PDOMBinding instantiated) throws CoreException {
        super(pdom, parent, (ICPPTemplateInstance)((Object)classType), instantiated);
    }

    public PDOMCPPClassInstance(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 52;
    }

    public int getNodeType() {
        return 30;
    }

    public ICPPClassType getOriginalClassType() {
        return (ICPPClassType)this.getSpecializedBinding();
    }

    public ICPPBase[] getBases() throws DOMException {
        return CPPTemplates.getBases(this);
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        ConstructorCollector visitor = new ConstructorCollector();
        try {
            this.accept(visitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return visitor.getConstructors();
    }

    public int getKey() throws DOMException {
        return ((ICPPClassType)this.getSpecializedBinding()).getKey();
    }

    public IScope getCompositeScope() throws DOMException {
        return this;
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return ((ITypedef)type).isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPTemplateInstance) {
            ICPPClassType ct2;
            ICPPClassType ct1 = (ICPPClassType)this.getSpecializedBinding();
            if (!ct1.isSameType(ct2 = (ICPPClassType)((Object)((ICPPTemplateInstance)((Object)type)).getTemplateDefinition()))) {
                return false;
            }
            ObjectMap m1 = this.getArgumentMap();
            ObjectMap m2 = ((ICPPTemplateInstance)((Object)type)).getArgumentMap();
            if (m1 == null || m2 == null || m1.size() != m2.size()) {
                return false;
            }
            int i = 0;
            while (i < m1.size()) {
                IType t2;
                IType t1 = (IType)m1.getAt(i);
                if (!CPPTemplates.isSameTemplateArgument(t1, t2 = (IType)m2.getAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        ICPPClassType specialized = (ICPPClassType)this.getSpecializedBinding();
        IBinding[] bindings = specialized.getDeclaredMethods();
        SpecializationFinder visitor = new SpecializationFinder(bindings);
        try {
            this.accept(visitor);
            return ArrayUtil.convert(ICPPMethod.class, visitor.getSpecializations());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    public boolean isGloballyQualified() throws DOMException {
        return ((ICPPBinding)this.getSpecializedBinding()).isGloballyQualified();
    }

    public IField findField(String name) throws DOMException {
        this.fail();
        return null;
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        this.fail();
        return null;
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        this.fail();
        return null;
    }

    public IField[] getFields() throws DOMException {
        this.fail();
        return null;
    }

    public IBinding[] getFriends() throws DOMException {
        this.fail();
        return null;
    }

    public ICPPMethod[] getMethods() throws DOMException {
        this.fail();
        return null;
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        this.fail();
        return null;
    }

    public Object clone() {
        this.fail();
        return null;
    }

    public ICPPClassType getClassType() {
        return this;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        try {
            if (this.getDBName().equals(name.toCharArray()) && !CPPClassScope.isConstructorReference(name)) {
                return this;
            }
            IScope scope = ((ICPPClassType)((Object)this.getTemplateDefinition())).getCompositeScope();
            IBinding[] specialized = scope.getBindings(name, resolve, false);
            SpecializationFinder visitor = new SpecializationFinder(specialized);
            this.accept(visitor);
            return CPPSemantics.resolveAmbiguities(name, visitor.getSpecializations());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        Object[] result = null;
        try {
            if (!prefixLookup && this.getDBName().compare(name.toCharArray(), true) == 0 || prefixLookup && this.getDBName().comparePrefix(name.toCharArray(), false) == 0) {
                result = (IBinding[])ArrayUtil.append(IBinding.class, result, this);
            }
            IScope scope = ((ICPPClassType)((Object)this.getTemplateDefinition())).getCompositeScope();
            IBinding[] specialized = scope.getBindings(name, resolve, prefixLookup);
            SpecializationFinder visitor = new SpecializationFinder(specialized);
            this.accept(visitor);
            result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, visitor.getSpecializations());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    public IBinding getInstance(IBinding original) {
        SpecializationFinder visitor = new SpecializationFinder(new IBinding[]{original});
        try {
            this.accept(visitor);
            return visitor.getSpecializations()[0];
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return original;
        }
    }

    public ICPPMethod[] getImplicitMethods() {
        this.fail();
        return null;
    }

    public IIndexBinding getScopeBinding() {
        return this;
    }

    public void addChild(PDOMNode member) throws CoreException {
        this.addMember(member);
    }

    public void addMember(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
        list.addMember(member);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 48, this.getLinkageImpl());
        list.accept(visitor);
    }

    public final IIndexScope getScope() {
        try {
            IScope scope = this.getSpecializedBinding().getScope();
            if (scope instanceof IIndexScope) {
                return (IIndexScope)scope;
            }
        }
        catch (DOMException de) {
            CCorePlugin.log(de);
        }
        return null;
    }

    private static class ConstructorCollector
    implements IPDOMVisitor {
        private List<IPDOMNode> fConstructors = new ArrayList<IPDOMNode>();

        private ConstructorCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPConstructor) {
                this.fConstructors.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPConstructor[] getConstructors() {
            return this.fConstructors.toArray(new ICPPConstructor[this.fConstructors.size()]);
        }
    }

    private class SpecializationFinder
    implements IPDOMVisitor {
        private HashMap<IBinding, ICPPSpecialization> origToSpecialization;

        public SpecializationFinder(IBinding[] specialized) {
            this.origToSpecialization = new HashMap(specialized.length);
            IBinding[] iBindingArray = specialized;
            int n = specialized.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding element = iBindingArray[n2];
                this.origToSpecialization.put(element, null);
                ++n2;
            }
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            ICPPSpecialization specialization;
            IBinding orig;
            if (node instanceof ICPPSpecialization && this.origToSpecialization.containsKey(orig = (specialization = (ICPPSpecialization)((Object)node)).getSpecializedBinding())) {
                this.origToSpecialization.put(orig, specialization);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPSpecialization[] getSpecializations() {
            Iterator<Map.Entry<IBinding, ICPPSpecialization>> it = this.origToSpecialization.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IBinding, ICPPSpecialization> entry = it.next();
                if (entry.getValue() != null) continue;
                ICPPSpecialization specialization = CPPTemplates.createSpecialization(PDOMCPPClassInstance.this, entry.getKey(), PDOMCPPClassInstance.this.getArgumentMap());
                if (specialization == null) {
                    it.remove();
                    continue;
                }
                entry.setValue(specialization);
            }
            return this.origToSpecialization.values().toArray(new ICPPSpecialization[this.origToSpecialization.size()]);
        }
    }
}

