/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplate;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassTemplatePartialSpecialization
extends PDOMCPPClassTemplate
implements ICPPClassTemplatePartialSpecialization,
ICPPSpecialization,
IPDOMOverloader {
    private static final int ARGUMENTS = 56;
    private static final int SIGNATURE_HASH = 60;
    private static final int PRIMARY = 64;
    private static final int NEXT_PARTIAL = 68;
    protected static final int RECORD_SIZE = 72;

    public PDOMCPPClassTemplatePartialSpecialization(PDOM pdom, PDOMNode parent, ICPPClassTemplatePartialSpecialization partial, PDOMCPPClassTemplate primary) throws CoreException {
        super(pdom, parent, partial);
        pdom.getDB().putInt(this.record + 64, primary.getRecord());
        primary.addPartial(this);
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(partial);
            pdom.getDB().putInt(this.record + 60, sigHash != null ? sigHash : 0);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPClassTemplatePartialSpecialization(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    public int getSignatureHash() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 60);
    }

    protected int getRecordSize() {
        return 72;
    }

    public int getNodeType() {
        return 25;
    }

    public PDOMCPPClassTemplatePartialSpecialization getNextPartial() throws CoreException {
        int value = this.pdom.getDB().getInt(this.record + 68);
        return value != 0 ? new PDOMCPPClassTemplatePartialSpecialization(this.pdom, value) : null;
    }

    public void setNextPartial(PDOMCPPClassTemplatePartialSpecialization partial) throws CoreException {
        int value = partial != null ? partial.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 68, value);
    }

    public ICPPClassTemplate getPrimaryClassTemplate() {
        try {
            return new PDOMCPPClassTemplate(this.pdom, this.pdom.getDB().getInt(this.record + 64));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding getSpecializedBinding() {
        return this.getPrimaryClassTemplate();
    }

    public void addArgument(IType type) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 56, this.getLinkageImpl());
        PDOMNode typeNode = this.getLinkageImpl().addType(this, type);
        if (typeNode != null) {
            list.addMember(typeNode);
        }
    }

    public IType[] getArguments() {
        try {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 56, this.getLinkageImpl());
            TemplateArgumentCollector visitor = new TemplateArgumentCollector();
            list.accept(visitor);
            return visitor.getTemplateArguments();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IType[0];
        }
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        if (cmp == 0) {
            if (other instanceof PDOMCPPClassTemplatePartialSpecialization) {
                try {
                    PDOMCPPClassTemplatePartialSpecialization otherSpec = (PDOMCPPClassTemplatePartialSpecialization)other;
                    int mySM = this.getSignatureHash();
                    int otherSM = otherSpec.getSignatureHash();
                    return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
            } else {
                throw new PDOMNotImplementedError();
            }
        }
        return cmp;
    }

    public IBinding instantiate(IType[] args) {
        ICPPSpecialization instance = this.getInstance(args = SemanticUtil.getSimplifiedTypes(args));
        if (instance != null) {
            return instance;
        }
        IType[] specArgs = this.getArguments();
        if (specArgs.length != args.length) {
            return null;
        }
        boolean argsContainDependentType = false;
        ObjectMap argMap = new ObjectMap(specArgs.length);
        int numSpecArgs = specArgs.length;
        int i = 0;
        while (i < numSpecArgs) {
            IType spec = specArgs[i];
            IType arg = args[i];
            argsContainDependentType = argsContainDependentType || CPPTemplates.isDependentType(arg);
            try {
                if (!CPPTemplates.deduceTemplateArgument(argMap, spec, arg)) {
                    return null;
                }
            }
            catch (DOMException dOMException) {
                return null;
            }
            ++i;
        }
        if (argsContainDependentType) {
            return this.deferredInstance(argMap, args);
        }
        ICPPTemplateParameter[] params = this.getTemplateParameters();
        int numParams = params.length;
        int i2 = 0;
        while (i2 < numParams) {
            if (params[i2] instanceof IType && !argMap.containsKey(params[i2])) {
                return null;
            }
            ++i2;
        }
        return CPPTemplates.createInstance((ICPPScope)((Object)this.getScope()), this, argMap, args);
    }

    public ObjectMap getArgumentMap() {
        try {
            ICPPTemplateParameter[] params;
            PDOMNodeLinkedList argList = new PDOMNodeLinkedList(this.pdom, this.record + 56, this.getLinkageImpl());
            try {
                params = this.getPrimaryClassTemplate().getTemplateParameters();
            }
            catch (DOMException dOMException) {
                return ObjectMap.EMPTY_MAP;
            }
            NodeCollector argVisitor = new NodeCollector();
            argList.accept(argVisitor);
            IPDOMNode[] argNodes = argVisitor.getNodes();
            ObjectMap map = new ObjectMap(params.length);
            int i = 0;
            while (i < params.length) {
                map.put(params[i], argNodes[i]);
                ++i;
            }
            return map;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPSpecialization) {
            ICPPClassType ct2;
            ICPPClassType ct1 = (ICPPClassType)this.getSpecializedBinding();
            if (!ct1.isSameType(ct2 = (ICPPClassType)((ICPPSpecialization)((Object)type)).getSpecializedBinding())) {
                return false;
            }
            ObjectMap m1 = this.getArgumentMap();
            ObjectMap m2 = ((ICPPSpecialization)((Object)type)).getArgumentMap();
            if (m1 == null || m2 == null || m1.size() != m2.size()) {
                return false;
            }
            int i = 0;
            while (i < m1.size()) {
                IType t2;
                IType t1 = (IType)m1.getAt(i);
                if (!CPPTemplates.isSameTemplateArgument(t1, t2 = (IType)m2.getAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static class NodeCollector
    implements IPDOMVisitor {
        private List<IPDOMNode> nodes = new ArrayList<IPDOMNode>();

        private NodeCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            this.nodes.add(node);
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IPDOMNode[] getNodes() {
            return this.nodes.toArray(new IPDOMNode[this.nodes.size()]);
        }
    }

    private static class TemplateArgumentCollector
    implements IPDOMVisitor {
        private List<IType> args = new ArrayList<IType>();

        private TemplateArgumentCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IType) {
                this.args.add((IType)((Object)node));
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IType[] getTemplateArguments() {
            return this.args.toArray(new IType[this.args.size()]);
        }
    }
}

