/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PDOMCPPClassType
extends PDOMCPPBinding
implements ICPPClassType,
ICPPClassScope,
IPDOMMemberOwner,
IIndexType,
IIndexScope {
    private static final int FIRSTBASE = 28;
    private static final int KEY = 32;
    private static final int MEMBERLIST = 36;
    protected static final int RECORD_SIZE = 40;
    private static final int CACHE_MEMBERS = 0;
    private static final int CACHE_BASES = 1;

    public PDOMCPPClassType(PDOM pdom, PDOMNode parent, ICPPClassType classType) throws CoreException {
        super(pdom, parent, classType.getNameCharArray());
        this.setKind(classType);
    }

    public PDOMCPPClassType(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setKind(ct);
            super.update(linkage, newBinding);
        }
    }

    private void setKind(ICPPClassType ct) throws CoreException {
        try {
            this.pdom.getDB().putByte(this.record + 32, (byte)ct.getKey());
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    @Override
    public void addMember(PDOMNode member) throws CoreException {
        this.pdom.removeCachedResult(this.record + 0);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 36, this.getLinkageImpl());
        list.addMember(member);
    }

    @Override
    protected int getRecordSize() {
        return 40;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    private PDOMCPPBase getFirstBase() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCPPBase(this.pdom, rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        int rec = base != null ? base.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        this.pdom.removeCachedResult(this.record + 1);
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public void removeBase(PDOMName pdomName) throws CoreException {
        this.pdom.removeCachedResult(this.record + 1);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        int nameRec = pdomName.getRecord();
        while (base != null) {
            PDOMName name = base.getBaseClassSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = base;
            base = base.getNextBase();
        }
        if (base != null) {
            if (predecessor != null) {
                predecessor.setNextBase(base.getNextBase());
            } else {
                this.setFirstBase(base.getNextBase());
            }
            base.delete();
        }
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPClassType && !(type instanceof ProblemBinding)) {
            ICPPClassType ctype = (ICPPClassType)type;
            ctype = (ICPPClassType)PDOMASTAdapter.getAdapterForAnonymousASTBinding(ctype);
            try {
                if (ctype.getKey() == this.getKey()) {
                    char[][] qname = ctype.getQualifiedNameCharArray();
                    return this.hasQualifiedName(qname, qname.length - 1);
                }
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    @Override
    public ICPPBase[] getBases() throws DOMException {
        Integer key = this.record + 1;
        ICPPBase[] bases = (ICPPBase[])this.pdom.getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.pdom.putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPBase[0];
        }
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            this.acceptForNestedBindingsViaCache(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    @Override
    public ICPPMethod[] getMethods() throws DOMException {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(true);
            PDOMCPPClassType.acceptInHierarchy(this, new HashSet<IPDOMMemberOwner>(), methods);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPMethod[0];
        }
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(true, false);
            this.acceptForNestedBindingsViaCache(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    static void acceptInHierarchy(IPDOMMemberOwner current, Set<IPDOMMemberOwner> visited, IPDOMVisitor visitor) throws CoreException {
        if (visited.contains(current)) {
            return;
        }
        visited.add(current);
        visitor.visit((IPDOMNode)((Object)current));
        current.accept(visitor);
        if (current instanceof ICPPClassType) {
            try {
                ICPPBase[] bases;
                ICPPBase[] iCPPBaseArray = bases = ((ICPPClassType)((Object)current)).getBases();
                int n = bases.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding baseClass = base.getBaseClass();
                    if (baseClass != null && baseClass instanceof IPDOMMemberOwner) {
                        PDOMCPPClassType.acceptInHierarchy((IPDOMMemberOwner)((Object)baseClass), visited, visitor);
                    }
                    ++n2;
                }
            }
            catch (DOMException de) {
                CCorePlugin.log(Util.createStatus(de));
            }
        }
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        PDOMClassUtil.MethodCollector myMethods = new PDOMClassUtil.MethodCollector(false, true);
        try {
            PDOMCPPClassType.acceptInHierarchy(this, new HashSet<IPDOMMemberOwner>(), myMethods);
            return myMethods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPMethod[0];
        }
    }

    @Override
    public IField[] getFields() throws DOMException {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassType.acceptInHierarchy(this, new HashSet<IPDOMMemberOwner>(), visitor);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IField[0];
        }
    }

    @Override
    public ICPPField[] getDeclaredFields() throws DOMException {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            this.acceptForNestedBindingsViaCache(visitor);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPField[0];
        }
    }

    @Override
    public ICPPClassType[] getNestedClasses() throws DOMException {
        try {
            NestedClassCollector visitor = new NestedClassCollector();
            this.acceptForNestedBindingsViaCache(visitor);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPClassType[0];
        }
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        this.acceptForNestedBindingsViaCache(visitor);
    }

    private void acceptForNestedBindings(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 36, this.getLinkageImpl());
        list.accept(visitor);
    }

    private void acceptForNestedBindingsViaCache(IPDOMVisitor visitor) throws CoreException {
        CharArrayMap<List<PDOMBinding>> map = this.getBindingMap();
        for (List<PDOMBinding> list : map.values()) {
            for (PDOMBinding node : list) {
                if (node.getParentNodeRec() != this.record) continue;
                if (visitor.visit(node)) {
                    node.accept(visitor);
                }
                visitor.leave(node);
            }
        }
    }

    @Override
    public IScope getCompositeScope() throws DOMException {
        return this;
    }

    @Override
    public int getKey() throws DOMException {
        try {
            return this.pdom.getDB().getByte(this.record + 32);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        try {
            return this.getParentNode() instanceof PDOMLinkage;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    @Override
    public ICPPClassType getClassType() {
        return this;
    }

    @Override
    public void addChild(PDOMNode member) throws CoreException {
        this.addMember(member);
    }

    @Override
    public ICPPConstructor[] getConstructors() throws DOMException {
        PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
        try {
            this.acceptForNestedBindingsViaCache(visitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return visitor.getConstructors();
    }

    public boolean isFullyCached() {
        return true;
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        try {
            char[] nameChars = name.toCharArray();
            if (this.getDBName().equals(nameChars)) {
                if (CPPClassScope.isConstructorReference(name)) {
                    return CPPSemantics.resolveAmbiguities(name, this.getConstructors());
                }
                return this;
            }
            Object[] candidates = this.getBindingsViaCache(nameChars, this.getFilterForBindingsOfScope());
            return CPPSemantics.resolveAmbiguities(name, candidates);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        IBinding[] result = null;
        try {
            char[] nameChars = name.toCharArray();
            if (!prefixLookup) {
                return this.getBindingsViaCache(nameChars, this.getFilterForBindingsOfScope());
            }
            BindingCollector visitor = new BindingCollector(this.getLinkageImpl(), nameChars, this.getFilterForBindingsOfScope(), prefixLookup, !prefixLookup);
            if (this.getDBName().comparePrefix(nameChars, false) == 0) {
                visitor.visit(this);
            }
            this.acceptForNestedBindingsViaCache(visitor);
            result = visitor.getBindings();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return result;
    }

    protected IndexFilter getFilterForBindingsOfScope() {
        return IndexFilter.ALL_DECLARED_OR_IMPLICIT;
    }

    private IBinding[] getBindingsViaCache(char[] name, IndexFilter filter) throws CoreException {
        CharArrayMap<List<PDOMBinding>> map = this.getBindingMap();
        List<PDOMBinding> cached = map.get(name);
        if (cached == null) {
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        int i = 0;
        IBinding[] result = new IBinding[cached.size()];
        for (IBinding iBinding : cached) {
            if (!filter.acceptBinding(iBinding)) continue;
            result[i++] = iBinding;
        }
        if (i == result.length) {
            return result;
        }
        IBinding[] iBindingArray = new IBinding[i];
        System.arraycopy(result, 0, iBindingArray, 0, i);
        return iBindingArray;
    }

    private CharArrayMap<List<PDOMBinding>> getBindingMap() throws CoreException {
        CharArrayMap map;
        Integer key = this.record + 0;
        Reference cached = (Reference)this.pdom.getCachedResult(key);
        CharArrayMap charArrayMap = map = cached == null ? null : (CharArrayMap)cached.get();
        if (map == null) {
            final CharArrayMap result = new CharArrayMap();
            IPDOMVisitor visitor = new IPDOMVisitor(){

                public boolean visit(IPDOMNode node) throws CoreException {
                    if (node instanceof PDOMBinding) {
                        PDOMBinding binding = (PDOMBinding)node;
                        char[] nchars = binding.getNameCharArray();
                        ArrayList<PDOMBinding> list = (ArrayList<PDOMBinding>)result.get(nchars);
                        if (list == null) {
                            list = new ArrayList<PDOMBinding>();
                            result.put(nchars, list);
                        }
                        list.add(binding);
                        if (binding instanceof ICompositeType && nchars.length > 0 && nchars[0] == '{') {
                            return true;
                        }
                    }
                    return false;
                }

                public void leave(IPDOMNode node) {
                }
            };
            visitor.visit(this);
            this.acceptForNestedBindings(visitor);
            map = result;
            this.pdom.putCachedResult(key, new SoftReference(map));
        }
        return map;
    }

    @Override
    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public Object clone() {
        this.fail();
        return null;
    }

    @Override
    public IField findField(String name) throws DOMException {
        this.fail();
        return null;
    }

    @Override
    public IBinding[] getFriends() throws DOMException {
        this.fail();
        return null;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public IIndexBinding getScopeBinding() {
        return this;
    }

    @Override
    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    private static class NestedClassCollector
    implements IPDOMVisitor {
        private List<IPDOMNode> nestedClasses = new ArrayList<IPDOMNode>();

        private NestedClassCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPClassType) {
                this.nestedClasses.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPClassType[] getNestedClasses() {
            return this.nestedClasses.toArray(new ICPPClassType[this.nestedClasses.size()]);
        }
    }
}

