/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPMethod
extends PDOMCPPFunction
implements ICPPMethod {
    protected static final int ANNOTATION1 = 45;
    protected static final int RECORD_SIZE = 46;
    private static final int CV_OFFSET = 4;

    public PDOMCPPMethod(PDOM pdom, PDOMNode parent, ICPPMethod method) throws CoreException {
        super(pdom, parent, method, true);
        Database db = pdom.getDB();
        try {
            byte annotation = PDOMCPPAnnotation.encodeExtraAnnotation(method);
            db.putByte(this.record + 45, annotation);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPMethod(PDOM pdom, int record) {
        super(pdom, record);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPMethod) {
            ICPPMethod method = (ICPPMethod)newBinding;
            super.update(linkage, newBinding);
            try {
                this.pdom.getDB().putByte(this.record + 45, PDOMCPPAnnotation.encodeExtraAnnotation(method));
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        }
    }

    protected int getRecordSize() {
        return 46;
    }

    public int getNodeType() {
        return 10;
    }

    public boolean isVirtual() throws DOMException {
        return this.getBit(this.getByte(this.record + 45), 0);
    }

    public boolean isDestructor() throws DOMException {
        return this.getBit(this.getByte(this.record + 45), 1);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isImplicit() {
        return this.getBit(this.getByte(this.record + 45), 2);
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public int getVisibility() throws DOMException {
        return PDOMCPPAnnotation.getVisibility(this.getByte(this.record + 44));
    }

    public ICPPClassType getClassOwner() throws DOMException {
        try {
            return (ICPPClassType)((Object)this.getParentNode());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public boolean isConst() {
        return this.getBit(this.getByte(this.record + 45), 4);
    }

    public boolean isVolatile() {
        return this.getBit(this.getByte(this.record + 45), 5);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTFieldReference) {
                ICPPASTFieldReference fr = (ICPPASTFieldReference)parent;
                if ((parent = parent.getParent()) instanceof IASTFunctionCallExpression) {
                    if (fr.isPointerDereference()) {
                        return 8;
                    }
                    IType type = fr.getFieldOwner().getExpressionType();
                    if (type instanceof ICPPReferenceType) {
                        return 8;
                    }
                }
            } else if (parent instanceof IASTIdExpression && parent.getParent() instanceof IASTFunctionCallExpression) {
                return 8;
            }
        }
        return 0;
    }
}

