/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

abstract class PDOMCPPSpecialization
extends PDOMCPPBinding
implements ICPPSpecialization,
IPDOMOverloader {
    private static final int ARGMAP_PARAMS = 28;
    private static final int ARGMAP_ARGS = 32;
    private static final int SIGNATURE_HASH = 36;
    private static final int SPECIALIZED = 40;
    protected static final int RECORD_SIZE = 44;

    public PDOMCPPSpecialization(PDOM pdom, PDOMNode parent, ICPPSpecialization spec, PDOMNamedNode specialized) throws CoreException {
        super(pdom, parent, spec.getNameCharArray());
        pdom.getDB().putInt(this.record + 40, specialized.getRecord());
        PDOMNodeLinkedList paramList = new PDOMNodeLinkedList(pdom, this.record + 28, this.getLinkageImpl());
        PDOMNodeLinkedList argList = new PDOMNodeLinkedList(pdom, this.record + 32, this.getLinkageImpl());
        ObjectMap argMap = spec.getArgumentMap();
        if (argMap != null) {
            int i = 0;
            while (i < argMap.size()) {
                Object param = argMap.keyAt(i);
                Object arg = argMap.getAt(i);
                if (param instanceof ICPPTemplateNonTypeParameter && arg instanceof IType) {
                    try {
                        ICPPTemplateNonTypeParameter nontype = (ICPPTemplateNonTypeParameter)param;
                        PDOMBinding paramNode = ((PDOMCPPLinkage)this.getLinkageImpl()).createBinding(this, nontype);
                        PDOMNode argNode = this.getLinkageImpl().addType(this, (IType)arg);
                        if (paramNode != null && argNode != null) {
                            paramList.addMember(paramNode);
                            argList.addMember(argNode);
                        }
                    }
                    catch (DOMException de) {
                        CCorePlugin.log(de);
                    }
                }
                if (param instanceof IType && arg instanceof IType) {
                    PDOMNode paramNode = this.getLinkageImpl().addType(this, (IType)param);
                    PDOMNode argNode = this.getLinkageImpl().addType(this, (IType)arg);
                    if (paramNode != null && argNode != null) {
                        paramList.addMember(paramNode);
                        argList.addMember(argNode);
                    }
                }
                ++i;
            }
        }
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(spec);
            pdom.getDB().putInt(this.record + 36, sigHash != null ? sigHash : 0);
        }
        catch (DOMException dOMException) {}
    }

    public PDOMCPPSpecialization(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    public IBinding getSpecializedBinding() {
        try {
            PDOMNode node;
            int specializedRec = this.pdom.getDB().getInt(this.record + 40);
            PDOMNode pDOMNode = node = specializedRec != 0 ? this.getLinkageImpl().getNode(specializedRec) : null;
            if (node instanceof IBinding) {
                return (IBinding)((Object)node);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public ObjectMap getArgumentMap() {
        try {
            PDOMNodeLinkedList paramList = new PDOMNodeLinkedList(this.pdom, this.record + 28, this.getLinkageImpl());
            PDOMNodeLinkedList argList = new PDOMNodeLinkedList(this.pdom, this.record + 32, this.getLinkageImpl());
            NodeCollector paramVisitor = new NodeCollector();
            paramList.accept(paramVisitor);
            IPDOMNode[] paramNodes = paramVisitor.getNodes();
            NodeCollector argVisitor = new NodeCollector();
            argList.accept(argVisitor);
            IPDOMNode[] argNodes = argVisitor.getNodes();
            ObjectMap map = new ObjectMap(paramNodes.length);
            int i = 0;
            while (i < paramNodes.length) {
                map.put(paramNodes[i], argNodes[i]);
                ++i;
            }
            return map;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public int getSignatureHash() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 36);
    }

    private IType[] getArguments() {
        if (!(this instanceof ICPPTemplateDefinition) && this.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
            ICPPTemplateDefinition template = (ICPPTemplateDefinition)this.getSpecializedBinding();
            try {
                ICPPTemplateParameter[] params = template.getTemplateParameters();
                ObjectMap argMap = this.getArgumentMap();
                IType[] args = new IType[params.length];
                int i = 0;
                while (i < params.length) {
                    args[i] = (IType)argMap.get(params[i]);
                    ++i;
                }
                return args;
            }
            catch (DOMException dOMException) {}
        }
        return IType.EMPTY_TYPE_ARRAY;
    }

    public boolean matchesArguments(IType[] arguments) {
        IType[] args = this.getArguments();
        if (args.length == arguments.length) {
            int i = 0;
            while (i < args.length) {
                if (!CPPTemplates.isSameTemplateArgument(args[i], arguments[i])) break;
                ++i;
            }
            return i == args.length;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        result.append(' ');
        result.append(this.getArgumentMap().toString());
        result.append(' ');
        try {
            result.append(PDOMCPPSpecialization.getConstantNameForValue(this.getLinkageImpl(), this.getNodeType()));
        }
        catch (CoreException coreException) {
            result.append(this.getNodeType());
        }
        return result.toString();
    }

    public IIndexScope getScope() {
        try {
            IIndexBinding parent = this.getParentBinding();
            if (parent instanceof ICPPSpecialization && parent instanceof ICPPClassType) {
                return (IIndexScope)((ICPPClassType)((Object)parent)).getCompositeScope();
            }
            IScope scope = this.getSpecializedBinding().getScope();
            if (scope instanceof IIndexScope) {
                return (IIndexScope)scope;
            }
        }
        catch (DOMException de) {
            CCorePlugin.log(de);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return null;
    }

    private static class NodeCollector
    implements IPDOMVisitor {
        private List<IPDOMNode> nodes = new ArrayList<IPDOMNode>();

        private NodeCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            this.nodes.add(node);
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IPDOMNode[] getNodes() {
            return this.nodes.toArray(new IPDOMNode[this.nodes.size()]);
        }
    }
}

