/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerListener;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.IInternalResourceDescription;
import org.eclipse.cdt.internal.core.settings.model.IProxyCache;
import org.eclipse.core.runtime.IPath;

public class CfgProxyCache
implements IProxyCache {
    private HashMap fProxyMap = new HashMap();
    private PathSettingsContainer fPathContainer;

    CfgProxyCache(PathSettingsContainer pathDesContainer) {
        this.fPathContainer = pathDesContainer;
        this.fPathContainer.addContainerListener(new IPathSettingsContainerListener(){

            public void aboutToRemove(PathSettingsContainer container) {
                CDataProxy proxy = (CDataProxy)container.getValue();
                if (proxy != null) {
                    CfgProxyCache.this.fProxyMap.remove(proxy.getId());
                }
            }

            public void containerAdded(PathSettingsContainer container) {
            }

            public void containerValueChanged(PathSettingsContainer container, Object oldValue) {
                CDataProxy proxy = (CDataProxy)container.getValue();
                if (proxy != null) {
                    CfgProxyCache.this.fProxyMap.put(proxy.getId(), proxy);
                } else if (oldValue != null) {
                    CfgProxyCache.this.fProxyMap.remove((CDataProxy)oldValue);
                }
            }

            public void containerPathChanged(PathSettingsContainer container, IPath oldPath, boolean childrenMoved) {
            }
        });
    }

    public void addCachedProxy(CDataProxy proxy) {
        if (proxy instanceof IInternalResourceDescription) {
            IInternalResourceDescription des = (IInternalResourceDescription)((Object)proxy);
            IPath path = des.getPath();
            PathSettingsContainer cr = this.fPathContainer.getChildContainer(path, true, true);
            cr.setValue(des);
            des.setPathContainer(cr);
        } else {
            this.fProxyMap.put(proxy.getId(), proxy);
        }
    }

    public void clear() {
        this.fPathContainer.removeChildren();
        this.fProxyMap.clear();
    }

    public CDataProxy[] getCachedProxies() {
        Collection c = this.fProxyMap.values();
        return c.toArray(new CDataProxy[c.size()]);
    }

    public CDataProxy getCachedProxy(String id) {
        return (CDataProxy)this.fProxyMap.get(id);
    }

    public void removeCachedProxy(String id) {
        CDataProxy proxy = (CDataProxy)this.fProxyMap.get(id);
        this.removeCachedProxy(proxy);
    }

    public Map getCachedProxiesMap() {
        return (Map)this.fProxyMap.clone();
    }

    public CDataProxy getCachedProxy(CDataObject data) {
        return this.getCachedProxy(data.getId());
    }

    public void removeCachedProxy(CDataProxy proxy) {
        if (proxy instanceof IInternalResourceDescription) {
            this.fPathContainer.removeChildContainer(((IInternalResourceDescription)((Object)proxy)).getCachedPath());
        } else {
            this.fProxyMap.remove(proxy.getId());
        }
    }
}

