/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.core.runtime.IPath;

public class PEBinaryObject
extends BinaryObjectAdapter {
    BinaryObjectAdapter.BinaryObjectInfo info;
    IAddressFactory addressFactory;
    IBinaryParser.ISymbol[] symbols;
    AR.ARHeader header;

    public PEBinaryObject(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, 1);
    }

    public PEBinaryObject(IBinaryParser parser, IPath p, int type) {
        super(parser, p, type);
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    public InputStream getContents() throws IOException {
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        return super.getContents();
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadAll();
            }
            catch (IOException iOException) {
                this.symbols = this.NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        if (this.hasChanged() || this.info == null) {
            try {
                this.loadInfo();
            }
            catch (IOException iOException) {
                this.info = new BinaryObjectAdapter.BinaryObjectInfo();
            }
        }
        return this.info;
    }

    public Object getAdapter(Class adapter) {
        PE pe;
        if (adapter.equals(PE.class)) {
            try {
                if (this.header != null) {
                    return new PE(this.getPath().toOSString(), this.header.getObjectDataOffset());
                }
                return new PE(this.getPath().toOSString());
            }
            catch (IOException iOException) {}
        }
        if (adapter.equals(ISymbolReader.class) && (pe = (PE)this.getAdapter(PE.class)) != null) {
            return pe.getSymbolReader();
        }
        return super.getAdapter(adapter);
    }

    protected PE getPE() throws IOException {
        if (this.header != null) {
            return new PE(this.getPath().toOSString(), this.header.getObjectDataOffset());
        }
        return new PE(this.getPath().toOSString());
    }

    protected void loadAll() throws IOException {
        PE pe = null;
        try {
            pe = this.getPE();
            this.loadInfo(pe);
            this.loadSymbols(pe);
        }
        finally {
            if (pe != null) {
                pe.dispose();
            }
        }
    }

    protected void loadInfo() throws IOException {
        PE pe = null;
        try {
            pe = this.getPE();
            this.loadInfo(pe);
        }
        finally {
            if (pe != null) {
                pe.dispose();
            }
        }
    }

    protected void loadInfo(PE pe) throws IOException {
        this.info = new BinaryObjectAdapter.BinaryObjectInfo();
        PE.Attribute attribute = this.getPE().getAttribute();
        this.info.isLittleEndian = attribute.isLittleEndian();
        this.info.hasDebug = attribute.hasDebug();
        this.info.cpu = attribute.getCPU();
    }

    protected void loadSymbols(PE pe) throws IOException {
        ArrayList list = new ArrayList();
        this.loadSymbols(pe, list);
        this.symbols = list.toArray(this.NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void loadSymbols(PE pe, List list) throws IOException {
        Coff.Symbol[] peSyms = pe.getSymbols();
        byte[] table = pe.getStringTable();
        this.addSymbols(peSyms, table, list);
    }

    protected void addSymbols(Coff.Symbol[] peSyms, byte[] table, List list) {
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isPointer() || peSyms[i].isArray()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                int type = peSyms[i].isFunction() ? 1 : 2;
                list.add(new Symbol(this, name, type, new Addr32(peSyms[i].n_value), 1L));
            }
            ++i;
        }
    }

    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            this.addressFactory = new Addr32Factory();
        }
        return this.addressFactory;
    }
}

