/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfReader
extends Dwarf
implements ISymbolReader {
    static final String[] DWARF_SectionsToParse = new String[]{".debug_info", ".debug_line", ".debug_abbrev", ".debug_str"};
    private Collection<String> m_fileCollection = new ArrayList<String>();
    private String[] m_fileNames = null;
    private String m_exeFileWin32Drive;
    private boolean m_onWindows;
    private boolean m_parsed = false;
    private int m_leb128Size = 0;
    private ArrayList<Integer> m_parsedLineTableOffsets = new ArrayList();
    private int m_parsedLineTableSize = 0;

    public DwarfReader(String file) throws IOException {
        super(file);
    }

    public DwarfReader(Elf exe) throws IOException {
        super(exe);
    }

    @Override
    public void init(Elf exe) throws IOException {
        Elf.Section[] sections;
        Elf.ELFhdr header = exe.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        Elf.Section[] sectionArray = sections = exe.getSections();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.Section section = sectionArray[n2];
            String name = section.toString();
            String[] stringArray = DWARF_SectionsToParse;
            int n3 = DWARF_SectionsToParse.length;
            int n4 = 0;
            while (n4 < n3) {
                String element = stringArray[n4];
                if (name.equals(element)) {
                    try {
                        this.dwarfSections.put(element, section.loadSectionData());
                    }
                    catch (OutOfMemoryError e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.printEnabled = false;
        this.m_parsed = false;
        Path pa = new Path(exe.getFilename());
        this.m_exeFileWin32Drive = pa.getDevice();
        this.m_onWindows = File.separatorChar == '\\';
    }

    void parseSourceInCULineInfo(String cuCompDir, int cuStmtList) {
        byte[] data = (byte[])this.dwarfSections.get(".debug_line");
        if (data != null) {
            try {
                String fileName;
                String str;
                int offset = cuStmtList;
                Integer cuOffset = new Integer(cuStmtList);
                if (!this.m_parsedLineTableOffsets.contains(cuOffset)) {
                    this.m_parsedLineTableOffsets.add(cuOffset);
                    int length = this.read_4_bytes(data, offset) + 4;
                    this.m_parsedLineTableSize += length + 4;
                } else {
                    return;
                }
                offset += 14;
                byte opcode_base = data[offset++];
                offset += opcode_base - 1;
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(cuCompDir);
                while ((str = this.readString(data, offset)).length() != 0) {
                    dirList.add(str);
                    offset += str.length() + 1;
                }
                ++offset;
                while ((fileName = this.readString(data, offset)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data, offset += fileName.length() + 1);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data, offset += this.m_leb128Size);
                    leb128 = this.read_unsigned_leb128(data, offset += this.m_leb128Size);
                    offset += this.m_leb128Size;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void getSourceFilesFromDebugLineSection() {
        byte[] data = (byte[])this.dwarfSections.get(".debug_line");
        if (data == null) {
            return;
        }
        int sectionSize = data.length;
        int minHeaderSize = 16;
        if (this.m_parsedLineTableSize >= sectionSize - minHeaderSize) {
            return;
        }
        int lineTableStart = 0;
        try {
            while (lineTableStart < sectionSize - minHeaderSize) {
                String fileName;
                String str;
                int offset = lineTableStart;
                Integer currLineTableStart = new Integer(lineTableStart);
                int tableLength = this.read_4_bytes(data, offset);
                if ((lineTableStart += tableLength + 4) < sectionSize - minHeaderSize && (lineTableStart & 3) != 0) {
                    boolean dataValid;
                    int ltLength = this.read_4_bytes(data, lineTableStart);
                    short dwarfVer = this.read_2_bytes(data, lineTableStart + 4);
                    byte minInstLengh = data[lineTableStart + 4 + 2 + 4];
                    boolean bl = dataValid = ltLength > minHeaderSize && ltLength < 0x100000 && dwarfVer > 0 && dwarfVer < 4 && minInstLengh > 0 && minInstLengh <= 8;
                    if (!dataValid) {
                        lineTableStart = lineTableStart + 3 & 0xFFFFFFFC;
                    }
                }
                if (this.m_parsedLineTableOffsets.contains(currLineTableStart)) continue;
                offset += 14;
                byte opcode_base = data[offset++];
                offset += opcode_base - 1;
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add("");
                while ((str = this.readString(data, offset)).length() != 0) {
                    dirList.add(str);
                    offset += str.length() + 1;
                }
                ++offset;
                while ((fileName = this.readString(data, offset)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data, offset += fileName.length() + 1);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data, offset += this.m_leb128Size);
                    leb128 = this.read_unsigned_leb128(data, offset += this.m_leb128Size);
                    offset += this.m_leb128Size;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public String[] getSourceFiles() {
        if (!this.m_parsed) {
            this.m_fileCollection.clear();
            this.getSourceFilesFromDebugInfoSection();
            this.getSourceFilesFromDebugLineSection();
            this.m_parsed = true;
            this.m_fileNames = new String[this.m_fileCollection.size()];
            this.m_fileCollection.toArray(this.m_fileNames);
        }
        return this.m_fileNames;
    }

    private void getSourceFilesFromDebugInfoSection() {
        this.parse(null);
    }

    private void addSourceFile(String dir, String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.charAt(0) == '<') {
            return;
        }
        String fullName = name;
        Path dirPa = new Path(dir);
        Path pa = new Path(name);
        if (!pa.isAbsolute() && dir.length() > 0) {
            pa = dirPa.append((IPath)pa);
        }
        if (this.m_onWindows && pa.isAbsolute() && pa.getDevice() == null) {
            if (dirPa.getDevice() != null) {
                pa = pa.setDevice(dirPa.getDevice());
            } else if (this.m_exeFileWin32Drive != null) {
                pa = pa.setDevice(this.m_exeFileWin32Drive);
            }
        }
        if (!this.m_fileCollection.contains(fullName = pa.toOSString())) {
            this.m_fileCollection.add(fullName);
        }
    }

    String readString(byte[] data, int offset) {
        StringBuffer sb = new StringBuffer();
        while (offset < data.length) {
            byte c = data[offset];
            if (c == 0) break;
            sb.append((char)c);
            ++offset;
        }
        String str = sb.toString();
        return str;
    }

    long read_unsigned_leb128(byte[] data, int offset) throws IOException {
        long result = 0L;
        int shift = 0;
        this.m_leb128Size = 0;
        while (true) {
            byte b = data[offset++];
            if (data.length == offset) break;
            ++this.m_leb128Size;
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    @Override
    void processDebugInfoEntry(IDebugEntryRequestor requestor, Dwarf.AbbreviationEntry entry, List<Dwarf.AttributeValue> list) {
        int tag = (int)entry.tag;
        switch (tag) {
            case 17: {
                this.processCompileUnit(requestor, list);
                break;
            }
        }
    }

    @Override
    void processCompileUnit(IDebugEntryRequestor requestor, List<Dwarf.AttributeValue> list) {
        int stmtList = -1;
        String cuCompDir = "";
        String cuName = "";
        int i = 0;
        while (i < list.size()) {
            Dwarf.AttributeValue av = list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 3: {
                        cuName = (String)av.value;
                        break;
                    }
                    case 27: {
                        cuCompDir = (String)av.value;
                        break;
                    }
                    case 16: {
                        stmtList = ((Number)av.value).intValue();
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        this.addSourceFile(cuCompDir, cuName);
        if (stmtList > -1) {
            this.parseSourceInCULineInfo(cuCompDir, stmtList);
        }
    }
}

