/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

abstract class AbstractMergeViewer
extends TextMergeViewer {
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;
    protected boolean fUseSystemColors;

    protected static RGB createColor(IPreferenceStore store, String key) {
        if (!store.contains(key)) {
            return null;
        }
        if (store.isDefault(key)) {
            return PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
    }

    public AbstractMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(parent, style | 0x2000000, configuration);
        IPreferenceStore store = this.getPreferenceStore();
        this.fUseSystemColors = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (!this.fUseSystemColors) {
            RGB bg = AbstractMergeViewer.createColor(store, "AbstractTextEditor.Color.Background");
            this.setBackgroundColor(bg);
            RGB fg = AbstractMergeViewer.createColor(store, "c_default");
            this.setForegroundColor(fg);
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.fPreferenceStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
            this.fPreferenceChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    AbstractMergeViewer.this.handlePropertyChange(event);
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
        return this.fPreferenceStore;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fPreferenceChangeListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            this.fPreferenceChangeListener = null;
        }
        super.handleDispose(event);
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("AbstractTextEditor.Color.Background")) {
            if (!this.fUseSystemColors) {
                RGB bg = AbstractMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
            }
        } else if (key.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.fUseSystemColors = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (this.fUseSystemColors) {
                this.setBackgroundColor(null);
                this.setForegroundColor(null);
            } else {
                RGB bg = AbstractMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
                this.setBackgroundColor(bg);
                RGB fg = AbstractMergeViewer.createColor(this.fPreferenceStore, "c_default");
                this.setForegroundColor(fg);
            }
        } else if (key.equals("c_default") && !this.fUseSystemColors) {
            RGB fg = AbstractMergeViewer.createColor(this.fPreferenceStore, "c_default");
            this.setForegroundColor(fg);
        }
    }

    protected String getDocumentPartitioning() {
        return "___c_partitioning";
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return CUIPlugin.getDefault().getTextTools().createDocumentPartitioner(null);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            ((SourceViewer)textViewer).configure(this.getSourceViewerConfiguration());
        }
    }

    public abstract String getTitle();

    protected abstract SourceViewerConfiguration getSourceViewerConfiguration();
}

