/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.net.URI;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.ui.editor.DocumentAdapter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CustomBufferFactory
implements IBufferFactory {
    public IBuffer createBuffer(IOpenable owner) {
        if (owner instanceof IWorkingCopy) {
            IWorkingCopy unit = (IWorkingCopy)owner;
            ITranslationUnit original = unit.getOriginalElement();
            IResource resource = original.getResource();
            if (resource instanceof IFile) {
                IFile fFile = (IFile)resource;
                DocumentAdapter adapter = new DocumentAdapter(owner, fFile);
                return adapter;
            }
            IPath location = original.getLocation();
            if (location != null) {
                return new DocumentAdapter(owner, location);
            }
            URI locationUri = original.getLocationURI();
            if (locationUri != null) {
                try {
                    return new DocumentAdapter(owner, locationUri);
                }
                catch (CoreException exc) {
                    CUIPlugin.log(exc);
                }
            }
        }
        return DocumentAdapter.NULL;
    }
}

