/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemTypeId;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRefactoring
extends Refactoring {
    private static final int AST_STYLE = 34;
    protected String name = Messages.Refactoring_name;
    protected IFile file;
    protected Region region;
    protected RefactoringStatus initStatus;
    protected IASTTranslationUnit unit;
    private IIndex fIndex;

    public CRefactoring(IFile file, ISelection selection, ICElement element) {
        if (element instanceof ISourceReference) {
            ISourceReference sourceRef = (ISourceReference)element;
            ITranslationUnit tu = sourceRef.getTranslationUnit();
            IResource res = tu.getResource();
            if (res instanceof IFile) {
                this.file = (IFile)res;
            }
            try {
                ISourceRange sourceRange = sourceRef.getSourceRange();
                this.region = new Region(sourceRange.getIdStartPos(), sourceRange.getIdLength());
            }
            catch (CModelException e) {
                CCorePlugin.log((Throwable)e);
            }
        } else {
            this.file = file;
            this.region = SelectionHelper.getRegion(selection);
        }
        this.initStatus = new RefactoringStatus();
        if (this.file == null || this.region == null) {
            this.initStatus.addFatalError(Messages.Refactoring_SelectionNotValid);
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        sm.subTask(Messages.Refactoring_PM_LoadTU);
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        if (!this.loadTranslationUnit(this.initStatus, (IProgressMonitor)sm.newChild(8))) {
            this.initStatus.addError(Messages.Refactoring_CantLoadTU);
        }
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        sm.subTask(Messages.Refactoring_PM_CheckTU);
        this.translationUnitHasProblem();
        if (this.translationUnitIsAmbiguous()) {
            this.initStatus.addError(Messages.Refactoring_Ambiguity);
        }
        sm.worked(2);
        sm.subTask(Messages.Refactoring_PM_InitRef);
        sm.done();
        return this.initStatus;
    }

    protected boolean isProgressMonitorCanceld(IProgressMonitor sm, RefactoringStatus initStatus2) {
        if (sm.isCanceled()) {
            initStatus2.addFatalError(Messages.Refactoring_CanceledByUser);
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ModificationCollector collector = new ModificationCollector();
        this.collectModifications(pm, collector);
        return collector.createFinalChange();
    }

    protected abstract void collectModifications(IProgressMonitor var1, ModificationCollector var2) throws CoreException, OperationCanceledException;

    public String getName() {
        return this.name;
    }

    protected boolean loadTranslationUnit(RefactoringStatus status, IProgressMonitor mon) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)10);
        if (this.file != null) {
            block4: {
                try {
                    subMonitor.subTask(Messages.Refactoring_PM_ParseTU);
                    this.unit = this.loadTranslationUnit(this.file);
                    subMonitor.worked(2);
                    if (!this.isProgressMonitorCanceld((IProgressMonitor)subMonitor, this.initStatus)) break block4;
                    return true;
                }
                catch (CoreException e) {
                    status.addFatalError(e.getMessage());
                    subMonitor.done();
                    return false;
                }
            }
            subMonitor.subTask(Messages.Refactoring_PM_MergeComments);
            subMonitor.worked(8);
        }
        status.addFatalError(Messages.NO_FILE);
        subMonitor.done();
        return false;
        subMonitor.done();
        return true;
    }

    protected IASTTranslationUnit loadTranslationUnit(IFile file) throws CoreException {
        ITranslationUnit tu = (ITranslationUnit)CCorePlugin.getDefault().getCoreModel().create(file);
        return tu.getAST(this.fIndex, 34);
    }

    protected boolean translationUnitHasProblem() {
        ProblemFinder pf = new ProblemFinder(this.initStatus);
        this.unit.accept((ASTVisitor)pf);
        return pf.hasProblem();
    }

    protected boolean translationUnitIsAmbiguous() {
        AmbiguityFinder af = new AmbiguityFinder();
        this.unit.accept((ASTVisitor)af);
        return af.ambiguityFound();
    }

    public void lockIndex() throws CoreException, InterruptedException {
        if (this.fIndex == null) {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            this.fIndex = CCorePlugin.getIndexManager().getIndex(projects);
        }
        this.fIndex.acquireReadLock();
    }

    public void unlockIndex() {
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
        }
        this.fIndex = null;
    }

    public IIndex getIndex() {
        return this.fIndex;
    }

    protected ArrayList<IASTName> findAllMarkedNames() {
        final ArrayList<IASTName> namesVector = new ArrayList<IASTName>();
        this.unit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                if (SelectionHelper.isInSameFileSelection(CRefactoring.this.region, (IASTNode)name, CRefactoring.this.file) && !(name instanceof ICPPASTQualifiedName)) {
                    namesVector.add(name);
                }
                return super.visit(name);
            }
        });
        return namesVector;
    }

    private class AmbiguityFinder
    extends ASTVisitor {
        private boolean ambiguityFound = false;

        private AmbiguityFinder() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTAmbiguousDeclaration) {
                this.ambiguityFound = true;
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTAmbiguousExpression) {
                this.ambiguityFound = true;
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTAmbiguousStatement) {
                this.ambiguityFound = true;
            }
            return 3;
        }

        public boolean ambiguityFound() {
            return this.ambiguityFound;
        }
    }

    private class ProblemFinder
    extends ASTVisitor {
        private boolean problemFound = false;
        private final RefactoringStatus status;

        public ProblemFinder(RefactoringStatus status) {
            this.shouldVisitProblems = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitTypeIds = true;
            this.status = status;
        }

        public int visit(IASTProblem problem) {
            this.addWarningToState();
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTProblemDeclaration) {
                this.addWarningToState();
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTProblemExpression) {
                this.addWarningToState();
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTProblemStatement) {
                this.addWarningToState();
            }
            return 3;
        }

        public int visit(IASTTypeId typeId) {
            if (typeId instanceof IASTProblemTypeId) {
                this.addWarningToState();
            }
            return 3;
        }

        public boolean hasProblem() {
            return this.problemFound;
        }

        private void addWarningToState() {
            if (!this.problemFound) {
                this.status.addWarning(Messages.Refactoring_CompileErrorInTU);
                this.problemFound = true;
            }
        }
    }
}

