/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterAndSetterContext;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterInsertEditProvider;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class GenerateGettersAndSettersRefactoring
extends CRefactoring {
    private static final String MEMBER_DECLARATION = "MEMBER_DECLARATION";
    private final GetterAndSetterContext context = new GetterAndSetterContext();

    public GenerateGettersAndSettersRefactoring(IFile file, ISelection selection, ICElement element) {
        super(file, selection, element);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        this.initRefactoring(pm);
        if (this.context.existingFields.size() == 0) {
            this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoFields);
        }
        return this.initStatus;
    }

    private void initRefactoring(IProgressMonitor pm) {
        this.loadTranslationUnit(this.initStatus, pm);
        this.context.setUnit(this.unit);
        this.context.selectedName = this.getSelectedName();
        this.findDeclarations();
    }

    private IASTName getSelectedName() {
        ArrayList<IASTName> names = this.findAllMarkedNames();
        if (names.size() < 1) {
            return null;
        }
        return names.get(names.size() - 1);
    }

    protected void findDeclarations() {
        this.unit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IASTFunctionDefinition functionDefinition;
                IASTDeclarator[] declarators;
                IASTSimpleDeclaration fieldDeclaration;
                ASTNodeProperty props;
                if (declaration instanceof IASTSimpleDeclaration && (props = (fieldDeclaration = (IASTSimpleDeclaration)declaration).getPropertyInParent()).getName().contains(GenerateGettersAndSettersRefactoring.MEMBER_DECLARATION) && (declarators = fieldDeclaration.getDeclarators()).length > 0) {
                    if (declarators[0] instanceof IASTFunctionDeclarator) {
                        ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDeclarations.add(fieldDeclaration);
                    } else if (SelectionHelper.isInSameFile((IASTNode)fieldDeclaration, GenerateGettersAndSettersRefactoring.this.file)) {
                        ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFields.add(fieldDeclaration);
                    }
                }
                if (declaration instanceof IASTFunctionDefinition && (props = (functionDefinition = (IASTFunctionDefinition)declaration).getPropertyInParent()).getName().contains(GenerateGettersAndSettersRefactoring.MEMBER_DECLARATION)) {
                    ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDefinitions.add(functionDefinition);
                }
                return super.visit(declaration);
            }
        });
    }

    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        ArrayList<IASTNode> getterAndSetters = new ArrayList<IASTNode>();
        for (GetterSetterInsertEditProvider currentProvider : this.context.selectedFunctions) {
            getterAndSetters.add((IASTNode)currentProvider.getFunction());
        }
        ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)this.context.existingFields.get(this.context.existingFields.size() - 1).getParent();
        AddDeclarationNodeToClassChange.createChange(classDefinition, VisibilityEnum.v_public, getterAndSetters, false, collector);
    }

    public GetterAndSetterContext getContext() {
        return this.context;
    }

    public Region getRegion() {
        return this.region;
    }
}

