/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.PseudoNameGenerator;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterHandler {
    private boolean needsAditionalArgumentNames;
    private PseudoNameGenerator pseudoNameGenerator;
    private ArrayList<ParameterInfo> parameterInfos;
    private ImplementMethodRefactoring refactoring;

    public ParameterHandler(ImplementMethodRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public boolean needsAdditionalArgumentNames() {
        return this.needsAditionalArgumentNames;
    }

    public void initArgumentNames() {
        if (this.parameterInfos != null) {
            return;
        }
        this.needsAditionalArgumentNames = false;
        this.parameterInfos = new ArrayList();
        IASTParameterDeclaration[] iASTParameterDeclarationArray = this.getParametersFromMethodNode();
        int n = iASTParameterDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTParameterDeclaration actParam = iASTParameterDeclarationArray[n2];
            String actName = actParam.getDeclarator().getName().toString();
            boolean isChangable = false;
            if (actName.length() == 0) {
                this.needsAditionalArgumentNames = true;
                isChangable = true;
                actName = this.findNameForParameter(NameHelper.getTypeName(actParam));
            }
            this.parameterInfos.add(new ParameterInfo(actParam, actName, isChangable));
            ++n2;
        }
    }

    private String findNameForParameter(String typeName) {
        if (this.pseudoNameGenerator == null) {
            this.pseudoNameGenerator = new PseudoNameGenerator();
            IASTParameterDeclaration[] iASTParameterDeclarationArray = this.getParametersFromMethodNode();
            int n = iASTParameterDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTParameterDeclaration parameter = iASTParameterDeclarationArray[n2];
                if (parameter.getDeclarator().getName().toString().length() != 0) {
                    this.pseudoNameGenerator.addExistingName(parameter.getDeclarator().getName().toString());
                }
                ++n2;
            }
        }
        return this.pseudoNameGenerator.generateNewName(typeName);
    }

    private IASTParameterDeclaration[] getParametersFromMethodNode() {
        if (this.refactoring.getMethodDeclaration().getDeclarators().length < 1) {
            return null;
        }
        return ((ICPPASTFunctionDeclarator)this.refactoring.getMethodDeclaration().getDeclarators()[0]).getParameters();
    }

    public String createFunctionDefinitionSignature() {
        try {
            CompositeChange compositeChange = (CompositeChange)this.refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            InsertEdit insertEdit = this.getInsertEdit(compositeChange);
            return insertEdit.getText().trim();
        }
        catch (OperationCanceledException operationCanceledException) {
            return Messages.PreviewGenerationNotPossible;
        }
        catch (CoreException coreException) {
            return Messages.PreviewGenerationNotPossible;
        }
    }

    private InsertEdit getInsertEdit(CompositeChange compositeChange) {
        Change[] changeArray = compositeChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTextFileChange textFileChange;
            MultiTextEdit multiEdit;
            Change actChange = changeArray[n2];
            if (actChange instanceof CompositeChange) {
                return this.getInsertEdit((CompositeChange)actChange);
            }
            if (actChange instanceof CTextFileChange && (multiEdit = (MultiTextEdit)(textFileChange = (CTextFileChange)actChange).getEdit()).getChildrenSize() != 0) {
                return (InsertEdit)multiEdit.getChildren()[0];
            }
            ++n2;
        }
        return null;
    }

    public Collection<ParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }
}

