/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.HashMap;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.ValidatingLabeledTextField;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterHandler;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.DelayedJobRunner;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParameterNamesInputPage
extends UserInputWizardPage {
    private final ParameterHandler parameterHandler;
    private TranslationUnitPreview translationUnitPreview;
    private DelayedJobRunner delayedPreviewUpdater;

    public ParameterNamesInputPage(ParameterHandler parameterHandler) {
        super(Messages.ParameterNamesInputPage_Title);
        this.parameterHandler = parameterHandler;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        superComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(superComposite, 0);
        label.setText(Messages.ParameterNamesInputPage_CompleteMissingMails);
        label.setLayoutData((Object)new GridData(768));
        ValidatingLabeledTextField validatingLabeledTextField = new ValidatingLabeledTextField(superComposite);
        validatingLabeledTextField.setLayoutData(new GridData(768));
        for (final ParameterInfo actParameterInfo : this.parameterHandler.getParameterInfos()) {
            String type = actParameterInfo.getTypeName();
            String content = actParameterInfo.getParameterName();
            boolean readOnly = !actParameterInfo.hasNewName();
            validatingLabeledTextField.addElement(type, content, readOnly, new ValidatingLabeledTextField.Validator(){

                public void hasErrors() {
                    ParameterNamesInputPage.this.setPageComplete(false);
                }

                public void hasNoErrors() {
                    ParameterNamesInputPage.this.setPageComplete(true);
                }

                public boolean isValidInput(String newName) {
                    actParameterInfo.setParameterName(newName);
                    ParameterNamesInputPage.this.updatePreview();
                    return true;
                }
            });
        }
        this.createPreview(superComposite);
        this.setControl((Control)superComposite);
    }

    private void createPreview(Composite superComposite) {
        this.translationUnitPreview = new TranslationUnitPreview(new HashMap<String, String>(), superComposite);
        this.translationUnitPreview.getControl().setLayoutData((Object)new GridData(768));
        Runnable runnable = new Runnable(){

            public void run() {
                this.setPreviewText(Messages.ImplementMethodRefactoringPage_GeneratingPreview);
                this.setPreviewText(ParameterNamesInputPage.this.parameterHandler.createFunctionDefinitionSignature());
            }

            private void setPreviewText(final String text) {
                ParameterNamesInputPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ParameterNamesInputPage.this.translationUnitPreview.setPreviewText(text);
                    }
                });
            }
        };
        this.delayedPreviewUpdater = new DelayedJobRunner(runnable, 500L);
        this.delayedPreviewUpdater.start();
        superComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ParameterNamesInputPage.this.delayedPreviewUpdater.stop();
            }
        });
    }

    private void updatePreview() {
        if (this.translationUnitPreview == null) {
            return;
        }
        this.delayedPreviewUpdater.runJob();
    }
}

