/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TranslationUnitHelper {
    public static IASTTranslationUnit loadTranslationUnit(String filename) {
        if (filename != null) {
            Path path = new Path(filename);
            IFile tmpFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            return TranslationUnitHelper.loadTranslationUnit(tmpFile);
        }
        return null;
    }

    public static IASTTranslationUnit loadTranslationUnit(IFile tmpFile) {
        if (tmpFile != null) {
            try {
                IASTTranslationUnit fileUnit = CDOM.getInstance().getTranslationUnit(tmpFile, CDOM.getInstance().getCodeReaderFactory(0), true);
                return fileUnit;
            }
            catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {
                return null;
            }
        }
        return null;
    }

    public static IASTName findNameInTranslationUnit(IASTTranslationUnit transUnit, IASTNode oldName) {
        final String oldFileName = oldName.getFileLocation().getFileName();
        final IASTFileLocation pos = oldName.getFileLocation();
        final Container nameCon = new Container();
        transUnit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName locName) {
                IASTFileLocation locFileLocation = locName.getFileLocation();
                if (locFileLocation != null && oldFileName.equals(locFileLocation.getFileName()) && pos.getNodeOffset() == locFileLocation.getNodeOffset() && pos.getNodeLength() == locFileLocation.getNodeLength()) {
                    nameCon.setObject(locName);
                    return 2;
                }
                return super.visit(locName);
            }
        });
        return (IASTName)nameCon.getObject();
    }

    public static IASTNode getFirstNode(IASTTranslationUnit unit) {
        IASTDeclaration firstNode = null;
        IASTDeclaration[] iASTDeclarationArray = unit.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration each = iASTDeclarationArray[n2];
            if (firstNode == null) {
                firstNode = each;
            } else if (each.getNodeLocations() != null && each.getNodeLocations()[0].getNodeOffset() < firstNode.getNodeLocations()[0].getNodeOffset()) {
                firstNode = each;
            }
            ++n2;
        }
        return firstNode;
    }
}

