/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.internal.ui.text.CCodeScanner;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.CPreprocessorScanner;
import org.eclipse.cdt.internal.ui.text.FastCPartitionScanner;
import org.eclipse.cdt.internal.ui.text.FastCPartitioner;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.TokenStore;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICPartitions;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CTextTools {
    private CColorManager fColorManager;
    private CCodeScanner fCodeScanner;
    private CCodeScanner fCppCodeScanner;
    private CCommentScanner fMultilineCommentScanner;
    private CCommentScanner fSinglelineCommentScanner;
    private SingleTokenCScanner fStringScanner;
    private CPreprocessorScanner fCPreprocessorScanner;
    private CPreprocessorScanner fCppPreprocessorScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();
    private String fDocumentPartitioning = "___c_partitioning";

    public CTextTools(IPreferenceStore store) {
        this(store, null, true);
    }

    public CTextTools(IPreferenceStore store, Preferences coreStore) {
        this(store, coreStore, true);
    }

    public CTextTools(IPreferenceStore store, Preferences coreStore, boolean autoDisposeOnDisplayDispose) {
        this.fPreferenceStore = store != null ? store : CUIPlugin.getDefault().getPreferenceStore();
        this.fColorManager = new CColorManager(autoDisposeOnDisplayDispose);
        ITokenStoreFactory factory = new ITokenStoreFactory(){

            public ITokenStore createTokenStore(String[] propertyColorNames) {
                return new TokenStore(CTextTools.this.getColorManager(), CTextTools.this.fPreferenceStore, propertyColorNames);
            }
        };
        this.fMultilineCommentScanner = new CCommentScanner(factory, coreStore, "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(factory, coreStore, "c_single_line_comment");
        this.fCodeScanner = new CCodeScanner(factory, (ICLanguageKeywords)GCCLanguage.getDefault());
        this.fCppCodeScanner = new CCodeScanner(factory, (ICLanguageKeywords)GPPLanguage.getDefault());
        this.fStringScanner = new SingleTokenCScanner(factory, "c_string");
        this.fCPreprocessorScanner = new CPreprocessorScanner(factory, (ICLanguageKeywords)GCCLanguage.getDefault());
        this.fCppPreprocessorScanner = new CPreprocessorScanner(factory, (ICLanguageKeywords)GPPLanguage.getDefault());
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = coreStore;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    public CTextTools() {
        this(null);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public CColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getCppCodeScanner() {
        return this.fCppCodeScanner;
    }

    public IPartitionTokenScanner getPartitionScanner(IDocCommentOwner owner) {
        return new FastCPartitionScanner(owner);
    }

    public IDocumentPartitioner createDocumentPartitioner(IDocCommentOwner owner) {
        return new FastCPartitioner(this.getPartitionScanner(owner), ICPartitions.ALL_CPARTITIONS);
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public RuleBasedScanner getCPreprocessorScanner() {
        return this.fCPreprocessorScanner;
    }

    public RuleBasedScanner getCppPreprocessorScanner() {
        return this.fCppPreprocessorScanner;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fCppCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fCPreprocessorScanner.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fCppCodeScanner.affectsBehavior(event)) {
            this.fCppCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fCPreprocessorScanner.affectsBehavior(event)) {
            this.fCPreprocessorScanner.adaptToPreferenceChange(event);
            this.fCppPreprocessorScanner.adaptToPreferenceChange(event);
        }
    }

    public void setupCDocumentPartitioner(IDocument document, String partitioning, IDocCommentOwner owner) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner(owner);
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    public void setupCDocument(IDocument document, IPath location, LocationKind locationKind) {
        IDocCommentOwner owner = this.getDocumentationCommentOwner(location, locationKind);
        this.setupCDocumentPartitioner(document, this.fDocumentPartitioning, owner);
    }

    public void setupCDocument(IDocument document) {
        this.setupCDocumentPartitioner(document, this.fDocumentPartitioning, null);
    }

    public String getDocumentPartitioning() {
        return this.fDocumentPartitioning;
    }

    public void setDocumentPartitioning(String documentPartitioning) {
        this.fDocumentPartitioning = documentPartitioning;
    }

    private IDocCommentOwner getDocumentationCommentOwner(IPath location, LocationKind locationKind) {
        if (location != null && LocationKind.IFILE.equals(locationKind)) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
            return DocCommentOwnerManager.getInstance().getCommentOwner((IResource)file);
        }
        return DocCommentOwnerManager.getInstance().getWorkspaceCommentOwner();
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            CTextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            CTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

