/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionAssistant;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionProcessor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.cdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.cdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class CorrectionCommandHandler
extends AbstractHandler {
    private final CEditor fEditor;
    private final String fId;
    private final boolean fIsAssist;

    public CorrectionCommandHandler(CEditor editor, String id, boolean isAssist) {
        this.fEditor = editor;
        this.fId = id;
        this.fIsAssist = isAssist;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICompletionProposal proposal;
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        IWorkingCopy cu = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel model = CUIPlugin.getDefault().getDocumentProvider().getAnnotationModel(this.fEditor.getEditorInput());
        if (selection instanceof ITextSelection && cu != null && model != null && (proposal = this.findCorrection(this.fId, this.fIsAssist, (ITextSelection)selection, (ITranslationUnit)cu, model)) != null) {
            this.invokeProposal(proposal, ((ITextSelection)selection).getOffset());
        }
        return null;
    }

    private ICompletionProposal findCorrection(String id, boolean isAssist, ITextSelection selection, ITranslationUnit cu, IAnnotationModel model) {
        CorrectionContext context = new CorrectionContext(cu, selection.getOffset(), selection.getLength());
        ArrayList<ICCompletionProposal> proposals = new ArrayList<ICCompletionProposal>(10);
        if (isAssist) {
            CCorrectionProcessor.collectAssists(context, new ProblemLocation[0], proposals);
        } else {
            try {
                boolean goToClosest = selection.getLength() == 0;
                Annotation[] annotationArray = this.getAnnotations(selection.getOffset(), goToClosest);
                CCorrectionProcessor.collectProposals(context, model, annotationArray, true, false, proposals);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        for (Object e : proposals) {
            if (!(e instanceof ICommandAccess) || !id.equals(((ICommandAccess)e).getCommandId())) continue;
            return (ICompletionProposal)e;
        }
        return null;
    }

    private Annotation[] getAnnotations(int offset, boolean goToClosest) throws BadLocationException {
        ArrayList<Annotation> resultingAnnotations = new ArrayList<Annotation>();
        CCorrectionAssistant.collectQuickFixableAnnotations((ITextEditor)this.fEditor, offset, goToClosest, resultingAnnotations);
        return resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
    }

    private IDocument getDocument() {
        return CUIPlugin.getDefault().getDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void invokeProposal(ICompletionProposal proposal, int offset) {
        IDocument document;
        if (proposal instanceof ICompletionProposalExtension2) {
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer != null) {
                ((ICompletionProposalExtension2)proposal).apply((ITextViewer)viewer, '\u0000', 0, offset);
                return;
            }
        } else if (proposal instanceof ICompletionProposalExtension && (document = this.getDocument()) != null) {
            ((ICompletionProposalExtension)proposal).apply(document, '\u0000', offset);
            return;
        }
        if ((document = this.getDocument()) != null) {
            proposal.apply(document);
        }
    }

    public static String getShortCutString(String proposalId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingService;
        if (proposalId != null && (bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)) != null && (activeBindingsFor = bindingService.getActiveBindingsFor(proposalId)).length > 0) {
            return activeBindingsFor[0].format();
        }
        return null;
    }
}

