/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class WorkingSetConfigAction
implements IWorkbenchWindowActionDelegate,
IPropertyChangeListener {
    private static final String DELIMITER = " ";
    private static final String EMPTY_STR = "";
    private static final String CURRENT = UIMessages.getString("WorkingSetConfigAction.10");
    public static final Image IMG_PROJ = CPluginImages.get("org.eclipse.cdt.ui.cfolder_obj.gif");
    public static final Image IMG_CONF = CPluginImages.get("org.eclipse.cdt.ui.config.gif");
    private static final Shell sh = CUIPlugin.getDefault().getShell();
    private static final IWorkingSetManager wsm = CUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
    private LinkedHashMap<String, IWorkingSet> workingSetsMap;
    private LinkedHashMap<String, ConfigSet> configSetMap;
    private boolean enabled = true;

    public void run(IAction action) {
        LocalDialog dlg = new LocalDialog(sh);
        dlg.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.checkWS();
        if (action.isEnabled() != this.enabled) {
            action.setEnabled(this.enabled);
        }
    }

    public void dispose() {
        wsm.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void init(IWorkbenchWindow window) {
        wsm.addPropertyChangeListener((IPropertyChangeListener)this);
        this.checkWS();
    }

    private IWorkingSet[] checkWS() {
        IWorkingSet[] w = wsm.getWorkingSets();
        if (w == null) {
            w = new IWorkingSet[]{};
        }
        this.enabled = w.length > 0;
        return w;
    }

    private String[] getWSnames() {
        IWorkingSet[] w = this.checkWS();
        this.workingSetsMap = new LinkedHashMap(w.length);
        IWorkingSet[] iWorkingSetArray = w;
        int n = w.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet ws = iWorkingSetArray[n2];
            this.workingSetsMap.put(ws.getLabel(), ws);
            ++n2;
        }
        return this.workingSetsMap.keySet().toArray(new String[w.length]);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.checkWS();
    }

    private static final class BuildJob
    extends Job {
        IProject[] ps;

        BuildJob(IProject[] _ps) {
            super(UIMessages.getString("WorkingSetConfigAction.21"));
            this.ps = _ps;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProject[] iProjectArray = this.ps;
            int n = this.ps.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                try {
                    this.setName(String.valueOf(UIMessages.getString("WorkingSetConfigAction.21")) + p.getName());
                    p.build(10, monitor);
                }
                catch (CoreException e) {
                    return new Status(4, UIMessages.getString("WorkingSetConfigAction.22"), e.getLocalizedMessage());
                }
                ++n2;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }

    private static class ConfigSet {
        String name;
        String workingSetLabel;
        LinkedHashMap<String, String> data = new LinkedHashMap();

        private ConfigSet(String s) {
            String[] ss = s.split(WorkingSetConfigAction.DELIMITER);
            if (ss == null || ss.length < 4 || ss.length % 2 == 1) {
                CUIPlugin.getDefault().logErrorMessage(String.valueOf(UIMessages.getString("WorkingSetConfigAction.13")) + s);
                return;
            }
            this.name = ss[0];
            this.workingSetLabel = ss[1];
            int n = (ss.length - 2) / 2;
            int i = 0;
            while (i < n) {
                this.data.put(ss[2 + i * 2], ss[3 + i * 2]);
                ++i;
            }
        }

        private ConfigSet(String n, String w, Tree t) {
            this.name = n;
            this.workingSetLabel = w;
            TreeItem[] treeItemArray = t.getItems();
            int n2 = treeItemArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TreeItem ti = treeItemArray[n3];
                ICProjectDescription prjd = (ICProjectDescription)ti.getData();
                TreeItem[] treeItemArray2 = ti.getItems();
                int n4 = treeItemArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    TreeItem ti1 = treeItemArray2[n5];
                    if (ti1.getChecked()) {
                        ICConfigurationDescription cfg = (ICConfigurationDescription)ti1.getData();
                        this.data.put(prjd.getName(), cfg.getId());
                        break;
                    }
                    ++n5;
                }
                ++n3;
            }
        }

        private boolean isValid() {
            return this.data.size() > 0;
        }

        public String toString() {
            if (!this.isValid()) {
                return WorkingSetConfigAction.EMPTY_STR;
            }
            StringBuilder b = new StringBuilder();
            b.append(this.name);
            b.append(WorkingSetConfigAction.DELIMITER);
            b.append(this.workingSetLabel);
            b.append(WorkingSetConfigAction.DELIMITER);
            for (Map.Entry<String, String> me : this.data.entrySet()) {
                b.append(me.getKey());
                b.append(WorkingSetConfigAction.DELIMITER);
                b.append(me.getValue());
                b.append(WorkingSetConfigAction.DELIMITER);
            }
            return b.toString().trim();
        }
    }

    private class LocalDialog
    extends TrayDialog {
        private List wsets;
        private List csets;
        private Tree tree;
        private Button b1;
        private Button b2;
        private Button b3;
        private Button b4;
        private Button bb;

        LocalDialog(Shell parentShell) {
            super(parentShell);
            this.setHelpAvailable(false);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.saveConfigSets();
                this.saveActiveConfigs();
            }
            super.buttonPressed(buttonId);
        }

        private void saveConfigSets() {
            ArrayList<String> out = new ArrayList<String>(WorkingSetConfigAction.this.configSetMap.size());
            for (ConfigSet cs : WorkingSetConfigAction.this.configSetMap.values()) {
                if (!cs.isValid() || cs.name.equals(CURRENT)) continue;
                out.add(cs.toString());
            }
            CDTPrefUtil.saveConfigSets(out);
        }

        private void saveActiveConfigs() {
            TreeItem[] treeItemArray = this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem ti = treeItemArray[n2];
                ICProjectDescription pd = (ICProjectDescription)ti.getData();
                TreeItem[] treeItemArray2 = ti.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem ti1 = treeItemArray2[n4];
                    if (ti1.getChecked()) {
                        ((ICConfigurationDescription)ti1.getData()).setActive();
                        break;
                    }
                    ++n4;
                }
                try {
                    CoreModel.getDefault().setProjectDescription(pd.getProject(), pd);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    CUIPlugin.log(e);
                }
                ++n2;
            }
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(UIMessages.getString("WorkingSetConfigAction.1"));
        }

        protected Control createDialogArea(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.cdt.ui.man_prop_build");
            Composite comp = new Composite(parent, 0);
            comp.setFont(parent.getFont());
            comp.setLayout((Layout)new GridLayout(2, false));
            comp.setLayoutData((Object)new GridData(1808));
            SashForm sashForm = new SashForm(comp, 0);
            sashForm.setOrientation(512);
            GridData gd = new GridData(1040);
            gd.verticalSpan = 3;
            sashForm.setLayoutData((Object)gd);
            Composite ws = new Composite((Composite)sashForm, 0);
            ws.setLayoutData((Object)new GridData(1808));
            ws.setLayout((Layout)new GridLayout(1, false));
            Label l1 = new Label(ws, 0);
            l1.setText(UIMessages.getString("WorkingSetConfigAction.2"));
            l1.setLayoutData((Object)new GridData(768));
            this.wsets = new List(ws, 2052);
            this.wsets.setLayoutData((Object)new GridData(1808));
            this.wsets.setItems(WorkingSetConfigAction.this.getWSnames());
            this.wsets.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    LocalDialog.this.workingSetChanged();
                }

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.workingSetChanged();
                }
            });
            if (this.wsets.getItemCount() == 0) {
                this.wsets.add(UIMessages.getString("WorkingSetConfigAction.3"));
                this.wsets.setEnabled(false);
            } else {
                IWorkingSet[] w = wsm.getRecentWorkingSets();
                if (w == null || w.length == 0) {
                    this.wsets.setSelection(0);
                } else {
                    String s = w[0].getLabel();
                    String[] ss = this.wsets.getItems();
                    int i = 0;
                    while (i < ss.length) {
                        if (ss[i].equals(s)) {
                            this.wsets.setSelection(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            Composite cs = new Composite((Composite)sashForm, 0);
            cs.setLayoutData((Object)new GridData(1808));
            cs.setLayout((Layout)new GridLayout(1, false));
            l1 = new Label(cs, 0);
            l1.setText(UIMessages.getString("WorkingSetConfigAction.4"));
            l1.setLayoutData((Object)new GridData(768));
            this.csets = new List(cs, 2052);
            this.csets.setLayoutData((Object)new GridData(1808));
            this.csets.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    LocalDialog.this.configSetChanged();
                }

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.configSetChanged();
                }
            });
            sashForm.setWeights(new int[]{50, 50});
            l1 = new Label(comp, 0);
            l1.setText(UIMessages.getString("WorkingSetConfigAction.5"));
            gd = new GridData(768);
            gd.verticalIndent = 5;
            l1.setLayoutData((Object)gd);
            this.tree = new Tree(comp, 2084);
            gd = new GridData(1808);
            gd.heightHint = 200;
            gd.widthHint = 200;
            this.tree.setLayoutData((Object)gd);
            this.tree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = UIMessages.getString("WorkingSetConfigAction.17");
                }
            });
            this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if ((e.detail & 0x20) == 32 && e.item != null && e.item instanceof TreeItem) {
                        TreeItem sel = (TreeItem)e.item;
                        if (sel.getData() instanceof ICProjectDescription) {
                            sel.setChecked(false);
                        } else {
                            String txt = sel.getChecked() ? sel.getText() : WorkingSetConfigAction.EMPTY_STR;
                            TreeItem[] treeItemArray = sel.getParentItem().getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem obj = treeItemArray[n2];
                                if (txt == null) {
                                    obj.setChecked(false);
                                } else if (txt == WorkingSetConfigAction.EMPTY_STR || txt.equals(obj.getText())) {
                                    obj.setChecked(true);
                                    txt = null;
                                } else {
                                    obj.setChecked(false);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            });
            this.tree.addTreeListener(new TreeListener(){

                public void treeCollapsed(TreeEvent e) {
                }

                public void treeExpanded(TreeEvent e) {
                }
            });
            Composite c = new Composite(comp, 0);
            c.setLayoutData((Object)new GridData(768));
            c.setLayout((Layout)new GridLayout(2, true));
            this.b2 = new Button(c, 8);
            this.b2.setText(UIMessages.getString("WorkingSetConfigAction.7"));
            this.b2.setLayoutData((Object)new GridData(768));
            this.b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newS = LocalDialog.this.getString(UIMessages.getString("WorkingSetConfigAction.18"), null);
                    if (newS == null) {
                        return;
                    }
                    String key = String.valueOf(LocalDialog.this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + newS;
                    if (WorkingSetConfigAction.this.configSetMap.containsKey(key)) {
                        return;
                    }
                    ConfigSet cs = new ConfigSet(newS, LocalDialog.this.wsets.getSelection()[0], LocalDialog.this.tree);
                    WorkingSetConfigAction.this.configSetMap.put(key, cs);
                    LocalDialog.this.csets.add(newS);
                    LocalDialog.this.csets.setSelection(LocalDialog.this.csets.getItemCount() - 1);
                    LocalDialog.this.updateButtons();
                }
            });
            this.b1 = new Button(c, 8);
            this.b1.setText(UIMessages.getString("WorkingSetConfigAction.6"));
            this.b1.setLayoutData((Object)new GridData(768));
            this.b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String oldS = LocalDialog.this.csets.getItem(LocalDialog.this.csets.getSelectionIndex());
                    ConfigSet cs = new ConfigSet(oldS, LocalDialog.this.wsets.getSelection()[0], LocalDialog.this.tree);
                    WorkingSetConfigAction.this.configSetMap.put(String.valueOf(LocalDialog.this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + oldS, cs);
                }
            });
            this.b3 = new Button(c, 8);
            this.b3.setText(UIMessages.getString("WorkingSetConfigAction.8"));
            this.b3.setLayoutData((Object)new GridData(768));
            this.b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int n = LocalDialog.this.csets.getSelectionIndex();
                    if (n > 0) {
                        String oldS = LocalDialog.this.csets.getItem(n);
                        String newS = LocalDialog.this.getString(UIMessages.getString("WorkingSetConfigAction.19"), oldS);
                        if (newS == null) {
                            return;
                        }
                        if (oldS.equals(newS)) {
                            return;
                        }
                        String key = String.valueOf(LocalDialog.this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + newS;
                        if (WorkingSetConfigAction.this.configSetMap.containsKey(key)) {
                            LocalDialog.this.ExistsMessage(newS);
                            return;
                        }
                        ConfigSet cs = (ConfigSet)WorkingSetConfigAction.this.configSetMap.get(String.valueOf(LocalDialog.this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + oldS);
                        WorkingSetConfigAction.this.configSetMap.remove(cs);
                        cs.name = newS;
                        WorkingSetConfigAction.this.configSetMap.put(key, cs);
                        LocalDialog.this.csets.setItem(n, newS);
                    }
                }
            });
            this.b4 = new Button(c, 8);
            this.b4.setText(UIMessages.getString("WorkingSetConfigAction.9"));
            this.b4.setLayoutData((Object)new GridData(768));
            this.b4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String[] ss = LocalDialog.this.csets.getSelection();
                    if (ss != null && ss.length > 0) {
                        WorkingSetConfigAction.this.configSetMap.remove(String.valueOf(LocalDialog.this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + ss[0]);
                        LocalDialog.this.csets.remove(ss[0]);
                        LocalDialog.this.csets.setSelection(0);
                        LocalDialog.this.updateButtons();
                    }
                }
            });
            this.bb = new Button(c, 8);
            this.bb.setText(UIMessages.getString("WorkingSetConfigAction.20"));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.bb.setLayoutData((Object)gd);
            this.bb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalDialog.this.build();
                    LocalDialog.this.close();
                }
            });
            this.initData();
            return comp;
        }

        private void initData() {
            WorkingSetConfigAction.this.configSetMap = new LinkedHashMap();
            for (String s : CDTPrefUtil.readConfigSets()) {
                ConfigSet cs = new ConfigSet(s);
                if (!cs.isValid()) continue;
                WorkingSetConfigAction.this.configSetMap.put(String.valueOf(cs.workingSetLabel) + WorkingSetConfigAction.DELIMITER + cs.name, cs);
            }
            this.workingSetChanged();
        }

        private void updateButtons() {
            boolean en;
            Button ok = this.getButton(0);
            boolean bl = en = this.csets.getSelectionIndex() > 0;
            if (!this.wsets.getEnabled()) {
                this.b2.setEnabled(false);
                if (ok != null) {
                    ok.setEnabled(false);
                }
                en = false;
            }
            this.b1.setEnabled(en);
            this.b3.setEnabled(en);
            this.b4.setEnabled(en);
            this.bb.setEnabled(this.wsets.getEnabled());
        }

        private void workingSetChanged() {
            this.tree.removeAll();
            String[] ss = this.wsets.getSelection();
            if (ss == null || ss.length == 0) {
                return;
            }
            IWorkingSet ws = (IWorkingSet)WorkingSetConfigAction.this.workingSetsMap.get(ss[0]);
            this.fillTree(ws);
            this.tree.setRedraw(true);
            this.csets.removeAll();
            this.csets.add(CURRENT);
            this.csets.setSelection(0);
            WorkingSetConfigAction.this.configSetMap.remove(CURRENT);
            for (Map.Entry me : WorkingSetConfigAction.this.configSetMap.entrySet()) {
                if (!((ConfigSet)me.getValue()).workingSetLabel.equals(ws.getLabel())) continue;
                this.csets.add(((ConfigSet)me.getValue()).name);
            }
            WorkingSetConfigAction.this.configSetMap.put(CURRENT, new ConfigSet(CURRENT, ws.getLabel(), this.tree));
            this.csets.setRedraw(true);
            this.updateButtons();
            TreeItem[] treeItemArray = this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem ti = treeItemArray[n2];
                ti.setExpanded(true);
                ++n2;
            }
        }

        private void fillTree(IWorkingSet ws) {
            if (ws == null) {
                return;
            }
            IAdaptable[] iAdaptableArray = ws.getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription[] cfgs;
                ICProjectDescription prjd;
                IAdaptable ad = iAdaptableArray[n2];
                IProject p = (IProject)ad.getAdapter(IProject.class);
                if (p != null && (prjd = CoreModel.getDefault().getProjectDescription(p, true)) != null && (cfgs = prjd.getConfigurations()) != null && cfgs.length != 0) {
                    TreeItem ti = new TreeItem(this.tree, 0);
                    ti.setText(prjd.getName());
                    ti.setImage(IMG_PROJ);
                    ti.setData((Object)prjd);
                    ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
                    int n3 = cfgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICConfigurationDescription c = iCConfigurationDescriptionArray[n4];
                        TreeItem ti1 = new TreeItem(ti, 0);
                        ti1.setText(c.getName());
                        ti1.setImage(IMG_CONF);
                        ti1.setChecked(c.isActive());
                        ti1.setData((Object)c);
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        private void configSetChanged() {
            int i = this.csets.getSelectionIndex();
            if (i >= 0) {
                String key = i == 0 ? CURRENT : String.valueOf(this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + this.csets.getItem(i);
                ConfigSet cs = (ConfigSet)WorkingSetConfigAction.this.configSetMap.get(key);
                if (cs != null && cs.isValid()) {
                    TreeItem[] treeItemArray = this.tree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem ti = treeItemArray[n2];
                        ICProjectDescription prjd = (ICProjectDescription)ti.getData();
                        String cid = cs.data.get(prjd.getName());
                        if (cid != null) {
                            TreeItem[] treeItemArray2 = ti.getItems();
                            int n3 = treeItemArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                TreeItem ti1 = treeItemArray2[n4];
                                ICConfigurationDescription cfg = (ICConfigurationDescription)ti1.getData();
                                ti1.setChecked(cid.equals(cfg.getId()));
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            }
            this.updateButtons();
        }

        private String getString(String title, String value) {
            InputDialog d = new InputDialog(sh, title, UIMessages.getString("WorkingSetConfigAction.11"), value, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.indexOf("\f") >= 0) {
                        return String.valueOf(UIMessages.getString("WorkingSetConfigAction.0")) + "\f" + UIMessages.getString("WorkingSetConfigAction.14");
                    }
                    if (WorkingSetConfigAction.this.configSetMap.containsKey(String.valueOf(LocalDialog.this.wsets.getSelection()[0]) + WorkingSetConfigAction.DELIMITER + newText)) {
                        return String.valueOf(UIMessages.getString("WorkingSetConfigAction.15")) + newText + UIMessages.getString("WorkingSetConfigAction.16");
                    }
                    return null;
                }
            });
            if (d.open() == 0) {
                return d.getValue().replace(' ', '_');
            }
            return null;
        }

        private void ExistsMessage(String s) {
            MessageBox box = new MessageBox(sh, 1);
            box.setMessage(String.valueOf(UIMessages.getString("WorkingSetConfigAction.12")) + s);
            box.open();
        }

        private void build() {
            this.saveConfigSets();
            this.saveActiveConfigs();
            IProject[] ps = new IProject[this.tree.getItemCount()];
            int cnt = 0;
            TreeItem[] treeItemArray = this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem ti = treeItemArray[n2];
                ps[cnt++] = ((ICProjectDescription)ti.getData()).getProject();
                ++n2;
            }
            BuildJob buildJob = new BuildJob(ps);
            buildJob.schedule();
        }
    }
}

