/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.EnvDialog;
import org.eclipse.cdt.ui.newui.MultiCfgContributedEnvironment;
import org.eclipse.cdt.ui.newui.PrefPage_Abstract;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class EnvironmentTab
extends AbstractCPropertyTab {
    private static final String SEMI = ";";
    private static final String LBR = " [";
    private static final String RBR = "]";
    private static final UserDefinedEnvironmentSupplier fUserSupplier = EnvironmentVariableManager.fUserSupplier;
    private final MultiCfgContributedEnvironment ce = new MultiCfgContributedEnvironment();
    private Table table;
    private TableViewer tv;
    private ArrayList<TabData> data = new ArrayList();
    private Button b1;
    private Button b2;
    private Label lb1;
    private Label lb2;
    private ICConfigurationDescription cfgd = null;
    private StorableEnvironment vars = null;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(3, true));
        Label l1 = new Label(this.usercomp, 16384);
        l1.setText(UIMessages.getString("EnvironmentTab.0"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l1.setLayoutData((Object)gd);
        this.table = new Table(this.usercomp, 67906);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (EnvironmentTab.this.buttonIsEnabled(2) && EnvironmentTab.this.table.getSelectionIndex() != -1) {
                    EnvironmentTab.this.buttonPressed(2);
                }
            }
        });
        this.tv = new TableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement != null && inputElement instanceof ArrayList) {
                    ArrayList ar = (ArrayList)inputElement;
                    return ar.toArray(new TabData[0]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new EnvironmentLabelProvider(true));
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setText(UIMessages.getString("EnvironmentTab.1"));
        tc.setWidth(150);
        tc = new TableColumn(this.table, 16384);
        tc.setText(UIMessages.getString("EnvironmentTab.2"));
        tc.setWidth(150);
        if (this.getResDesc() != null) {
            tc = new TableColumn(this.table, 16384);
            tc.setText(UIMessages.getString("EnvironmentTab.16"));
            tc.setWidth(100);
        }
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.table.setLayoutData((Object)gd);
        this.b1 = new Button(this.usercomp, 16);
        this.b1.setText(UIMessages.getString("EnvironmentTab.3"));
        this.b1.setToolTipText(UIMessages.getString("EnvironmentTab.3"));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.b1.setLayoutData((Object)gd);
        this.b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnvironmentTab.this.cfgd != null) {
                    EnvironmentTab.this.ce.setAppendEnvironment(true, EnvironmentTab.this.cfgd);
                } else {
                    EnvironmentTab.this.vars.setAppendContributedEnvironment(true);
                }
                EnvironmentTab.this.updateData();
            }
        });
        this.b2 = new Button(this.usercomp, 16);
        this.b2.setText(UIMessages.getString("EnvironmentTab.4"));
        this.b2.setToolTipText(UIMessages.getString("EnvironmentTab.4"));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.b2.setLayoutData((Object)gd);
        this.b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnvironmentTab.this.cfgd != null) {
                    EnvironmentTab.this.ce.setAppendEnvironment(false, EnvironmentTab.this.cfgd);
                } else {
                    EnvironmentTab.this.vars.setAppendContributedEnvironment(false);
                }
                EnvironmentTab.this.updateData();
            }
        });
        if (!this.page.isForPrefs()) {
            new Label(this.usercomp, 0).setLayoutData((Object)new GridData(768));
            this.lb1 = new Label(this.usercomp, 0x1000800);
            this.lb1.setLayoutData((Object)new GridData(768));
            this.lb1.setToolTipText(UIMessages.getString("EnvironmentTab.15"));
            this.lb1.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    CDTPrefUtil.spinDMode();
                    EnvironmentTab.this.updateData();
                }
            });
            this.lb2 = new Label(this.usercomp, 0x1000800);
            this.lb2.setLayoutData((Object)new GridData(768));
            this.lb2.setToolTipText(UIMessages.getString("EnvironmentTab.23"));
            this.lb2.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    CDTPrefUtil.spinWMode();
                    EnvironmentTab.this.updateLbs(null, EnvironmentTab.this.lb2);
                }
            });
        }
        this.initButtons(new String[]{UIMessages.getString("EnvironmentTab.5"), UIMessages.getString("EnvironmentTab.6"), UIMessages.getString("EnvironmentTab.7"), UIMessages.getString("EnvironmentTab.8"), UIMessages.getString("EnvironmentTab.9")});
    }

    public void buttonPressed(int i) {
        switch (i) {
            case 0: {
                this.handleEnvAddButtonSelected();
                break;
            }
            case 1: {
                this.handleEnvSelectButtonSelected();
                break;
            }
            case 2: {
                this.handleEnvEditButtonSelected(this.table.getSelectionIndex());
                break;
            }
            case 3: {
                this.handleEnvDelButtonSelected(this.table.getSelectionIndex());
                break;
            }
            case 4: {
                this.handleEnvUndefButtonSelected(this.table.getSelectionIndex());
            }
        }
        this.table.setFocus();
    }

    protected void updateButtons() {
        boolean canUndef;
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        boolean canEdit = this.table.getSelectionCount() == 1;
        boolean canDel = false;
        boolean bl = canUndef = this.table.getSelectionCount() >= 1;
        if (canUndef) {
            int[] nArray = this.table.getSelectionIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                IEnvironmentVariable var = ((TabData)this.tv.getElementAt((int)i)).var;
                if (this.isUsers(var)) {
                    canDel = true;
                    break;
                }
                ++n2;
            }
        }
        this.buttonSetEnabled(2, canEdit);
        this.buttonSetEnabled(3, canDel);
        this.buttonSetEnabled(4, canUndef);
    }

    protected void updateData(ICResourceDescription _cfgd) {
        ICConfigurationDescription iCConfigurationDescription = this.cfgd = _cfgd != null ? _cfgd.getConfiguration() : null;
        if (this.cfgd == null && this.vars == null) {
            this.vars = fUserSupplier.getWorkspaceEnvironmentCopy();
        } else {
            this.ce.setMulti(this.page.isMultiCfg());
        }
        this.updateData();
    }

    private void updateData() {
        IEnvironmentVariable[] _vars = null;
        if (this.cfgd != null) {
            this.b1.setSelection(this.ce.appendEnvironment(this.cfgd));
            this.b2.setSelection(!this.ce.appendEnvironment(this.cfgd));
            _vars = this.ce.getVariables(this.cfgd);
        } else {
            this.b1.setSelection(this.vars.appendContributedEnvironment());
            this.b2.setSelection(!this.vars.appendContributedEnvironment());
            _vars = this.vars.getVariables();
        }
        this.data.clear();
        if (_vars != null) {
            IEnvironmentVariable[] iEnvironmentVariableArray = _vars;
            int n = _vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable _var = iEnvironmentVariableArray[n2];
                this.data.add(new TabData(_var, false));
                ++n2;
            }
        }
        Collections.sort(this.data);
        this.tv.setInput(this.data);
        this.updateLbs(this.lb1, this.lb2);
        this.updateButtons();
    }

    protected void performApply(ICResourceDescription _src, ICResourceDescription _dst) {
        IEnvironmentVariable element;
        IEnvironmentVariable[] v;
        ICConfigurationDescription src = _src.getConfiguration();
        ICConfigurationDescription dst = _dst.getConfiguration();
        this.ce.setAppendEnvironment(this.ce.appendEnvironment(src), dst);
        IEnvironmentVariable[] iEnvironmentVariableArray = v = this.ce.getVariables(dst);
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            element = iEnvironmentVariableArray[n2];
            this.ce.removeVariable(element.getName(), dst);
            ++n2;
        }
        iEnvironmentVariableArray = v = this.ce.getVariables(src);
        n = v.length;
        n2 = 0;
        while (n2 < n) {
            element = iEnvironmentVariableArray[n2];
            if (this.ce.isUserVariable(src, element)) {
                this.ce.addVariable(element.getName(), element.getValue(), element.getOperation(), element.getDelimiter(), dst);
            }
            ++n2;
        }
    }

    private void handleEnvEditButtonSelected(int n) {
        if (n == -1) {
            return;
        }
        IEnvironmentVariable var = ((TabData)this.tv.getElementAt((int)n)).var;
        EnvDialog dlg = new EnvDialog(this.usercomp.getShell(), var, UIMessages.getString("EnvironmentTab.11"), false, this.page.isMultiCfg(), this.cfgd);
        if (dlg.open() == 0) {
            if (this.cfgd != null) {
                this.ce.addVariable(var.getName(), dlg.t2.trim(), 1, var.getDelimiter(), this.cfgd);
            } else {
                this.vars.createVariable(dlg.t1.trim(), dlg.t2.trim(), 1, var.getDelimiter());
            }
            this.updateData();
            this.table.setSelection(n);
            this.updateButtons();
        }
    }

    private void handleEnvUndefButtonSelected(int n) {
        if (n == -1) {
            return;
        }
        int[] nArray = this.table.getSelectionIndices();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int i = nArray[n3];
            IEnvironmentVariable var = ((TabData)this.tv.getElementAt((int)i)).var;
            if (this.cfgd == null) {
                this.vars.createVariable(var.getName(), null, 2, var.getDelimiter());
            } else {
                this.ce.addVariable(var.getName(), null, 2, var.getDelimiter(), this.cfgd);
            }
            ++n3;
        }
        this.updateData();
        this.table.setSelection(n);
        this.updateButtons();
    }

    private void handleEnvDelButtonSelected(int n) {
        if (n == -1) {
            return;
        }
        int[] nArray = this.table.getSelectionIndices();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int i = nArray[n3];
            IEnvironmentVariable var = ((TabData)this.tv.getElementAt((int)i)).var;
            if (this.cfgd == null) {
                this.vars.deleteVariable(var.getName());
            } else {
                this.ce.removeVariable(var.getName(), this.cfgd);
            }
            ++n3;
        }
        this.updateData();
        int x = this.table.getItemCount() - 1;
        if (x >= 0) {
            this.table.setSelection(Math.min(x, n));
            this.updateButtons();
        }
    }

    private void handleEnvAddButtonSelected() {
        String name;
        IEnvironmentVariable var = null;
        EnvDialog dlg = new EnvDialog(this.usercomp.getShell(), var, UIMessages.getString("EnvironmentTab.10"), true, this.page.isMultiCfg(), this.cfgd);
        if (dlg.open() == 0 && (name = dlg.t1.trim()).length() > 0) {
            ICConfigurationDescription[] cfgs = dlg.toAll ? this.page.getCfgsEditable() : new ICConfigurationDescription[]{this.cfgd};
            if (this.cfgd == null) {
                this.vars.createVariable(name, dlg.t2.trim(), 4, SEMI);
            } else {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
                int n = cfgs.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                    this.ce.addVariable(name, dlg.t2.trim(), 4, SEMI, cfg);
                    ++n2;
                }
            }
            this.updateData();
            this.setPos(name);
        }
    }

    private void setPos(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (name.equals(this.table.getItem(i).getText())) {
                this.table.setSelection(i);
                this.updateButtons();
                break;
            }
            ++i;
        }
    }

    private void handleEnvSelectButtonSelected() {
        Properties v = EnvironmentReader.getEnvVars();
        MyListSelectionDialog dialog = new MyListSelectionDialog(this.usercomp.getShell(), v, this.createSelectionDialogContentProvider());
        dialog.setTitle(UIMessages.getString("EnvironmentTab.14"));
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            ICConfigurationDescription[] cfgs = dialog.toAll ? this.page.getCfgsEditable() : new ICConfigurationDescription[]{this.cfgd};
            String name = null;
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                name = (String)element;
                String value = "";
                int x = name.indexOf(LBR);
                if (x >= 0) {
                    value = name.substring(x + 2, name.length() - 1);
                    name = name.substring(0, x);
                }
                if (this.cfgd == null) {
                    this.vars.createVariable(name, value);
                } else {
                    ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
                    int n3 = cfgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                        this.ce.addVariable(name, value, 4, SEMI, cfg);
                        ++n4;
                    }
                }
                ++n2;
            }
            this.updateData();
            this.setPos(name);
        }
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] els = null;
                if (inputElement instanceof Map) {
                    Map m = (Map)inputElement;
                    els = new String[m.size()];
                    int index = 0;
                    for (String k : m.keySet()) {
                        els[index] = TextProcessor.process((String)(String.valueOf(k) + EnvironmentTab.LBR + m.get(k) + EnvironmentTab.RBR));
                        ++index;
                    }
                }
                Arrays.sort(els, CDTListComparator.getInstance());
                return els;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected void performOK() {
        if (this.vars != null && fUserSupplier.setWorkspaceEnvironment(this.vars) && this.page instanceof PrefPage_Abstract) {
            PrefPage_Abstract.isChanged = true;
        }
        this.vars = null;
        super.performOK();
    }

    protected void performCancel() {
        this.vars = null;
        super.performCancel();
    }

    protected void performDefaults() {
        this.ce.restoreDefaults(this.cfgd);
        this.vars = null;
        this.updateData();
    }

    private boolean isUsers(IEnvironmentVariable var) {
        return this.cfgd == null || this.ce.isUserVariable(this.cfgd, var) && ((EnvVarDescriptor)var).getContextInfo().getContext() != null;
    }

    private class EnvironmentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    ITableFontProvider,
    IColorProvider {
        public EnvironmentLabelProvider(boolean user) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TabData td = (TabData)element;
            switch (columnIndex) {
                case 0: {
                    return td.var.getName();
                }
                case 1: {
                    if (td.var.getOperation() == 2) {
                        return UIMessages.getString(UIMessages.getString("EnvironmentTab.20"));
                    }
                    return td.var.getValue();
                }
                case 2: {
                    return EnvironmentTab.this.ce.getOrigin(td.var);
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            return this.getFont(element, 0);
        }

        public Font getFont(Object element, int columnIndex) {
            TabData td = (TabData)element;
            switch (columnIndex) {
                case 0: {
                    if (!EnvironmentTab.this.isUsers(td.var)) break;
                    return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            TabData td = (TabData)element;
            if (EnvironmentTab.this.isUsers(td.var)) {
                return BACKGROUND_FOR_USER_VAR;
            }
            return null;
        }
    }

    private class MyListSelectionDialog
    extends ListSelectionDialog {
        public boolean toAll;

        public MyListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider) {
            super(parentShell, input, contentProvider, (ILabelProvider)new LabelProvider(){}, UIMessages.getString("EnvironmentTab.12"));
            this.toAll = false;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Button b = new Button(composite, 32);
            b.setText(UIMessages.getString("EnvironmentTab.13"));
            b.setLayoutData((Object)new GridData(768));
            if (EnvironmentTab.this.cfgd == null) {
                b.setVisible(false);
            } else {
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MyListSelectionDialog.this.toAll = ((Button)e.widget).getSelection();
                    }
                });
            }
            return composite;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TabData
    implements Comparable<TabData> {
        IEnvironmentVariable var;
        boolean changed;

        TabData(IEnvironmentVariable _var, boolean _changed) {
            this.var = _var;
            this.changed = _changed;
        }

        @Override
        public int compareTo(TabData a) {
            String s = this.var.getName();
            if (a != null && s != null && a.var != null) {
                return s.compareTo(a.var.getName());
            }
            return 0;
        }
    }
}

