/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IAddressFactory2;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemorySpaceManagement;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CMemoryBlockExtension;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMemoryBlockRetrievalExtension
extends PlatformObject
implements IMemoryBlockRetrievalExtension {
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String MEMORY_BLOCK_EXPRESSION_ITEM = "memoryBlockExpressionItem";
    private static final String MEMORY_BLOCK_EXPRESSION = "expression";
    private static final String MEMORY_BLOCK_MEMSPACEID = "memorySpaceID";
    private static final String ATTR_MEMORY_BLOCK_MEMSPACEID_TEXT = "text";
    private static final String ATTR_MEMORY_BLOCK_EXPRESSION_TEXT = "text";
    CDebugTarget fDebugTarget;

    public CMemoryBlockRetrievalExtension(CDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void initialize() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            String memento = config.getAttribute("org.eclipse.cdt.launch.MEMORY_BLOCKS", "");
            if (memento != null && memento.trim().length() != 0) {
                this.initializeFromMemento(memento);
            }
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
        }
    }

    private void parseMementoExprItem(Element element, List expressions, List memorySpaceIDs) {
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        String exp = null;
        String memorySpaceID = null;
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element entry = (Element)node;
                if (entry.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) {
                    exp = entry.getAttribute("text");
                } else if (entry.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_MEMSPACEID)) {
                    memorySpaceID = entry.getAttribute("text");
                }
            }
            ++i;
        }
        if (exp != null) {
            expressions.add(exp);
            memorySpaceIDs.add(memorySpaceID);
        }
    }

    private void initializeFromMemento(String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            ArrayList expressions = new ArrayList();
            ArrayList memorySpaceIDs = new ArrayList();
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_ITEM)) {
                    this.parseMementoExprItem(entry, expressions, memorySpaceIDs);
                }
                ++i;
            }
            this.createMemoryBlocks(expressions.toArray(new String[expressions.size()]), memorySpaceIDs.toArray(new String[memorySpaceIDs.size()]));
            return;
        }
        this.abort(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.3"), null);
    }

    private BigInteger evaluateLiteralAddress(String addr) {
        IAddressFactory addrFactory = this.getDebugTarget().getAddressFactory();
        if (addrFactory instanceof IAddressFactory2) {
            return ((IAddressFactory2)addrFactory).createAddress(addr, false).getValue();
        }
        return addrFactory.createAddress(addr).getValue();
    }

    private void createMemoryBlocks(String[] expressions, String[] memorySpaceIDs) {
        ArrayList<CMemoryBlockExtension> list = new ArrayList<CMemoryBlockExtension>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            try {
                IAddress address = this.getDebugTarget().getAddressFactory().createAddress(expressions[i]);
                if (address != null) {
                    if (memorySpaceIDs[i] == null) {
                        list.add(new CMemoryBlockExtension(this.getDebugTarget(), address.toHexAddressString(), address.getValue()));
                    } else {
                        list.add(new CMemoryBlockExtension(this.getDebugTarget(), address.getValue(), memorySpaceIDs[i]));
                    }
                }
            }
            catch (NumberFormatException exc) {
                CDebugCorePlugin.log(exc);
            }
            ++i;
        }
        DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(list.toArray(new IMemoryBlock[list.size()]));
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IDebugTarget)this.getDebugTarget());
        Document document = DebugPlugin.newDocument();
        Element exprList = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i] instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension memBlockExt = (IMemoryBlockExtension)blocks[i];
                Element exprItem = document.createElement(MEMORY_BLOCK_EXPRESSION_ITEM);
                exprList.appendChild(exprItem);
                BigInteger addrBigInt = null;
                String memorySpaceID = null;
                if (this.hasMemorySpaces()) {
                    ICDITarget cdiTarget = this.fDebugTarget.getCDITarget();
                    try {
                        StringBuffer sbuf = new StringBuffer();
                        addrBigInt = ((ICDIMemorySpaceManagement)((Object)cdiTarget)).stringToAddress(memBlockExt.getExpression(), sbuf);
                        if (addrBigInt == null) {
                            addrBigInt = CMemoryBlockRetrievalExtension.stringToAddress(memBlockExt.getExpression(), sbuf);
                        }
                        memorySpaceID = sbuf.toString();
                    }
                    catch (CDIException cDIException) {
                    }
                    catch (CoreException coreException) {}
                }
                Element child = document.createElement(MEMORY_BLOCK_EXPRESSION);
                try {
                    if (addrBigInt != null && memorySpaceID != null) {
                        child.setAttribute("text", addrBigInt.toString());
                    } else {
                        child.setAttribute("text", memBlockExt.getBigBaseAddress().toString());
                    }
                    exprItem.appendChild(child);
                }
                catch (DebugException e) {
                    CDebugCorePlugin.log(e.getStatus());
                }
                if (memorySpaceID != null) {
                    child = document.createElement(MEMORY_BLOCK_MEMSPACEID);
                    child.setAttribute("text", memorySpaceID);
                    exprItem.appendChild(child);
                }
            }
            ++i;
        }
        document.appendChild(exprList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    /*
     * Unable to fully structure code
     */
    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object selected) throws DebugException {
        block14: {
            address = null;
            exp = null;
            msg = null;
            try {
                if (!(selected instanceof IDebugElement)) break block14;
                debugElement = (IDebugElement)selected;
                target = debugElement.getDebugTarget();
                if (!(target instanceof CDebugTarget)) {
                    throw new DebugException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
                }
                try {
                    var14_9 = new CMemoryBlockExtension((CDebugTarget)target, expression, this.evaluateLiteralAddress(expression));
                    return var14_9;
                }
                catch (NumberFormatException v0) {
                    block15: {
                        block16: {
                            frame = this.getStackFrame(debugElement);
                            if (frame == null) break block14;
                            cdiExpression = frame.getCDITarget().createExpression(expression);
                            exp = new CExpression(frame, cdiExpression, null);
                            value = exp.getValue();
                            if (!(value instanceof ICValue)) ** GOTO lbl36
                            type = ((ICValue)value).getType();
                            if (type == null) break block15;
                            address = frame.evaluateExpressionToString(exp.getExpressionString());
                            if (address == null) break block14;
                            a = address.startsWith("0x") != false ? new BigInteger(address.substring(2), 16) : new BigInteger(address);
                            var14_10 = new CMemoryBlockExtension((CDebugTarget)target, expression, a);
                            if (exp == null) break block16;
                            exp.dispose();
                        }
                        return var14_10;
                    }
                    try {
                        msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.1"), new String[]{expression});
                        break block14;
lbl36:
                        // 1 sources

                        msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.2"), new String[]{expression});
                    }
                    catch (CDIException e) {
                        msg = e.getMessage();
                        if (exp != null) {
                            exp.dispose();
                        }
                    }
                    catch (NumberFormatException v1) {
                        msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.0"), new String[]{expression});
                    }
                }
            }
            finally {
                if (exp != null) {
                    exp.dispose();
                }
            }
        }
        throw new DebugException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        String expression = Long.toHexString(startAddress);
        BigInteger address = new BigInteger(expression, 16);
        expression = "0x" + expression;
        return new CMemoryBlockExtension(this.getDebugTarget(), expression, address);
    }

    public IMemoryBlockExtension getMemoryBlockWithMemorySpaceID(String address, String memorySpaceID, Object selected) throws DebugException {
        String msg = null;
        try {
            IDebugElement debugElement;
            IDebugTarget target;
            if (selected instanceof IDebugElement && (target = (debugElement = (IDebugElement)selected).getDebugTarget()) instanceof CDebugTarget && address != null) {
                return new CMemoryBlockExtension((CDebugTarget)target, this.evaluateLiteralAddress(address), memorySpaceID);
            }
        }
        catch (NumberFormatException numberFormatException) {
            msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.4"), address);
        }
        throw new DebugException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
    }

    private CStackFrame getStackFrame(IDebugElement selected) throws DebugException {
        IStackFrame frame;
        if (selected instanceof CStackFrame) {
            return (CStackFrame)selected;
        }
        if (selected instanceof CThread && (frame = ((CThread)selected).getTopStackFrame()) instanceof CStackFrame) {
            return (CStackFrame)frame;
        }
        return null;
    }

    public void save() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.MEMORY_BLOCKS", this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    public void dispose() {
    }

    public boolean hasMemorySpaces() {
        return this.getMemorySpaces().length > 0;
    }

    public String[] getMemorySpaces() {
        ICDITarget cdiTarget = this.fDebugTarget.getCDITarget();
        if (cdiTarget instanceof ICDIMemorySpaceManagement) {
            return ((ICDIMemorySpaceManagement)((Object)cdiTarget)).getMemorySpaces();
        }
        return new String[0];
    }

    public static String addressToString(BigInteger address, String memorySpaceID) {
        return String.valueOf(memorySpaceID) + ":0x" + address.toString(16);
    }

    public static BigInteger stringToAddress(String str, StringBuffer memorySpaceID_out) throws CoreException {
        int index = str.lastIndexOf(58);
        if (index == -1 || str.length() <= index + 3 || str.charAt(index + 1) != '0' || str.charAt(index + 2) != 'x') {
            Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.5"), null);
            throw new CoreException((IStatus)s);
        }
        memorySpaceID_out.setLength(0);
        memorySpaceID_out.append(str.substring(0, index));
        return new BigInteger(str.substring(index + 3), 16);
    }
}

