/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointFilterExtension;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugTarget;

public class CBreakpointFilterExtension
implements ICBreakpointFilterExtension {
    private Map fFilteredThreadsByTarget = new HashMap(10);

    public void initialize(ICBreakpoint breakpoint) {
    }

    public ICDebugTarget[] getTargetFilters() throws CoreException {
        Set set = this.fFilteredThreadsByTarget.keySet();
        return set.toArray(new ICDebugTarget[set.size()]);
    }

    public ICThread[] getThreadFilters(ICDebugTarget target) throws CoreException {
        Set set = (Set)this.fFilteredThreadsByTarget.get(target);
        return set != null ? set.toArray(new ICThread[set.size()]) : null;
    }

    public void removeTargetFilter(ICDebugTarget target) throws CoreException {
        if (this.fFilteredThreadsByTarget.containsKey(target)) {
            this.fFilteredThreadsByTarget.remove(target);
        }
    }

    public void removeThreadFilters(ICThread[] threads) throws CoreException {
        Set set;
        IDebugTarget target;
        if (threads != null && threads.length > 0 && this.fFilteredThreadsByTarget.containsKey(target = threads[0].getDebugTarget()) && (set = (Set)this.fFilteredThreadsByTarget.get(target)) != null) {
            set.removeAll((Collection)Arrays.asList(threads));
            if (set.isEmpty()) {
                this.fFilteredThreadsByTarget.remove(target);
            }
        }
    }

    public void setTargetFilter(ICDebugTarget target) throws CoreException {
        this.fFilteredThreadsByTarget.put(target, null);
    }

    public void setThreadFilters(ICThread[] threads) throws CoreException {
        if (threads != null && threads.length > 0) {
            this.fFilteredThreadsByTarget.put(threads[0].getDebugTarget(), new HashSet(Arrays.asList(threads)));
        }
    }
}

